/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.webbook.creator;

import ancestris.modules.webbook.WebBook;
import ancestris.modules.webbook.WebBookParams;
import ancestris.modules.webbook.creator.WebHelper;
import ancestris.modules.webbook.creator.WebSection;
import genj.gedcom.Entity;
import genj.gedcom.Fam;
import genj.gedcom.Indi;
import genj.gedcom.Media;
import genj.gedcom.Property;
import genj.gedcom.PropertyFile;
import genj.gedcom.PropertyMedia;
import java.io.File;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class WebMedia
extends WebSection {
    private static final String POPUPTAG = "popup.htm";
    private int nbPhotoPerRow = 3;
    private List<Photo> photos = null;
    private Comparator<Photo> sortPhotos = new Comparator<Photo>(){

        @Override
        public int compare(Photo p1, Photo p2) {
            if (p1 == null && p2 != null) {
                return -1;
            }
            if (p1 != null && p2 == null) {
                return 1;
            }
            if (p1 == null && p2 == null) {
                return 0;
            }
            String str1 = WebMedia.this.htmlAnchorText(WebMedia.this.getEntityName(p1.getEntity()));
            String str2 = WebMedia.this.htmlAnchorText(WebMedia.this.getEntityName(p2.getEntity()));
            if (str1.startsWith("-")) {
                if (str2.startsWith("-")) {
                    return str1.compareTo(str2);
                }
                return 1;
            }
            if (str2.startsWith("-")) {
                return -1;
            }
            return str1.compareTo(str2);
        }
    };

    public WebMedia(boolean generate, WebBook wb, WebBookParams wp, WebHelper wh) {
        super(generate, wb, wp, wh);
    }

    public void init() {
        if (!this.toBeGenerated) {
            return;
        }
        this.init(this.trs("TXT_Media"), "media", "media_", this.formatFromSize(this.wh.getNbIndis()), 0, 30);
        ArrayList entities = new ArrayList();
        entities.addAll(this.wh.gedcom.getEntities("INDI"));
        entities.addAll(this.wh.gedcom.getEntities("FAM"));
        this.photos = new ArrayList<Photo>();
        List propsToAdd = new ArrayList();
        for (Entity ent : entities) {
            for (Property obje : ent.getAllProperties("OBJE")) {
                if (obje == null || this.isUnderSource(obje)) continue;
                if (obje instanceof PropertyMedia) {
                    Media media = (Media)((PropertyMedia)obje).getTargetEntity();
                    propsToAdd = media.getProperties(PropertyFile.class);
                } else {
                    propsToAdd = obje.getProperties(PropertyFile.class);
                }
                for (PropertyFile pFile : propsToAdd) {
                    this.photos.add(new Photo(ent, pFile));
                }
            }
        }
        Collections.sort(this.photos, this.sortPhotos);
        this.calcLetters(this.photos);
        this.calcPages(this.photos);
        this.wh.setPhotos(this.photos);
    }

    @Override
    public void create() {
        if (!this.toBeGenerated) {
            return;
        }
        if (this.wb.sectionIndividualsDetails != null) {
            this.personPage = this.wb.sectionIndividualsDetails.getPagesMap();
            this.prefixPersonDetailsDir = this.buildLinkShort(this, this.wb.sectionIndividualsDetails);
        }
        File dir = this.wh.createDir(this.wh.getDir().getAbsolutePath() + File.separator + this.sectionDir, true);
        this.exportData(dir, this.photos);
        this.wh.log.write(POPUPTAG + this.trs("EXEC_DONE"));
    }

    private void exportData(File dir, List<Photo> photos) {
        String fileStr = "";
        File file = null;
        PrintWriter out = null;
        String mediafile = "";
        int cpt = 0;
        int nbMedia = photos.size();
        int previousPage = 0;
        int currentPage = 0;
        int nextPage = 0;
        int lastPage = nbMedia / this.nbPerPage + 1;
        fileStr = mediafile = this.sectionPrefix + String.format(this.formatNbrs, 0) + this.sectionSuffix;
        file = this.wh.getFileForName(dir, mediafile);
        out = this.wh.getWriter(file, this.UTF8);
        this.printOpenHTML(out, "TXT_MediaIndex", this);
        out.println("<p class=\"letters\">");
        out.println("<br /><br />");
        for (WebSection.Letters l : WebSection.Letters.values()) {
            if (this.checkLink(l.toString())) {
                out.println("<a href=\"#" + (Object)((Object)l) + "\">" + (Object)((Object)l) + "</a>" + "&nbsp;" + "&nbsp;");
                continue;
            }
            out.println((Object)((Object)l) + "&nbsp;" + "&nbsp;");
        }
        if (this.checkLink("-")) {
            out.println("<a href=\"#-\">-</a>&nbsp;&nbsp;");
        } else {
            out.println("-&nbsp;&nbsp;");
        }
        out.println("<br /><br /></p>");
        this.exportLinks(out, mediafile, 0, 0, 1, lastPage);
        String file_title = "";
        String file_entity = "";
        String href = "";
        String anchor = "";
        char last = ' ';
        for (Photo photo : photos) {
            href = this.getPageForMedia(photo.getFile());
            file_entity = this.wrapEntity(photo.getEntity());
            file_title = this.wrapString((Property)photo.getFile(), photo.getTitle());
            anchor = this.htmlAnchorText(this.getEntityName(photo.getEntity()));
            if (anchor.length() > 0 && Character.toUpperCase(anchor.charAt(0)) != last) {
                last = Character.toUpperCase(anchor.charAt(0));
                String l = String.valueOf(last);
                if (!String.valueOf(last).matches("[a-zA-Z]")) {
                    l = "-";
                }
                anchor = "<p class=\"letter\"><a name=\"" + l + "\"></a>" + l + "</p>";
            } else {
                anchor = "";
            }
            out.println(anchor);
            out.println("<div class=\"conteneur\">");
            out.println("<p class=\"medlist\">" + ++cpt + "</p>");
            out.println("<p class=\"medlisttitle\">" + file_entity + "&nbsp;" + "&nbsp;" + ":" + "&nbsp;" + "&nbsp;" + "<a href=\"" + href + "\">" + file_title + "</a></p><br />");
            out.println("<div class=\"spacer\">&nbsp;</div>");
            out.println("</div>");
        }
        this.exportLinks(out, mediafile, 0, 0, 1, lastPage);
        this.printCloseHTML(out);
        out.close();
        this.wh.log.write(mediafile + this.trs("EXEC_DONE"));
        cpt = 0;
        out = null;
        for (Photo photo : photos) {
            previousPage = (currentPage = (++cpt - 1) / this.nbPerPage + 1) == 1 ? 1 : currentPage - 1;
            nextPage = currentPage == lastPage ? currentPage : currentPage + 1;
            mediafile = this.sectionPrefix + String.format(this.formatNbrs, currentPage) + this.sectionSuffix;
            if (fileStr.compareTo(mediafile) != 0) {
                if (out != null) {
                    this.closeTable(out);
                    this.exportLinks(out, this.sectionPrefix + String.format(this.formatNbrs, currentPage - 1) + this.sectionSuffix, 0, Math.max(1, previousPage - 1), currentPage == lastPage ? lastPage : nextPage - 1, lastPage);
                    this.printCloseHTML(out);
                    out.close();
                    this.wh.log.write(fileStr + this.trs("EXEC_DONE"));
                }
                fileStr = mediafile;
                file = this.wh.getFileForName(dir, mediafile);
                out = this.wh.getWriter(file, this.UTF8);
                this.printOpenHTML(out, "TXT_Media", this);
                this.exportLinks(out, mediafile, 0, previousPage, nextPage, lastPage);
                this.openTable(out);
            }
            this.exportSectionDetails(out, photo, dir, cpt);
        }
        if (out != null) {
            this.closeTable(out);
            this.exportLinks(out, mediafile, 0, previousPage, nextPage, lastPage);
            this.printCloseHTML(out);
            this.wh.log.write(fileStr + this.trs("EXEC_DONE"));
        }
        if (out != null) {
            out.close();
        }
    }

    private void openTable(PrintWriter out) {
        String themeDirMedia = this.buildLinkTheme(this, this.themeDir);
        this.includePopupScript(out);
        out.println("<div><br />");
        out.println("<table class=\"maintable\" border=\"0\" cellspacing=\"0\" cellpadding=\"0\" >");
        out.println("<tr style=\"height:30px\">");
        out.println("<td style=\"width:30px; height:30px; background:url('" + themeDirMedia + "upleft.png') no-repeat right bottom\">" + "&nbsp;" + "&nbsp;" + "&nbsp;" + "&nbsp;" + "&nbsp;" + "</td>");
        out.println("<td style=\"background:url('" + themeDirMedia + "upbar.png') repeat-x left bottom\"></td>");
        out.println("<td style=\"width:30px; height:30px; background:url('" + themeDirMedia + "upright.png') no-repeat left bottom\">" + "&nbsp;" + "&nbsp;" + "&nbsp;" + "&nbsp;" + "&nbsp;" + "</td>");
        out.println("</tr>");
        out.println("<tr>");
        out.println("<td style=\"background:url('" + themeDirMedia + "leftbar.png') repeat-y right bottom\">" + "&nbsp;" + "&nbsp;" + "&nbsp;" + "&nbsp;" + "&nbsp;" + "&nbsp;" + "&nbsp;" + "&nbsp;" + "&nbsp;" + "&nbsp;" + "</td>");
        out.println("<td>");
        out.println("<table border=\"0\" class=\"thumbnail-table\">");
    }

    private void closeTable(PrintWriter out) {
        String themeDirMedia = this.buildLinkTheme(this, this.themeDir);
        out.println("</tr>");
        out.println("</table>");
        out.println("</td>");
        out.println("<td style=\"background:url('" + themeDirMedia + "rightbar.png') repeat-y left\">" + "&nbsp;" + "&nbsp;" + "&nbsp;" + "&nbsp;" + "&nbsp;" + "&nbsp;" + "&nbsp;" + "&nbsp;" + "&nbsp;" + "&nbsp;" + "</td>");
        out.println("</tr>");
        out.println("<tr style=\"height:30px\">");
        out.println("<td style=\"width:30px; height:30px; background:url('" + themeDirMedia + "downleft.png') repeat-x right top\">" + "&nbsp;" + "&nbsp;" + "&nbsp;" + "&nbsp;" + "&nbsp;" + "</td>");
        out.println("<td style=\"background:url('" + themeDirMedia + "downbar.png') repeat-x top\"></td>");
        out.println("<td style=\"width:30px; height:30px; background:url('" + themeDirMedia + "downright.png') repeat-x left top\">" + "&nbsp;" + "&nbsp;" + "&nbsp;" + "&nbsp;" + "&nbsp;" + "</td>");
        out.println("</tr>");
        out.println("</table>");
        out.println("<br /></div>");
    }

    private void exportSectionDetails(PrintWriter out, Photo photo, File dir, int cpt) {
        if ((cpt - 1) / this.nbPhotoPerRow * this.nbPhotoPerRow == cpt - 1) {
            if (cpt - 1 != (cpt - 1) / this.nbPerPage * this.nbPerPage) {
                out.println("</tr>");
            }
            out.println("<tr class=\"thumbnail-row\" >");
        }
        out.println("<td class=\"thumbnail-col\" >");
        out.println("<a name=\"" + photo.getFile().hashCode() + "\"></a>");
        Entity target = photo.getEntity();
        out.println(this.wrapMedia(dir, photo.getFile(), "", true, !this.wp.param_media_CopyMedia.equals("1"), true, true, "", target.getValue().trim(), true, "OBJE:NOTE", "tooltip"));
        out.println(this.wrapEntity(target, true, 0, true, true, true, true));
        out.println("<br />&nbsp;<br />&nbsp;");
        out.println("</td>");
    }

    public String getEntityName(Entity ent) {
        String name = "";
        if (ent == null) {
            return "";
        }
        if (ent instanceof Indi) {
            name = ((Indi)ent).getLastName() + ((Indi)ent).getFirstName();
        } else if (ent instanceof Fam) {
            Indi mainIndi = ((Fam)ent).getHusband();
            if (mainIndi == null) {
                mainIndi = ((Fam)ent).getWife();
            }
            if (mainIndi == null) {
                return "";
            }
            name = mainIndi.getLastName() + mainIndi.getFirstName();
        } else {
            return "";
        }
        return name;
    }

    private void calcPages(List<Photo> photos) {
        String mediafile = "";
        int cpt = 0;
        for (Photo photo : photos) {
            mediafile = this.sectionPrefix + String.format(this.formatNbrs, cpt / this.nbPerPage + 1) + this.sectionSuffix + "#" + photo.getFile().hashCode();
            this.mediaPage.put(photo.getFile().hashCode(), mediafile);
            ++cpt;
        }
    }

    public String getPageForMedia(PropertyFile pFile) {
        return pFile == null ? "" : (String)this.mediaPage.get(pFile.hashCode());
    }

    private void calcLetters(List<Photo> photos) {
        this.linkForLetter.put("-", "0");
        for (WebSection.Letters l : WebSection.Letters.values()) {
            this.linkForLetter.put(l.toString(), "0");
        }
        char letter = ' ';
        for (Photo photo : photos) {
            char cLetter;
            String str = this.htmlAnchorText(this.getEntityName(photo.getEntity()));
            if (str == null || (cLetter = str.charAt(0)) == letter) continue;
            letter = cLetter;
            String l = String.valueOf(letter);
            this.linkForLetter.put(l, "true");
        }
    }

    private boolean checkLink(String str) {
        String flag = (String)this.linkForLetter.get(str);
        return flag != null && flag.compareTo("0") != 0;
    }

    public class Photo {
        private Entity entity = null;
        private PropertyFile pFile = null;
        private String title = null;

        public Photo(Entity entity, PropertyFile pFile) {
            this.entity = entity;
            this.pFile = pFile;
            this.title = WebMedia.this.wh.getTitle(pFile, "-");
        }

        public Entity getEntity() {
            return this.entity;
        }

        public String getTitle() {
            return this.entity.getDisplayValue() + " " + this.title;
        }

        public PropertyFile getFile() {
            return this.pFile;
        }
    }
}

