/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.webbook.creator;

import ancestris.modules.webbook.WebBook;
import ancestris.modules.webbook.WebBookParams;
import ancestris.modules.webbook.creator.WebHelper;
import ancestris.modules.webbook.creator.WebSection;
import java.io.File;
import java.io.PrintWriter;
import java.util.Iterator;

public class WebLastnames
extends WebSection {
    private WebSection sectionList = null;

    public WebLastnames(boolean generate, WebBook wb, WebBookParams wp, WebHelper wh) {
        super(generate, wb, wp, wh);
    }

    public void init() {
        this.init(this.trs("TXT_Lastnames"), "names", "names", "", 1, 0);
    }

    @Override
    public void create() {
        File dir = this.wh.createDir(this.wh.getDir().getAbsolutePath() + (this.sectionDir.length() == 0 ? "" : File.separator + this.sectionDir), true);
        File file = this.wh.getFileForName(dir, this.sectionPrefix + this.sectionSuffix);
        PrintWriter out = this.wh.getWriter(file, this.UTF8);
        this.sectionList = this.wb.sectionIndividuals;
        this.printOpenHTML(out, "TXT_Lastnames", this);
        this.calcLetters();
        this.exportData(dir, out);
        this.printLinks(out, this.sectionPrefix + this.sectionSuffix, this);
        this.printCloseHTML(out);
        out.close();
        this.wh.log.write(this.sectionPrefix + this.sectionSuffix + this.trs("EXEC_DONE"));
    }

    private void exportData(File dir, PrintWriter out) {
        out.println("<p class=\"letters\">");
        out.println("<br /><br />");
        for (WebSection.Letters l : WebSection.Letters.values()) {
            if (this.checkLink(l.toString())) {
                out.println("<a href=\"#" + (Object)((Object)l) + "\">" + (Object)((Object)l) + "</a>" + "&nbsp;" + "&nbsp;");
                continue;
            }
            out.println((Object)((Object)l) + "&nbsp;" + "&nbsp;");
        }
        if (this.checkLink("-")) {
            out.println("<a href=\"#-\">-</a>&nbsp;&nbsp;");
        } else {
            out.println("-&nbsp;&nbsp;");
        }
        out.println("</p>");
        this.printLinks(out, this.sectionPrefix + this.sectionSuffix, this);
        Iterator<String> it = this.wh.getLastNames("-", this.sortLastnames).iterator();
        char last = ' ';
        int cpt = 1;
        int iNames = 1;
        out.println("<p class=\"nameblock\">");
        while (it.hasNext()) {
            String name = it.next().toString();
            String anchor = this.htmlAnchorText(name);
            if (anchor.length() > 0 && Character.toUpperCase(anchor.charAt(0)) != last) {
                last = Character.toUpperCase(anchor.charAt(0));
                String l = String.valueOf(last);
                out.println("</p>");
                out.println("<p class=\"char\">");
                out.println("<a name=\"" + l + "\"></a>");
                out.println(l + "<br /></p>");
                cpt = 1;
                out.println("<p class=\"nameblock\">");
            }
            String listfile = this.buildLink(this, this.sectionList, iNames);
            out.print("<span class=\"name\">");
            out.print("<a href=\"" + listfile + '#' + anchor + "\">" + this.htmlText(name) + "</a>" + "&nbsp;");
            out.print("<span class=\"occu\">(" + this.wh.getLastNameCount(name, "-") + ")</span>");
            out.print("</span>&nbsp;&nbsp;&nbsp;");
            ++iNames;
            if (++cpt <= 7) continue;
            out.print("<br />");
            cpt = 1;
        }
        out.println("</p>");
    }

    private void calcLetters() {
        this.linkForLetter.put("-", "0");
        for (WebSection.Letters l : WebSection.Letters.values()) {
            this.linkForLetter.put(l.toString(), "0");
        }
        Iterator<String> it = this.wh.getLastNames("-", this.sortLastnames).iterator();
        while (it.hasNext()) {
            String name = it.next().toString();
            String l = name.length() > 0 ? name.substring(0, 1).toUpperCase() : "-";
            try {
                WebSection.Letters.valueOf(l);
            }
            catch (IllegalArgumentException e) {
                l = "-";
            }
            this.linkForLetter.put(l, "1");
        }
    }

    private boolean checkLink(String str) {
        String flag = (String)this.linkForLetter.get(str);
        return flag != null && flag.compareTo("0") != 0;
    }
}

