/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.webbook.creator;

import ancestris.gedcom.privacy.PrivacyPolicy;
import ancestris.modules.webbook.Log;
import ancestris.modules.webbook.WebBookParams;
import ancestris.modules.webbook.creator.Ancestor;
import ancestris.modules.webbook.creator.WebMedia;
import ancestris.modules.webbook.transfer.FTPRegister;
import genj.gedcom.Entity;
import genj.gedcom.Fam;
import genj.gedcom.Gedcom;
import genj.gedcom.GedcomException;
import genj.gedcom.Indi;
import genj.gedcom.Property;
import genj.gedcom.PropertyDate;
import genj.gedcom.PropertyFile;
import genj.gedcom.PropertyPlace;
import genj.gedcom.PropertySource;
import genj.gedcom.Source;
import genj.gedcom.time.Calendar;
import genj.gedcom.time.PointInTime;
import genj.io.InputSource;
import java.awt.Container;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.math.BigInteger;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import java.text.Normalizer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import javax.imageio.ImageIO;
import org.openide.filesystems.FileUtil;

public class WebHelper {
    public Gedcom gedcom;
    public Log log;
    public WebBookParams wp;
    public Indi indiDeCujus = null;
    private List<Indi> individualsList = null;
    private List<WebMedia.Photo> photosList = null;
    private List<Source> sourcesList = null;
    private FTPRegister uploadRegister = null;
    public final String DEFCHAR = "-";
    private MediaTracker mediaTracker = new MediaTracker(new Container());
    private SortedMap<String, Integer> listOfLastnames = null;
    private boolean initLastname = false;
    private SortedMap<String, Info> listOfCities = null;
    private boolean initCity = false;
    private SortedMap<String, Info> listOfDays = null;
    private boolean initDay = false;
    private List<Ancestor> listOfAncestors = new ArrayList<Ancestor>();
    private boolean initAncestors = false;
    private Set<Indi> listOfCousins = new HashSet<Indi>();
    private boolean initCousins = false;
    public Comparator<Source> sortSources = new Comparator<Source>(){

        @Override
        public int compare(Source o1, Source o2) {
            return WebHelper.this.extractNumber(o1.getId()) - WebHelper.this.extractNumber(o2.getId());
        }
    };
    Comparator<Ancestor> sortAncestors = new Comparator<Ancestor>(){

        @Override
        public int compare(Ancestor a1, Ancestor a2) {
            return a1.sosa.compareTo(a2.sosa);
        }
    };
    private PrivacyPolicy privacyPolicy = null;

    public WebHelper(Gedcom gedcom, Log log, WebBookParams wp) {
        this.gedcom = gedcom;
        this.log = log;
        this.wp = wp;
    }

    public void setUploadRegister(FTPRegister ulReg) {
        this.uploadRegister = ulReg;
    }

    public File getDir() {
        return new File(this.wp.param_localWebDir);
    }

    public void cleanLocalDir() {
        this.emptyDir(new File(this.wp.param_localWebDir), false);
    }

    public boolean emptyDir(File dir, boolean removeDir) {
        if (dir.isDirectory()) {
            String[] children = dir.list();
            for (int i = 0; i < children.length; ++i) {
                boolean success = this.emptyDir(new File(dir, children[i]), true);
                if (success) continue;
                return false;
            }
        }
        if (removeDir && !dir.getAbsolutePath().equals(this.wp.param_logFile)) {
            return dir.delete();
        }
        return true;
    }

    public File createDir(String outfile, boolean create) {
        String parent = new File(outfile).getAbsoluteFile().getParent();
        if (parent == null || parent.length() == 0) {
            return null;
        }
        File fp = new File(parent);
        if (!fp.exists()) {
            String[] dirs = parent.split("[" + File.separator + File.separator + "]");
            String absoluteDir = dirs[0] + File.separator;
            for (int i = 1; i < dirs.length; ++i) {
                String dir = dirs[i];
                File ad = new File(absoluteDir = absoluteDir + dir + File.separator);
                if (ad.exists()) continue;
                ad.mkdir();
                this.putSecurityFile(ad);
            }
        }
        File f = new File(outfile);
        if (create) {
            f.mkdir();
            this.putSecurityFile(f);
        }
        return f;
    }

    private void putSecurityFile(File dir) {
        if (this.wp.param_PHP_Support.equals("1")) {
            File file = this.getFileForName(dir, "index.php");
            PrintWriter out = this.getWriter(file, Charset.forName("UTF-8"));
            out.println("<?php header('Location: ../index.php'); die; ?>");
            out.close();
        }
    }

    public File getFileForName(File dir, String fileName) {
        return new File(dir, fileName);
    }

    public PrintWriter getWriter(File file, Charset cs) {
        PrintWriter pw = null;
        try {
            pw = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), cs));
            if (this.uploadRegister != null) {
                this.uploadRegister.update(file);
            }
        }
        catch (IOException e) {
            this.log.write(this.log.ERROR, "getWriter - " + e.getMessage());
        }
        return pw;
    }

    public String getCleanFileName(String input, String defchar) {
        String str = input.substring(Math.max(0, input.lastIndexOf(":") + 1));
        while (str.startsWith("\\")) {
            str = str.substring(1);
        }
        while (str.startsWith("/")) {
            str = str.substring(1);
        }
        String temp = str.replaceAll("\\s", "_");
        int i = temp.indexOf(63);
        if (i > 0) {
            temp = temp.substring(0, i);
        }
        String cleanName = this.fileNameConvert(temp, defchar);
        return cleanName;
    }

    public String fileNameConvert(String filename, String defchar) {
        if (filename == null) {
            return "null";
        }
        String text = filename.toLowerCase();
        char[] charInput = text.toCharArray();
        StringBuilder strOutput = new StringBuilder(1000);
        for (int i = 0; i < charInput.length; ++i) {
            strOutput.append(this.convertChar(charInput[i], false, defchar));
        }
        return strOutput.toString();
    }

    public void copyFiles(String imagesDir, String toFile, String fromDir) {
        try {
            URL dirURL = this.wp.getClass().getClassLoader().getResource(this.wp.getClass().getName().replace(".", "/") + ".class");
            if (dirURL.getProtocol().equals("jar")) {
                String jarPath = dirURL.getPath().substring(5, dirURL.getPath().indexOf("!"));
                JarFile jar = new JarFile(URLDecoder.decode(jarPath, "UTF-8"));
                Enumeration<JarEntry> entries = jar.entries();
                HashSet<String> result = new HashSet<String>();
                while (entries.hasMoreElements()) {
                    String entry;
                    int checkSubdir;
                    String name = entries.nextElement().getName();
                    if (!name.startsWith(imagesDir) || (checkSubdir = (entry = name.substring(imagesDir.length())).indexOf("/")) >= 0 || entry.trim().isEmpty()) continue;
                    result.add(entry);
                }
                String[] list = result.toArray(new String[result.size()]);
                for (int i = 0; i < list.length; ++i) {
                    String fileName = list[i];
                    this.copy(fromDir + fileName, toFile + fileName);
                }
            }
        }
        catch (IOException e) {
            this.log.write(this.log.ERROR, "copyFiles - " + e.getMessage());
        }
    }

    public String convertChar(char c, boolean isAnchor, String defchar) {
        String str;
        switch (c) {
            case '\u00e0': {
                str = "a";
                break;
            }
            case '\u00e1': {
                str = "a";
                break;
            }
            case '\u00e2': {
                str = "a";
                break;
            }
            case '\u00e3': {
                str = "a";
                break;
            }
            case '\u00e4': {
                str = "a";
                break;
            }
            case '\u00e5': {
                str = "a";
                break;
            }
            case '\u00e6': {
                str = "ae";
                break;
            }
            case '\u00e7': {
                str = "c";
                break;
            }
            case '\u00e8': {
                str = "e";
                break;
            }
            case '\u00e9': {
                str = "e";
                break;
            }
            case '\u00ea': {
                str = "e";
                break;
            }
            case '\u00eb': {
                str = "e";
                break;
            }
            case '\u00ec': {
                str = "i";
                break;
            }
            case '\u00ed': {
                str = "i";
                break;
            }
            case '\u00ee': {
                str = "i";
                break;
            }
            case '\u00ef': {
                str = "i";
                break;
            }
            case '\u00f0': {
                str = "o";
                break;
            }
            case '\u00f1': {
                str = "n";
                break;
            }
            case '\u00f2': {
                str = "o";
                break;
            }
            case '\u00f3': {
                str = "o";
                break;
            }
            case '\u00f4': {
                str = "o";
                break;
            }
            case '\u00f5': {
                str = "o";
                break;
            }
            case '\u00f6': {
                str = "o";
                break;
            }
            case '\u00f8': {
                str = "o";
                break;
            }
            case '\u00f9': {
                str = "u";
                break;
            }
            case '\u00fa': {
                str = "u";
                break;
            }
            case '\u00fb': {
                str = "u";
                break;
            }
            case '\u00fc': {
                str = "u";
                break;
            }
            case '\u00fd': {
                str = "y";
                break;
            }
            case '\u00fe': {
                str = "p";
                break;
            }
            case '\u00ff': {
                str = "y";
                break;
            }
            case '\u00df': {
                str = "ss";
                break;
            }
            default: {
                String str2 = String.valueOf(c);
                if (str2.matches("[a-zA-Z0-9]")) {
                    return str2;
                }
                if (str2.compareTo(".") == 0) {
                    return isAnchor ? defchar : str2;
                }
                if (str2.compareTo("/") == 0) {
                    return isAnchor ? defchar : str2;
                }
                if (str2.compareTo("\\") == 0) {
                    return isAnchor ? defchar : str2;
                }
                return defchar;
            }
        }
        return str;
    }

    public void setPhotos(List<WebMedia.Photo> photos) {
        this.photosList = photos;
    }

    public List<WebMedia.Photo> getPhoto(Entity entity) {
        ArrayList<WebMedia.Photo> ret = new ArrayList<WebMedia.Photo>();
        for (WebMedia.Photo photo : this.photosList) {
            if (!photo.getEntity().equals(entity)) continue;
            ret.add(photo);
        }
        return ret;
    }

    public String getTitle(PropertyFile media, String defchar) {
        String str = "";
        Property ptitle = media.getProperty("TITL");
        if (ptitle != null && !(str = ptitle.getDisplayValue().trim()).isEmpty()) {
            return str;
        }
        ptitle = media.getParent().getProperty("TITL");
        if (ptitle != null && !(str = ptitle.getDisplayValue().trim()).isEmpty()) {
            return str;
        }
        InputSource file = media.getInput().orElse(null);
        if (file != null) {
            String filename = file.getName();
            return this.getCleanFileName(filename, defchar);
        }
        str = media.toString();
        return str.substring(str.lastIndexOf(File.separator) + 1);
    }

    public void copy(String from_name, String to_name) throws IOException {
        File to_file = new File(to_name);
        FileOutputStream fos = new FileOutputStream(to_file);
        FileUtil.copy((InputStream)this.wp.getClass().getResourceAsStream(from_name), (OutputStream)fos);
        if (this.uploadRegister != null) {
            this.uploadRegister.update(to_file);
        }
        fos.close();
    }

    public String readStream(String from_name) throws IOException {
        InputStream is = this.wp.getClass().getResourceAsStream(from_name);
        byte[] bytes = new byte[is.available()];
        is.read(bytes);
        is.close();
        return new String(bytes, "UTF8");
    }

    public void copy(String from_name, String to_name, boolean linkOnly) throws IOException {
        this.copy(from_name, to_name, linkOnly, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void copy(String from_name, String to_name, boolean linkOnly, boolean force) throws IOException {
        File to_file;
        block33: {
            boolean IS_UNIX;
            String OS_NAME;
            File from_file = new File(from_name);
            to_file = new File(to_name);
            if (to_file.exists() && !force) {
                if (this.uploadRegister != null) {
                    this.uploadRegister.update(to_file);
                }
                return;
            }
            if (!from_file.exists()) {
                this.abort("FileCopy: no such source file: " + from_name);
            }
            if (!from_file.isFile()) {
                this.abort("FileCopy: can't copy directory: " + from_name);
            }
            if (!from_file.canRead()) {
                this.abort("FileCopy: source file is unreadable: " + from_name);
            }
            if (to_file.isDirectory()) {
                to_file = new File(to_file, from_file.getName());
            }
            if (to_file.exists()) {
                if (!to_file.canWrite()) {
                    this.abort("FileCopy: destination file is unwriteable: " + to_name);
                }
            } else {
                File dir;
                String parent = to_file.getParent();
                if (parent == null) {
                    parent = System.getProperty("user.dir");
                }
                if (!(dir = new File(parent)).exists()) {
                    this.createDir(to_name, false);
                }
                if (dir.isFile()) {
                    this.abort("FileCopy: destination is not a directory: " + parent);
                }
                if (!dir.canWrite()) {
                    this.abort("FileCopy: destination directory is unwriteable: " + parent);
                }
            }
            if ((OS_NAME = System.getProperty("os.name")) == null) {
                OS_NAME = "";
            }
            boolean IS_OS2 = OS_NAME.startsWith("OS/2");
            boolean IS_MAC = OS_NAME.startsWith("Mac");
            boolean IS_OSX = OS_NAME.startsWith("mac os x");
            boolean IS_WINDOWS = OS_NAME.startsWith("Windows");
            boolean bl = IS_UNIX = !IS_OS2 && !IS_WINDOWS && !IS_MAC;
            if (!IS_UNIX) {
                linkOnly = false;
            }
            try {
                if (linkOnly) {
                    String[] command = new String[]{"ln", "-s", from_name, to_name};
                    Runtime.getRuntime().exec(command);
                    break block33;
                }
                FileInputStream from = null;
                FileOutputStream to = null;
                try {
                    int bytes_read;
                    from = new FileInputStream(from_file);
                    to = new FileOutputStream(to_file);
                    byte[] buffer = new byte[4096];
                    while ((bytes_read = from.read(buffer)) != -1) {
                        to.write(buffer, 0, bytes_read);
                    }
                }
                finally {
                    if (from != null) {
                        try {
                            from.close();
                        }
                        catch (IOException e) {
                            this.log.write(this.log.ERROR, "copy (from) - " + e.getMessage());
                        }
                    }
                    if (to != null) {
                        try {
                            to.close();
                        }
                        catch (IOException e) {
                            this.log.write(this.log.ERROR, "copy (to) - " + e.getMessage());
                        }
                    }
                }
            }
            catch (Exception e) {
                this.log.write(this.log.ERROR, "copy - " + e.getMessage());
            }
        }
        if (this.uploadRegister != null) {
            this.uploadRegister.update(to_file);
        }
    }

    private void abort(String msg) throws IOException {
        this.log.write(this.log.ERROR, "abort - " + msg);
        throw new IOException(msg);
    }

    public boolean isImage(String infile) {
        if (infile == null) {
            return false;
        }
        return infile.toLowerCase().endsWith(".jpg") || infile.toLowerCase().endsWith(".png") || infile.toLowerCase().endsWith(".bmp") || infile.toLowerCase().endsWith(".gif");
    }

    String getImageSize(String absoluteFile, String quote) {
        Image image = Toolkit.getDefaultToolkit().getImage(absoluteFile);
        this.mediaTracker.addImage(image, 0);
        try {
            this.mediaTracker.waitForID(0);
        }
        catch (Exception e) {
            return "100" + quote + "," + quote + "100";
        }
        int imageHeight = image.getHeight(null);
        int imageWidth = image.getWidth(null);
        this.mediaTracker.removeImage(image);
        image.flush();
        return "" + imageWidth + quote + "," + quote + imageHeight;
    }

    public boolean scaleImage(String infile, String outfile, int width, int height, int quality) {
        return this.scaleImage(infile, outfile, width, height, quality, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean scaleImage(String infile, String outfile, int width, int height, int quality, boolean force) {
        double thumbRatio;
        File out_file = new File(outfile);
        if (out_file.exists() && !force) {
            if (this.uploadRegister != null) {
                this.uploadRegister.update(out_file);
            }
            return true;
        }
        boolean result = false;
        Image image = Toolkit.getDefaultToolkit().getImage(infile);
        this.mediaTracker.addImage(image, 0);
        try {
            this.mediaTracker.waitForID(0);
        }
        catch (Exception e) {
            this.log.write(this.log.ERROR, "scaleImage (mediaTracker) - " + e.getMessage());
        }
        int imageWidth = image.getWidth(null);
        int imageHeight = image.getHeight(null);
        if (imageWidth <= 0 || imageHeight <= 0) {
            this.mediaTracker.removeImage(image);
            image.flush();
            return false;
        }
        double imageRatio = (double)imageWidth / (double)imageHeight;
        int thumbWidth = width;
        int thumbHeight = height;
        if (width == 0) {
            thumbWidth = (int)((double)thumbHeight * imageRatio);
        }
        if (height == 0) {
            thumbHeight = (int)((double)thumbWidth / imageRatio);
        }
        if ((thumbRatio = (double)thumbWidth / (double)thumbHeight) < imageRatio) {
            thumbHeight = (int)((double)thumbWidth / imageRatio);
        } else {
            thumbWidth = (int)((double)thumbHeight * imageRatio);
        }
        FilterOutputStream out = null;
        try {
            BufferedImage thumbImage = new BufferedImage(thumbWidth, thumbHeight, 1);
            Graphics2D graphics2D = thumbImage.createGraphics();
            graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
            graphics2D.drawImage(image, 0, 0, thumbWidth, thumbHeight, null);
            this.createDir(outfile, false);
            ImageIO.write((RenderedImage)thumbImage, "jpeg", out_file);
            result = true;
        }
        catch (Exception e) {
            this.log.write(this.log.ERROR, "scaleImage (encoding) - " + e.getMessage());
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException e) {
                    this.log.write(this.log.ERROR, "scaleImage (out) - " + e.getMessage());
                }
            }
        }
        if (this.uploadRegister != null) {
            this.uploadRegister.update(out_file);
        }
        this.mediaTracker.removeImage(image);
        image.flush();
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String readFile(String filename) throws IOException {
        if (filename == null || filename.length() == 0) {
            return "";
        }
        FileInputStream in = null;
        StringBuffer sb = new StringBuffer("");
        try {
            File f = new File(filename);
            in = new FileInputStream(f);
            int size = (int)f.length();
            byte[] data = new byte[size];
            for (int chars_read = 0; chars_read < size; chars_read += in.read(data, chars_read, size - chars_read)) {
            }
            sb.append(new String(data, "UTF8"));
        }
        catch (IOException e) {
            this.log.write(this.log.ERROR, "readFile (read) - " + e.getMessage());
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException e) {
                this.log.write(this.log.ERROR, "readFile (finally) - " + e.getMessage());
            }
        }
        return sb.toString();
    }

    public boolean writeFile(String filename, String text) throws IOException {
        if (filename == null || filename.length() == 0) {
            return false;
        }
        try {
            BufferedWriter out = new BufferedWriter(new FileWriter(filename));
            out.write(text);
            out.close();
        }
        catch (IOException e) {
            this.log.write(this.log.ERROR, "writeFile - " + e.getMessage());
            return false;
        }
        return true;
    }

    public int getNbIndis() {
        return this.gedcom.getIndis().size();
    }

    Indi getIndiDeCujus(String str) {
        if (this.indiDeCujus != null) {
            return this.indiDeCujus;
        }
        Entity[] indis = this.gedcom.getEntities("INDI", "INDI:NAME");
        for (int i = 0; i < indis.length; ++i) {
            Indi indi = (Indi)indis[i];
            if (!indi.toString().equals(str)) continue;
            this.indiDeCujus = indi;
            break;
        }
        return this.indiDeCujus;
    }

    public String getSosa(Indi indi) {
        if (indi == null) {
            return "";
        }
        return indi.getSosaString();
    }

    public List<String> getLastNames(String defchar, Comparator<String> sortLastnames) {
        if (!this.initLastname) {
            this.initLastname = this.buildLastnamesList(this.gedcom, defchar, sortLastnames);
        }
        return new ArrayList<String>(this.listOfLastnames.keySet());
    }

    public int getTotalNamesCount() {
        if (!this.initLastname) {
            this.initLastname = this.buildLastnamesList(this.gedcom, "-", new Comparator<String>(){

                @Override
                public int compare(String t1, String t2) {
                    return t1.compareTo(t2);
                }
            });
        }
        return this.listOfLastnames.size();
    }

    public int getLastNameCount(String lastname, String defchar) {
        String str = lastname;
        if (str == null) {
            str = defchar;
        }
        if (this.listOfLastnames.get(str) == null) {
            return -1;
        }
        return (Integer)this.listOfLastnames.get(str);
    }

    private boolean buildLastnamesList(Gedcom gedcom, String defchar, Comparator<String> sortLastnames) {
        this.listOfLastnames = new TreeMap<String, Integer>(sortLastnames);
        Collection indis = gedcom.getEntities("INDI");
        for (Indi indi : indis) {
            String str = this.getLastName(indi, defchar);
            Integer counter = (Integer)this.listOfLastnames.get(str);
            if (counter == null) {
                counter = 1;
            } else {
                Integer n = counter;
                Integer n2 = counter = Integer.valueOf(counter + 1);
            }
            this.listOfLastnames.put(str, counter);
        }
        return true;
    }

    public String getLastName(Indi indi, String defchar) {
        if (indi == null) {
            return defchar;
        }
        String str = indi.getLastName();
        return str == null ? defchar : (str.isEmpty() ? defchar : str);
    }

    public List<Indi> getIndividuals(Gedcom gedcom, Comparator<Indi> sort) {
        Comparator<Indi> sortIndividuals = sort;
        if (sortIndividuals == null) {
            sortIndividuals = new Comparator<Indi>(){

                @Override
                public int compare(Indi t1, Indi t2) {
                    return t1.compareTo((Property)t2);
                }
            };
        }
        if (this.individualsList == null) {
            this.individualsList = new ArrayList<Indi>(gedcom.getEntities("INDI"));
            Collections.sort(this.individualsList, sortIndividuals);
        }
        return this.individualsList;
    }

    public List<Source> getSources(Gedcom gedcom) {
        if (this.sourcesList == null) {
            this.sourcesList = new ArrayList<Source>(gedcom.getEntities("SOUR"));
            Collections.sort(this.sourcesList, this.sortSources);
        }
        return this.sourcesList;
    }

    public List<Source> getSources(Indi indi) {
        ArrayList sources = new ArrayList();
        this.getPropertiesRecursively((Property)indi, sources, PropertySource.class);
        Fam[] families = indi.getFamiliesWhereSpouse();
        for (int i = 0; families != null && i < families.length; ++i) {
            Fam family = families[i];
            this.getPropertiesRecursively((Property)family, sources, PropertySource.class);
        }
        ArrayList<Source> sourcesOutput = new ArrayList<Source>();
        for (Property propSrc : sources) {
            Source src;
            PropertySource pSource;
            if (!(propSrc instanceof PropertySource) || (pSource = (PropertySource)propSrc) == null || pSource.getTargetEntity() == null || sourcesOutput.contains(src = (Source)pSource.getTargetEntity())) continue;
            sourcesOutput.add(src);
        }
        Collections.sort(sourcesOutput, this.sortSources);
        return sourcesOutput;
    }

    public int extractNumber(String str) {
        int start;
        int end = 0;
        for (start = 0; start <= end && !Character.isDigit(str.charAt(start)); ++start) {
        }
        for (end = start; end <= str.length() - 1 && Character.isDigit(str.charAt(end)); ++end) {
        }
        if (end == start) {
            return 0;
        }
        return Integer.parseInt(str.substring(start, end));
    }

    public List<String> getCities(Gedcom gedcom) {
        if (!this.initCity) {
            this.initCity = this.buildCitiesList(gedcom, new Comparator<String>(){

                @Override
                public int compare(String t1, String t2) {
                    return t1.compareTo(t2);
                }
            });
        }
        return new ArrayList<String>(this.listOfCities.keySet());
    }

    public int getTotalCitiesCount() {
        if (!this.initCity) {
            this.initCity = this.buildCitiesList(this.gedcom, new Comparator<String>(){

                @Override
                public int compare(String t1, String t2) {
                    return t1.compareTo(t2);
                }
            });
        }
        return this.listOfCities.size();
    }

    public int getCitiesCount(String city) {
        if (this.listOfCities.get(city) == null) {
            return -1;
        }
        Info infoCity = (Info)this.listOfCities.get(city);
        return infoCity.counter;
    }

    public List<Property> getCitiesProps(String city) {
        if (this.listOfCities.get(city) == null) {
            return null;
        }
        Info infoCity = (Info)this.listOfCities.get(city);
        return infoCity.props;
    }

    private boolean buildCitiesList(Gedcom gedcom, Comparator<String> sortStrings) {
        Property prop;
        List entities = gedcom.getEntities();
        ArrayList placesProps = new ArrayList();
        for (Entity ent : entities) {
            this.getPropertiesRecursively((Property)ent, placesProps, PropertyPlace.class);
        }
        this.listOfCities = new TreeMap<String, Info>(sortStrings);
        String juridic = "";
        Iterator it = placesProps.iterator();
        while (it.hasNext() && (prop = (Property)it.next()) instanceof PropertyPlace) {
            juridic = Normalizer.normalize(((PropertyPlace)prop).getCity().trim(), Normalizer.Form.NFD).replaceAll("[\\p{InCombiningDiacriticalMarks}]", "");
            if (juridic == null || juridic.length() <= 0) continue;
            Integer val = null;
            List<Property> listProps = null;
            Info infoCity = (Info)this.listOfCities.get(juridic);
            if (infoCity == null) {
                val = 0;
                listProps = new ArrayList<Property>();
                infoCity = new Info();
            } else {
                val = infoCity.counter;
                listProps = infoCity.props;
            }
            val = val + 1;
            listProps.add(prop);
            infoCity.counter = val;
            infoCity.props = listProps;
            this.listOfCities.put(juridic, infoCity);
        }
        return true;
    }

    public <P extends Property> void getPropertiesRecursively(Property parent, List<P> props, Class clazz) {
        Property[] children = parent.getProperties();
        for (int c = 0; c < children.length; ++c) {
            Property child = children[c];
            props.addAll(child.getProperties(clazz));
            this.getPropertiesRecursively(child, props, clazz);
        }
    }

    public List<String> getDays(Gedcom gedcom) {
        if (!this.initDay) {
            this.initDay = this.buildDaysList(gedcom);
        }
        return new ArrayList<String>(this.listOfDays.keySet());
    }

    public int getDaysCount(String day) {
        if (this.listOfDays.get(day) == null) {
            return -1;
        }
        Info infoDay = (Info)this.listOfDays.get(day);
        return infoDay.counter;
    }

    public List<Property> getDaysProps(String day) {
        if (this.listOfDays.get(day) == null) {
            return null;
        }
        Info infoDay = (Info)this.listOfDays.get(day);
        return infoDay.props;
    }

    private boolean buildDaysList(Gedcom gedcom) {
        this.listOfDays = new TreeMap<String, Info>();
        List entities = gedcom.getEntities();
        ArrayList datesProps = new ArrayList();
        for (Entity ent : entities) {
            this.getPropertiesRecursively((Property)ent, datesProps, PropertyDate.class);
        }
        String day = "";
        for (Property prop : datesProps) {
            day = this.getDay(prop);
            if (day == null) continue;
            Integer val = null;
            List<Property> listProps = null;
            Info infoDay = (Info)this.listOfDays.get(day);
            if (infoDay == null) {
                val = 0;
                listProps = new ArrayList<Property>();
                infoDay = new Info();
            } else {
                val = infoDay.counter;
                listProps = infoDay.props;
            }
            val = val + 1;
            listProps.add(prop);
            infoDay.counter = val;
            infoDay.props = listProps;
            this.listOfDays.put(day, infoDay);
        }
        return true;
    }

    public String getDay(Property prop) {
        if (!(prop instanceof PropertyDate)) {
            return null;
        }
        PropertyDate date = (PropertyDate)prop;
        if (!date.isValid() || date.isRange()) {
            return null;
        }
        PointInTime pit = null;
        try {
            pit = date.getStart().getPointInTime((Calendar)PointInTime.GREGORIAN);
            if (pit.getMonth() < 0 || pit.getMonth() > 11) {
                return null;
            }
            if (pit.getDay() < 0 || pit.getDay() > 30) {
                return null;
            }
            return String.format("%02d", pit.getMonth() + 1) + String.format("%02d", pit.getDay() + 1);
        }
        catch (GedcomException gedcomException) {
            return null;
        }
    }

    public List<Ancestor> getAncestorsList(Indi rootIndi) {
        if (!this.initAncestors) {
            this.initAncestors = this.buildAncestors(rootIndi);
        }
        return this.listOfAncestors;
    }

    public Set<Indi> getAncestors(Indi rootIndi) {
        if (!this.initAncestors) {
            this.initAncestors = this.buildAncestors(rootIndi);
        }
        HashSet<Indi> list = new HashSet<Indi>();
        for (Ancestor ancestor : this.listOfAncestors) {
            list.add(ancestor.indi);
        }
        return list;
    }

    private boolean buildAncestors(Indi rootIndi) {
        BigInteger startSosa = BigInteger.ONE;
        ArrayList<Ancestor> list = new ArrayList<Ancestor>(1);
        list.add(new Ancestor(startSosa, rootIndi, 1));
        this.recursion(list, 1);
        Collections.sort(this.listOfAncestors, this.sortAncestors);
        return true;
    }

    void recursion(List<Ancestor> generation, int gen) {
        ArrayList<Ancestor> nextGeneration = new ArrayList<Ancestor>();
        for (Ancestor ances : generation) {
            BigInteger sosa = ances.sosa;
            Indi indi = ances.indi;
            Fam famc = indi.getFamilyWhereBiologicalChild();
            if (famc != null) {
                Indi mother;
                Indi father = famc.getHusband();
                if (father != null) {
                    nextGeneration.add(new Ancestor(sosa.shiftLeft(1), father, gen + 1));
                }
                if ((mother = famc.getWife()) != null) {
                    Ancestor aMother = new Ancestor(sosa.shiftLeft(1).add(BigInteger.ONE), mother, gen + 1);
                    nextGeneration.add(aMother);
                }
            }
            this.listOfAncestors.add(ances);
        }
        if (!nextGeneration.isEmpty()) {
            this.recursion(nextGeneration, gen + 1);
        }
    }

    public Set<Indi> getCousins(Indi rootIndi) {
        if (!this.initCousins) {
            this.initCousins = this.buildCousins(rootIndi);
        }
        return this.listOfCousins;
    }

    private boolean buildCousins(Indi rootIndi) {
        Collection indis = rootIndi.getGedcom().getEntities("INDI");
        Set<Indi> ancestors = this.getAncestors(rootIndi);
        HashSet<Indi> otherIndis = new HashSet<Indi>();
        for (Indi indi : indis) {
            if (ancestors.contains(indi)) continue;
            otherIndis.add(indi);
        }
        for (Indi ancestor : ancestors) {
            HashSet<Indi> descendants = new HashSet<Indi>();
            this.getDescendants(ancestor, otherIndis, descendants);
            this.listOfCousins.addAll(descendants);
            otherIndis.removeAll(descendants);
        }
        return true;
    }

    private void getDescendants(Indi ancestor, Set<Indi> inSet, Set<Indi> descendants) {
        Indi[] children = ancestor.getChildren();
        for (int i = 0; i < children.length; ++i) {
            Indi indi = children[i];
            if (!inSet.contains(indi)) continue;
            descendants.add(indi);
            inSet.remove(indi);
            this.getDescendants(indi, inSet, descendants);
        }
    }

    public PrivacyPolicy getPrivacyPolicy() {
        if (this.privacyPolicy == null) {
            this.privacyPolicy = PrivacyPolicy.getDefault();
        }
        return this.privacyPolicy;
    }

    public boolean isPrivate(Entity ent) {
        if (ent instanceof Indi) {
            return this.isPrivate((Property)ent);
        }
        if (ent instanceof Fam) {
            Fam famRel = (Fam)ent;
            Indi husband = famRel.getHusband();
            Indi wife = famRel.getWife();
            return this.isPrivate((Property)husband) || this.isPrivate((Property)wife);
        }
        return false;
    }

    public boolean isPrivate(Property prop) {
        return prop != null && this.getPrivacyPolicy().isPrivate(prop);
    }

    public String getPrivDisplay() {
        return this.getPrivacyPolicy().getPrivateMask();
    }

    private class Info {
        Integer counter = 0;
        List<Property> props = null;

        private Info() {
        }
    }
}

