/*
 * Decompiled with CFR 0.152.
 */
package ancestris.welcome.ui;

import ancestris.app.FlyerAction;
import ancestris.modules.donation.DonationAction;
import ancestris.tour.TourAction;
import ancestris.util.swing.DialogManager;
import ancestris.welcome.WelcomeOptions;
import ancestris.welcome.content.BundleSupport;
import ancestris.welcome.content.Constants;
import ancestris.welcome.content.LinkButton;
import ancestris.welcome.content.Utils;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URI;
import java.util.logging.Logger;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;

class FeaturesPanel
extends JPanel
implements Constants {
    private final Image ICON1 = ImageUtilities.loadImage((String)"ancestris/welcome/resources/ico_flyer.png");
    private final Image ICON2 = ImageUtilities.loadImage((String)"ancestris/welcome/resources/ico_tour.png");
    private final Image ICON3 = ImageUtilities.loadImage((String)"ancestris/welcome/resources/ico_asso.png");
    private final Image ICON4 = ImageUtilities.loadImage((String)"ancestris/welcome/resources/ico_donation.png");

    public FeaturesPanel() {
        super(new GridBagLayout());
        this.setOpaque(false);
        this.addShowFlyer(BundleSupport.getLabel("Flyer"), this.ICON1, (ActionListener)new FlyerAction());
        this.addShowFlyer(BundleSupport.getLabel("Tour"), this.ICON2, new ShowTour());
        this.addShowFlyer(BundleSupport.getLabel("Asso"), this.ICON3, new ShowAsso());
        this.addShowFlyer(BundleSupport.getLabel("Donation"), this.ICON4, (ActionListener)new DonationAction());
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                String question;
                String title;
                Object o;
                if (WelcomeOptions.getDefault().isFirstStarts() && (o = DialogManager.create((String)(title = NbBundle.getMessage(WelcomeOptions.class, (String)"LBL_Tab_Title")), (String)(question = BundleSupport.getLabel("TourQuestion"))).setMessageType(3).setOptionType(0).show()).equals(DialogManager.OK_OPTION)) {
                    new ShowTour().actionPerformed(null);
                }
            }
        });
    }

    private void addShowFlyer(String label, Image icon, final ActionListener action) {
        LinkButton b = new LinkButton(label, Utils.getColor("HeaderForegroundColor"), true, label){

            @Override
            public void actionPerformed(ActionEvent e) {
                this.logUsage();
                action.actionPerformed(e);
            }
        };
        b.setFont(GET_STARTED_FONT);
        b.setIcon(new ImageIcon(icon));
        this.add(b);
        this.add(Box.createRigidArea(new Dimension(0, 5)));
    }

    public class ShowTour
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent event) {
            boolean supported = true;
            Logger LOG = Logger.getLogger("ancestris.welcome");
            GraphicsEnvironment graphenv = GraphicsEnvironment.getLocalGraphicsEnvironment();
            GraphicsDevice graphdev = graphenv.getDefaultScreenDevice();
            if (!graphdev.isWindowTranslucencySupported(GraphicsDevice.WindowTranslucency.TRANSLUCENT)) {
                LOG.info("Guided Tour : translucency not supported. Will use opaque windows instead.");
            }
            if (supported) {
                new TourAction().actionPerformed(event);
            } else {
                try {
                    Desktop.getDesktop().browse(new URI(NbBundle.getBundle((String)"ancestris.welcome.resources.Bundle").getString("WelcomePage/GettingStartedLinks/tour.url.target")));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    private class ShowAsso
    implements ActionListener {
        private ShowAsso() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            try {
                Desktop.getDesktop().browse(new URI(NbBundle.getMessage(DonationAction.class, (String)"donation_link")));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

