/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.templates;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.text.Format;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.script.ScriptEngine;
import javax.script.ScriptException;
import org.netbeans.api.queries.FileEncodingQuery;
import org.netbeans.api.templates.CreateDescriptor;
import org.netbeans.api.templates.CreateFromTemplateAttributes;
import org.netbeans.api.templates.CreateFromTemplateDecorator;
import org.netbeans.api.templates.CreateFromTemplateHandler;
import org.netbeans.api.templates.FileBuilder;
import org.netbeans.modules.templates.ScriptingCreateFromTemplateHandler;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Lookup;
import org.openide.util.MapFormat;
import org.openide.util.Parameters;

final class CreateFromTemplateImpl {
    private static final String PROP_TEMPLATE = "template";
    private static final String NEWLINE = "\n";
    private final FileBuilder builder;
    private final CreateDescriptor desc;
    private Map<String, ?> originalParams;
    private List<CreateFromTemplateDecorator> decorators;

    private CreateFromTemplateImpl(FileBuilder builder) {
        this.builder = builder;
        this.desc = builder.getDescriptor();
    }

    static List<FileObject> build(FileBuilder flb) throws IOException {
        CreateFromTemplateImpl impl = new CreateFromTemplateImpl(flb);
        return impl.build();
    }

    static void collectAttributes(FileBuilder flb) {
        CreateFromTemplateImpl impl = new CreateFromTemplateImpl(flb);
        flb.withParameters(impl.findTemplateParameters());
    }

    private void setupDecorators() {
        this.decorators = new ArrayList<CreateFromTemplateDecorator>(Lookup.getDefault().lookupAll(CreateFromTemplateDecorator.class));
        Iterator<CreateFromTemplateDecorator> it = this.decorators.iterator();
        while (it.hasNext()) {
            CreateFromTemplateDecorator dec = it.next();
            if (dec.accept(this.desc)) continue;
            it.remove();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<FileObject> build() throws IOException {
        try {
            FileObject f = this.desc.getTemplate();
            FileObject folder = this.desc.getTarget();
            FileBuilder.Mode defaultMode = this.builder.defaultMode;
            Format frm = this.builder.format;
            Parameters.notNull((CharSequence)"f", (Object)f);
            Parameters.notNull((CharSequence)"folder", (Object)folder);
            assert (defaultMode != FileBuilder.Mode.FORMAT || frm != null) : "Format must be provided for Mode.FORMAT";
            if (!folder.isFolder()) {
                throw new IllegalArgumentException("Not a folder: " + folder);
            }
            this.findTemplateParameters();
            this.setupDecorators();
            CreateFromTemplateImpl.computeEffectiveName(this.desc);
            List<FileObject> initialFiles = this.callDecorators(true, new ArrayList<FileObject>());
            List<FileObject> pf = null;
            for (CreateFromTemplateHandler h : Lookup.getDefault().lookupAll(CreateFromTemplateHandler.class)) {
                if (!h.accept(this.desc)) continue;
                pf = h.createFromTemplate(this.desc);
                assert (pf != null && !pf.isEmpty());
                break;
            }
            if (pf == null && defaultMode != FileBuilder.Mode.FAIL) {
                pf = Collections.singletonList(this.defaultCreate());
            }
            if (pf == null) {
                Iterator iterator = pf;
                return iterator;
            }
            ArrayList<FileObject> result = new ArrayList<FileObject>(pf);
            result.addAll(initialFiles);
            this.callDecorators(false, result);
            ArrayList<FileObject> arrayList = result;
            return arrayList;
        }
        finally {
            this.builder.getDescriptor().parameters = this.originalParams;
        }
    }

    private List<FileObject> callDecorators(boolean preCreate, List<FileObject> result) throws IOException {
        for (CreateFromTemplateDecorator deco : this.decorators) {
            List<FileObject> preFiles;
            if (!(preCreate ? deco.isBeforeCreation() : deco.isAfterCreation()) || (preFiles = deco.decorate(this.desc, result)) == null) continue;
            preFiles.removeAll(result);
            result.addAll(preFiles);
        }
        return result;
    }

    static void computeEffectiveName(CreateDescriptor desc) {
        String name = desc.getName();
        if (name == null) {
            Object o = desc.getParameters().get("name");
            name = o instanceof String ? (String)o : FileUtil.findFreeFileName((FileObject)desc.getTarget(), (String)desc.getTemplate().getName(), (String)desc.getTemplate().getExt());
        }
        desc.proposedName = name;
    }

    public Map<String, Object> findTemplateParameters() {
        HashMap<String, Object> all = new HashMap<String, Object>();
        all.putAll(this.desc.getParameters());
        this.originalParams = this.desc.parameters;
        this.desc.parameters = all;
        for (CreateFromTemplateAttributes provider : Lookup.getDefault().lookupAll(CreateFromTemplateAttributes.class)) {
            Map<String, ?> map = provider.attributesFor(this.desc);
            if (map == null) continue;
            for (Map.Entry<String, ?> e : map.entrySet()) {
                if (this.originalParams != null && this.originalParams.containsKey(e.getKey())) continue;
                all.put(e.getKey(), e.getValue());
            }
        }
        String name = this.desc.getName();
        if (!all.containsKey("name") && name != null) {
            String n = name;
            if (this.desc.hasFreeExtension()) {
                n = name.replaceFirst("[.].*", "");
            }
            all.put("name", n);
        }
        Date d = new Date();
        if (!all.containsKey("dateTime")) {
            all.put("dateTime", d);
        }
        String ext = this.desc.getTemplate().getExt();
        if (!all.containsKey("nameAndExt") && name != null) {
            if (!(ext == null || ext.length() <= 0 || this.originalParams == null || this.desc.hasFreeExtension() && name.indexOf(46) != -1)) {
                all.put("nameAndExt", name + '.' + ext);
            } else {
                all.put("nameAndExt", name);
            }
        }
        return all;
    }

    private FileObject defaultCreate() throws IOException {
        Map<String, Object> params = this.desc.getParameters();
        FileBuilder.Mode defaultMode = this.builder.defaultMode;
        Format frm = this.builder.format;
        if (defaultMode != FileBuilder.Mode.COPY && frm instanceof MapFormat) {
            MapFormat mf = (MapFormat)frm;
            Map m = mf.getMap();
            HashMap<String, Object> x = null;
            for (String s : params.keySet()) {
                if (m.containsKey(s)) continue;
                if (x == null) {
                    x = new HashMap<String, Object>(m);
                }
                x.put(s, params.get(s));
            }
            if (x != null) {
                mf.setMap(x);
            }
        }
        FileObject f = this.desc.getTemplate();
        String ext = this.desc.getTemplate().getExt();
        FileObject fo = this.desc.getTarget().createData(this.desc.getProposedName(), ext);
        boolean preformatted = false;
        Charset encoding = FileEncodingQuery.getEncoding((FileObject)f);
        boolean success = false;
        FileLock lock = fo.lock();
        try (InputStream is = f.getInputStream();
             InputStreamReader reader = new InputStreamReader(is, encoding);
             BufferedReader r = new BufferedReader(reader);){
            preformatted = this.desc.isPreformatted();
            encoding = FileEncodingQuery.getEncoding((FileObject)fo);
            ScriptEngine en = this.desc.isPreformatted() ? null : ScriptingCreateFromTemplateHandler.indentEngine();
            StringWriter sw = new StringWriter();
            try (OutputStream os = fo.getOutputStream(lock);
                 OutputStreamWriter w = new OutputStreamWriter(os, encoding);
                 Writer iw = preformatted || en == null ? w : sw;){
                String current;
                String line = null;
                while ((current = r.readLine()) != null) {
                    if (line != null) {
                        iw.append(NEWLINE);
                    }
                    line = frm != null ? frm.format(current) : current;
                    iw.append(line);
                }
                iw.append(NEWLINE);
                iw.flush();
                if (en != null) {
                    en.getContext().setAttribute("mimeType", f.getMIMEType(), 100);
                    en.getContext().setWriter(w);
                    en.eval(new StringReader(sw.toString()));
                }
            }
            FileUtil.copyAttributes((FileObject)f, (FileObject)fo);
            fo.setAttribute(PROP_TEMPLATE, null);
            success = true;
        }
        catch (IOException ex) {
            try {
                fo.delete(lock);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw ex;
        }
        catch (ScriptException ex) {
            IOException io = ex.getCause() instanceof IOException ? (IOException)ex.getCause() : null;
            try {
                fo.delete(lock);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw io == null ? new IOException(ex) : io;
        }
        finally {
            if (!success) {
                fo.delete(lock);
            }
            lock.releaseLock();
        }
        return fo;
    }
}

