/*
 * Decompiled with CFR 0.152.
 */
package org.graphstream.ui.util.swing;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.Serializable;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.HashMap;
import scala.runtime.BoxedUnit;

public final class ImageCache$ {
    public static final ImageCache$ MODULE$;
    private final HashMap<String, BufferedImage> imageCache;
    private BufferedImage dummy;

    static {
        new ImageCache$();
    }

    public HashMap<String, BufferedImage> imageCache() {
        return this.imageCache;
    }

    public BufferedImage dummy() {
        return this.dummy;
    }

    public void dummy_$eq(BufferedImage x$1) {
        this.dummy = x$1;
    }

    public void init() {
        BufferedImage img = new BufferedImage(16, 16, 1);
        Graphics2D g2 = img.createGraphics();
        g2.setColor(Color.RED);
        g2.drawRect(0, 0, img.getWidth() - 1, img.getHeight() - 1);
        g2.drawLine(0, 0, img.getWidth() - 1, img.getHeight() - 1);
        g2.drawLine(0, img.getHeight() - 1, img.getWidth() - 1, 0);
        this.dummy_$eq(img);
    }

    public Option<BufferedImage> loadImage(String fileNameOrUrl) {
        return this.loadImage(fileNameOrUrl, false);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Option<BufferedImage> loadImage(String fileNameOrUrl, boolean forceTryReload) {
        Option option;
        Option<BufferedImage> option2 = this.imageCache().get(fileNameOrUrl);
        None$ none$ = None$.MODULE$;
        Option<BufferedImage> option3 = option2;
        if (!(none$ != null ? !none$.equals(option3) : option3 != null)) {
            Serializable serializable2;
            URL url = this.getClass().getClassLoader().getResource(fileNameOrUrl);
            BufferedImage image = null;
            if (url == null) {
                try {
                    URL url2 = new URL(fileNameOrUrl);
                    image = ImageIO.read(url2);
                    serializable2 = this.imageCache().put(fileNameOrUrl, image);
                    return new Some<BufferedImage>(image);
                }
                catch (Throwable throwable) {
                    try {
                        image = ImageIO.read(new File(fileNameOrUrl));
                        serializable2 = this.imageCache().put(fileNameOrUrl, image);
                        return new Some<BufferedImage>(image);
                    }
                    catch (Throwable throwable2) {
                        image = this.dummy();
                        this.imageCache().put(fileNameOrUrl, image);
                        Logger.getLogger(this.getClass().getSimpleName()).log(Level.WARNING, new StringOps(Predef$.MODULE$.augmentString("Cannot read image '%s'.")).format(Predef$.MODULE$.genericWrapArray(new Object[]{fileNameOrUrl})), throwable2);
                        serializable2 = BoxedUnit.UNIT;
                    }
                }
                return new Some<BufferedImage>(image);
            }
            Object i = null;
            try {
                image = ImageIO.read(url);
                serializable2 = this.imageCache().put(fileNameOrUrl, image);
                return new Some<BufferedImage>(image);
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
                serializable2 = BoxedUnit.UNIT;
            }
            return new Some<BufferedImage>(image);
        }
        if (!(option2 instanceof Some)) throw new MatchError(option2);
        Some<BufferedImage> some2 = (Some<BufferedImage>)option2;
        Object a = some2.get();
        BufferedImage bufferedImage = this.dummy();
        if (!(a != null ? !a.equals(bufferedImage) : bufferedImage != null) && forceTryReload) {
            this.imageCache().$minus$eq((Object)fileNameOrUrl);
            option = this.loadImage(fileNameOrUrl);
            return option;
        } else {
            option = some2;
        }
        return option;
    }

    public BufferedImage dummyImage() {
        return this.dummy();
    }

    private ImageCache$() {
        MODULE$ = this;
        this.imageCache = new HashMap();
        this.dummy = null;
        this.init();
    }
}

