/*
 * Decompiled with CFR 0.152.
 */
package org.graphstream.ui.j2dviewer.renderer.shape.swing;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import org.graphstream.ui.geom.Point2;
import org.graphstream.ui.geom.Point3;
import org.graphstream.ui.geom.Vector2;
import org.graphstream.ui.graphicGraph.GraphicEdge;
import org.graphstream.ui.graphicGraph.GraphicElement;
import org.graphstream.ui.graphicGraph.StyleGroup;
import org.graphstream.ui.graphicGraph.stylesheet.Style;
import org.graphstream.ui.graphicGraph.stylesheet.StyleConstants;
import org.graphstream.ui.j2dviewer.Backend;
import org.graphstream.ui.j2dviewer.Camera;
import org.graphstream.ui.j2dviewer.renderer.AreaSkeleton;
import org.graphstream.ui.j2dviewer.renderer.Skeleton;
import org.graphstream.ui.j2dviewer.renderer.shape.Area$class;
import org.graphstream.ui.j2dviewer.renderer.shape.AreaOnConnector$class;
import org.graphstream.ui.j2dviewer.renderer.shape.Connector;
import org.graphstream.ui.j2dviewer.renderer.shape.OnConnector$class;
import org.graphstream.ui.j2dviewer.renderer.shape.swing.AreaOnConnectorShape;
import org.graphstream.ui.j2dviewer.renderer.shape.swing.AreaOnConnectorShape$class;
import org.graphstream.ui.j2dviewer.renderer.shape.swing.Fillable$class;
import org.graphstream.ui.j2dviewer.renderer.shape.swing.Shadowable$class;
import org.graphstream.ui.j2dviewer.renderer.shape.swing.ShapeDecor;
import org.graphstream.ui.j2dviewer.renderer.shape.swing.ShapePaint;
import org.graphstream.ui.j2dviewer.renderer.shape.swing.ShapeStroke;
import org.graphstream.ui.j2dviewer.renderer.shape.swing.Strokable$class;
import org.graphstream.ui.util.CubicCurve$;
import org.graphstream.ui.util.ShapeUtil$;
import org.graphstream.ui.util.swing.ImageCache$;
import scala.MatchError;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.TraitSetter;

@ScalaSignature(bytes="\u0006\u0001\u0005%c\u0001B\u0001\u0003\u0001E\u00111\"S7bO\u0016|e.\u00123hK*\u00111\u0001B\u0001\u0006g^Lgn\u001a\u0006\u0003\u000b\u0019\tQa\u001d5ba\u0016T!a\u0002\u0005\u0002\u0011I,g\u000eZ3sKJT!!\u0003\u0006\u0002\u0013)\u0014DM^5fo\u0016\u0014(BA\u0006\r\u0003\t)\u0018N\u0003\u0002\u000e\u001d\u0005YqM]1qQN$(/Z1n\u0015\u0005y\u0011aA8sO\u000e\u00011c\u0001\u0001\u00131A\u00111CF\u0007\u0002))\tQ#A\u0003tG\u0006d\u0017-\u0003\u0002\u0018)\t1\u0011I\\=SK\u001a\u0004\"!\u0007\u000e\u000e\u0003\tI!a\u0007\u0002\u0003)\u0005\u0013X-Y(o\u0007>tg.Z2u_J\u001c\u0006.\u00199f\u0011\u0015i\u0002\u0001\"\u0001\u001f\u0003\u0019a\u0014N\\5u}Q\tq\u0004\u0005\u0002\u001a\u0001!9\u0011\u0005\u0001a\u0001\n\u0003\u0011\u0013!B5nC\u001e,W#A\u0012\u0011\u0005\u0011RS\"A\u0013\u000b\u0005\u00052#BA\u0014)\u0003\r\tw\u000f\u001e\u0006\u0002S\u0005!!.\u0019<b\u0013\tYSEA\u0007Ck\u001a4WM]3e\u00136\fw-\u001a\u0005\b[\u0001\u0001\r\u0011\"\u0001/\u0003%IW.Y4f?\u0012*\u0017\u000f\u0006\u00020eA\u00111\u0003M\u0005\u0003cQ\u0011A!\u00168ji\"91\u0007LA\u0001\u0002\u0004\u0019\u0013a\u0001=%c!1Q\u0007\u0001Q!\n\r\na![7bO\u0016\u0004\u0003bB\u001c\u0001\u0001\u0004%\t\u0001O\u0001\u0002aV\t\u0011\b\u0005\u0002;{5\t1H\u0003\u0002=\u0015\u0005!q-Z8n\u0013\tq4H\u0001\u0004Q_&tGo\r\u0005\b\u0001\u0002\u0001\r\u0011\"\u0001B\u0003\u0015\u0001x\fJ3r)\ty#\tC\u00044\u007f\u0005\u0005\t\u0019A\u001d\t\r\u0011\u0003\u0001\u0015)\u0003:\u0003\t\u0001\b\u0005C\u0004G\u0001\u0001\u0007I\u0011A$\u0002\u000b\u0005tw\r\\3\u0016\u0003!\u0003\"aE%\n\u0005)#\"A\u0002#pk\ndW\rC\u0004M\u0001\u0001\u0007I\u0011A'\u0002\u0013\u0005tw\r\\3`I\u0015\fHCA\u0018O\u0011\u001d\u00194*!AA\u0002!Ca\u0001\u0015\u0001!B\u0013A\u0015AB1oO2,\u0007\u0005C\u0003S\u0001\u0011\u00053+A\td_:4\u0017nZ;sK\u001a{'o\u0012:pkB$Ba\f+[I\")Q+\u0015a\u0001-\u0006\u0019!mY6\u0011\u0005]CV\"\u0001\u0005\n\u0005eC!a\u0002\"bG.,g\u000e\u001a\u0005\u00067F\u0003\r\u0001X\u0001\u0006gRLH.\u001a\t\u0003;\nl\u0011A\u0018\u0006\u0003?\u0002\f!b\u001d;zY\u0016\u001c\b.Z3u\u0015\t\t'\"\u0001\u0007he\u0006\u0004\b.[2He\u0006\u0004\b.\u0003\u0002d=\n)1\u000b^=mK\")Q-\u0015a\u0001M\u000611-Y7fe\u0006\u0004\"aV4\n\u0005!D!AB\"b[\u0016\u0014\u0018\rC\u0003k\u0001\u0011\u00053.A\nd_:4\u0017nZ;sK\u001a{'/\u00127f[\u0016tG\u000fF\u00030Y6\u001c\u0018\u0010C\u0003VS\u0002\u0007a\u000bC\u0003oS\u0002\u0007q.A\u0004fY\u0016lWM\u001c;\u0011\u0005A\fX\"\u00011\n\u0005I\u0004'AD$sCBD\u0017nY#mK6,g\u000e\u001e\u0005\u0006i&\u0004\r!^\u0001\u0005g.,G\u000e\u0005\u0002wo6\ta!\u0003\u0002y\r\tA1k[3mKR|g\u000eC\u0003fS\u0002\u0007a\rC\u0003|\u0001\u0011EA0\u0001\u0003nC.,GcA\u0018~}\")QK\u001fa\u0001-\")QM\u001fa\u0001M\"9\u0011\u0011\u0001\u0001\u0005\u0012\u0005\r\u0011AC7bW\u0016\u001c\u0006.\u00193poR)q&!\u0002\u0002\b!)Qk a\u0001-\")Qm a\u0001M\"11\u0010\u0001C\t\u0003\u0017!RaLA\u0007\u0003/A\u0001\"a\u0004\u0002\n\u0001\u0007\u0011\u0011C\u0001\nM>\u00148\u000b[1e_^\u00042aEA\n\u0013\r\t)\u0002\u0006\u0002\b\u0005>|G.Z1o\u0011\u0019)\u0017\u0011\u0002a\u0001M\"9\u00111\u0004\u0001\u0005\u0012\u0005u\u0011AC7bW\u0016|e\u000eT5oKR)q&a\b\u0002\"!A\u0011qBA\r\u0001\u0004\t\t\u0002\u0003\u0004f\u00033\u0001\rA\u001a\u0005\b\u0003K\u0001A\u0011CA\u0014\u0003-i\u0017m[3P]\u000e+(O^3\u0015\u000b=\nI#a\u000b\t\u0011\u0005=\u00111\u0005a\u0001\u0003#Aa!ZA\u0012\u0001\u00041\u0007bBA\u0018\u0001\u0011\u0005\u0011\u0011G\u0001\re\u0016tG-\u001a:TQ\u0006$wn\u001e\u000b\n_\u0005M\u0012QGA\u001c\u0003sAa!VA\u0017\u0001\u00041\u0006BB3\u0002.\u0001\u0007a\r\u0003\u0004o\u0003[\u0001\ra\u001c\u0005\u0007i\u00065\u0002\u0019A;\t\u000f\u0005u\u0002\u0001\"\u0001\u0002@\u00051!/\u001a8eKJ$\u0012bLA!\u0003\u0007\n)%a\u0012\t\rU\u000bY\u00041\u0001W\u0011\u0019)\u00171\ba\u0001M\"1a.a\u000fA\u0002=Da\u0001^A\u001e\u0001\u0004)\b")
public class ImageOnEdge
implements AreaOnConnectorShape {
    private BufferedImage image;
    private Point3 p;
    private double angle;
    private ShapePaint shadowPaint;
    private final Point2 theShadowWidth;
    private final Point2 theShadowOff;
    private Color strokeColor;
    private ShapeStroke theStroke;
    private double theStrokeWidth;
    private ShapePaint fillPaint;
    private double theFillPercent;
    private Color theFillColor;
    private boolean plainFast;
    private GraphicEdge theEdge;
    private Connector theConnector;
    private final Point2 theCenter;
    private final Point2 theSize;
    private boolean fit;

    @Override
    public ShapePaint shadowPaint() {
        return this.shadowPaint;
    }

    @Override
    public void shadowPaint_$eq(ShapePaint x$1) {
        this.shadowPaint = x$1;
    }

    @Override
    public Point2 theShadowWidth() {
        return this.theShadowWidth;
    }

    @Override
    public Point2 theShadowOff() {
        return this.theShadowOff;
    }

    @Override
    public void org$graphstream$ui$j2dviewer$renderer$shape$swing$Shadowable$_setter_$theShadowWidth_$eq(Point2 x$1) {
        this.theShadowWidth = x$1;
    }

    @Override
    public void org$graphstream$ui$j2dviewer$renderer$shape$swing$Shadowable$_setter_$theShadowOff_$eq(Point2 x$1) {
        this.theShadowOff = x$1;
    }

    @Override
    public void shadowWidth(double width, double height) {
        Shadowable$class.shadowWidth(this, width, height);
    }

    @Override
    public void shadowOffset(double xoff, double yoff) {
        Shadowable$class.shadowOffset(this, xoff, yoff);
    }

    @Override
    public void cast(Graphics2D g, Shape shape) {
        Shadowable$class.cast(this, g, shape);
    }

    @Override
    public void configureShadowableForGroup(Style style, Camera camera) {
        Shadowable$class.configureShadowableForGroup(this, style, camera);
    }

    @Override
    public Color strokeColor() {
        return this.strokeColor;
    }

    @Override
    public void strokeColor_$eq(Color x$1) {
        this.strokeColor = x$1;
    }

    @Override
    public ShapeStroke theStroke() {
        return this.theStroke;
    }

    @Override
    public void theStroke_$eq(ShapeStroke x$1) {
        this.theStroke = x$1;
    }

    @Override
    public double theStrokeWidth() {
        return this.theStrokeWidth;
    }

    @Override
    public void theStrokeWidth_$eq(double x$1) {
        this.theStrokeWidth = x$1;
    }

    @Override
    public void stroke(Graphics2D g, Shape shape) {
        Strokable$class.stroke(this, g, shape);
    }

    @Override
    public void configureStrokableForGroup(Style style, Camera camera) {
        Strokable$class.configureStrokableForGroup(this, style, camera);
    }

    @Override
    public ShapePaint fillPaint() {
        return this.fillPaint;
    }

    @Override
    public void fillPaint_$eq(ShapePaint x$1) {
        this.fillPaint = x$1;
    }

    @Override
    public double theFillPercent() {
        return this.theFillPercent;
    }

    @Override
    public void theFillPercent_$eq(double x$1) {
        this.theFillPercent = x$1;
    }

    @Override
    public Color theFillColor() {
        return this.theFillColor;
    }

    @Override
    public void theFillColor_$eq(Color x$1) {
        this.theFillColor = x$1;
    }

    @Override
    public boolean plainFast() {
        return this.plainFast;
    }

    @Override
    public void plainFast_$eq(boolean x$1) {
        this.plainFast = x$1;
    }

    @Override
    public void fill(Graphics2D g, double dynColor, Color optColor, Shape shape, Camera camera) {
        Fillable$class.fill(this, g, dynColor, optColor, shape, camera);
    }

    @Override
    public void fill(Graphics2D g, Shape shape, Camera camera) {
        Fillable$class.fill(this, g, shape, camera);
    }

    @Override
    public void configureFillableForGroup(Backend bck, Style style, Camera camera) {
        Fillable$class.configureFillableForGroup(this, bck, style, camera);
    }

    @Override
    public void configureFillableForElement(Style style, Camera camera, GraphicElement element) {
        Fillable$class.configureFillableForElement(this, style, camera, element);
    }

    @Override
    public GraphicEdge theEdge() {
        return this.theEdge;
    }

    @Override
    @TraitSetter
    public void theEdge_$eq(GraphicEdge x$1) {
        this.theEdge = x$1;
    }

    @Override
    public void configureAreaOnConnectorForGroup(Style style, Camera camera) {
        AreaOnConnector$class.configureAreaOnConnectorForGroup(this, style, camera);
    }

    @Override
    public void configureAreaOnConnectorForElement(GraphicEdge edge, Style style, Camera camera) {
        AreaOnConnector$class.configureAreaOnConnectorForElement(this, edge, style, camera);
    }

    @Override
    public Connector theConnector() {
        return this.theConnector;
    }

    @Override
    @TraitSetter
    public void theConnector_$eq(Connector x$1) {
        this.theConnector = x$1;
    }

    @Override
    public void theConnectorYoureAttachedTo(Connector connector) {
        OnConnector$class.theConnectorYoureAttachedTo(this, connector);
    }

    @Override
    public Point2 theCenter() {
        return this.theCenter;
    }

    @Override
    public Point2 theSize() {
        return this.theSize;
    }

    @Override
    public boolean fit() {
        return this.fit;
    }

    @Override
    @TraitSetter
    public void fit_$eq(boolean x$1) {
        this.fit = x$1;
    }

    @Override
    public void org$graphstream$ui$j2dviewer$renderer$shape$Area$_setter_$theCenter_$eq(Point2 x$1) {
        this.theCenter = x$1;
    }

    @Override
    public void org$graphstream$ui$j2dviewer$renderer$shape$Area$_setter_$theSize_$eq(Point2 x$1) {
        this.theSize = x$1;
    }

    @Override
    public void configureAreaForGroup(Style style, Camera camera) {
        Area$class.configureAreaForGroup(this, style, camera);
    }

    @Override
    public void configureAreaForElement(Backend backend, Camera camera, AreaSkeleton skel, GraphicElement element, ShapeDecor decor) {
        Area$class.configureAreaForElement(this, backend, camera, skel, element, decor);
    }

    public BufferedImage image() {
        return this.image;
    }

    public void image_$eq(BufferedImage x$1) {
        this.image = x$1;
    }

    public Point3 p() {
        return this.p;
    }

    public void p_$eq(Point3 x$1) {
        this.p = x$1;
    }

    public double angle() {
        return this.angle;
    }

    public void angle_$eq(double x$1) {
        this.angle = x$1;
    }

    @Override
    public void configureForGroup(Backend bck, Style style, Camera camera) {
        AreaOnConnectorShape$class.configureForGroup(this, bck, style, camera);
    }

    @Override
    public void configureForElement(Backend bck, GraphicElement element, Skeleton skel, Camera camera) {
        AreaOnConnectorShape$class.configureForElement(this, bck, element, skel, camera);
        String url = element.getStyle().getArrowImage();
        if (url.equals("dynamic")) {
            url = element.hasLabel("ui.arrow-image") ? element.getLabel("ui.arrow-image").toString() : null;
        }
        if (url != null) {
            BufferedImage bufferedImage;
            Option<BufferedImage> option = ImageCache$.MODULE$.loadImage(url);
            if (option instanceof Some) {
                Some some = (Some)option;
                bufferedImage = (BufferedImage)some.get();
            } else {
                bufferedImage = ImageCache$.MODULE$.dummyImage();
            }
            this.image_$eq(bufferedImage);
        }
    }

    @Override
    public void make(Backend bck, Camera camera) {
        this.make(false, camera);
    }

    @Override
    public void makeShadow(Backend bck, Camera camera) {
        this.make(true, camera);
    }

    public void make(boolean forShadow, Camera camera) {
        if (this.theConnector().skel().isCurve()) {
            this.makeOnCurve(forShadow, camera);
        } else {
            this.makeOnLine(forShadow, camera);
        }
    }

    public void makeOnLine(boolean forShadow, Camera camera) {
        double off = ShapeUtil$.MODULE$.evalTargetRadius2D(this.theEdge(), camera);
        Vector2 theDirection = new Vector2(this.theConnector().toPos().x - this.theConnector().fromPos().x, this.theConnector().toPos().y - this.theConnector().fromPos().y);
        theDirection.normalize();
        double iw = camera.metrics().lengthToGu((double)this.image().getWidth(), StyleConstants.Units.PX) / (double)2;
        double x = this.theCenter().x - theDirection.x() * (off + iw);
        double y = this.theCenter().y - theDirection.y() * (off + iw);
        if (forShadow) {
            x += this.theShadowOff().x;
            y += this.theShadowOff().y;
        }
        this.p_$eq(camera.transformGuToPx(x, y, 0.0));
        this.angle_$eq(package$.MODULE$.acos(theDirection.dotProduct(1.0, 0.0)));
        if (theDirection.y() > 0.0) {
            this.angle_$eq(package$.MODULE$.Pi() - this.angle());
        }
    }

    public void makeOnCurve(boolean forShadow, Camera camera) {
        Tuple2<Point2, Object> tuple2 = CubicCurve$.MODULE$.approxIntersectionPointOnCurve(this.theEdge(), this.theConnector(), camera);
        if (tuple2 != null) {
            Tuple2<Point2, Double> tuple22;
            Point2 p1 = tuple2._1();
            double t = tuple2._2$mcD$sp();
            Tuple2<Point2, Double> tuple23 = tuple22 = new Tuple2<Point2, Double>(p1, BoxesRunTime.boxToDouble(t));
            Point2 p12 = tuple23._1();
            double t2 = tuple23._2$mcD$sp();
            StyleGroup style = this.theEdge().getStyle();
            Point3 p2 = CubicCurve$.MODULE$.eval(this.theConnector().fromPos(), this.theConnector().byPos1(), this.theConnector().byPos2(), this.theConnector().toPos(), t2 - (double)0.1f);
            Vector2 dir = new Vector2(p12.x - p2.x, p12.y - p2.y);
            dir.normalize();
            double iw = camera.metrics().lengthToGu((double)this.image().getWidth(), StyleConstants.Units.PX) / (double)2;
            double x = p12.x - dir.x() * iw;
            double y = p12.y - dir.y() * iw;
            if (forShadow) {
                x += this.theShadowOff().x;
                y += this.theShadowOff().y;
            }
            this.p_$eq(camera.transformGuToPx(x, y, 0.0));
            this.angle_$eq(package$.MODULE$.acos(dir.dotProduct(1.0, 0.0)));
            if (dir.y() > 0.0) {
                this.angle_$eq(package$.MODULE$.Pi() - this.angle());
            }
            return;
        }
        throw new MatchError(tuple2);
    }

    @Override
    public void renderShadow(Backend bck, Camera camera, GraphicElement element, Skeleton skel) {
    }

    @Override
    public void render(Backend bck, Camera camera, GraphicElement element, Skeleton skel) {
        Graphics2D g = bck.graphics2D();
        this.make(false, camera);
        if (this.image() != null) {
            AffineTransform Tx = g.getTransform();
            AffineTransform Tr = new AffineTransform();
            g.setTransform(Tr);
            Tr.translate(this.p().x, this.p().y);
            Tr.rotate(this.angle());
            Tr.translate(-this.image().getWidth() / 2, -this.image().getHeight() / 2);
            g.drawImage(this.image(), Tr, null);
            g.setTransform(Tx);
        }
    }

    public ImageOnEdge() {
        Area$class.$init$(this);
        OnConnector$class.$init$(this);
        AreaOnConnector$class.$init$(this);
        Fillable$class.$init$(this);
        Strokable$class.$init$(this);
        Shadowable$class.$init$(this);
        AreaOnConnectorShape$class.$init$(this);
        this.image = null;
        this.p = null;
        this.angle = 0.0;
    }
}

