/*
 * Decompiled with CFR 0.152.
 */
package org.graphstream.ui.j2dviewer.renderer.shape.swing;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.Path2D;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.graphstream.ui.geom.Point2;
import org.graphstream.ui.geom.Point3;
import org.graphstream.ui.graphicGraph.GraphicEdge;
import org.graphstream.ui.graphicGraph.GraphicElement;
import org.graphstream.ui.graphicGraph.stylesheet.Style;
import org.graphstream.ui.j2dviewer.Backend;
import org.graphstream.ui.j2dviewer.Camera;
import org.graphstream.ui.j2dviewer.renderer.ConnectorSkeleton;
import org.graphstream.ui.j2dviewer.renderer.Skeleton;
import org.graphstream.ui.j2dviewer.renderer.shape.Connector$class;
import org.graphstream.ui.j2dviewer.renderer.shape.Decorable$class;
import org.graphstream.ui.j2dviewer.renderer.shape.HasSkel$class;
import org.graphstream.ui.j2dviewer.renderer.shape.swing.ConnectorShape$class;
import org.graphstream.ui.j2dviewer.renderer.shape.swing.FillableLine$class;
import org.graphstream.ui.j2dviewer.renderer.shape.swing.IconAndText;
import org.graphstream.ui.j2dviewer.renderer.shape.swing.LineConnectorShape;
import org.graphstream.ui.j2dviewer.renderer.shape.swing.LineConnectorShape$class;
import org.graphstream.ui.j2dviewer.renderer.shape.swing.ShadowableLine$class;
import org.graphstream.ui.j2dviewer.renderer.shape.swing.ShapeDecor;
import org.graphstream.ui.j2dviewer.renderer.shape.swing.ShapeStroke;
import org.graphstream.ui.j2dviewer.renderer.shape.swing.Strokable$class;
import org.graphstream.ui.j2dviewer.renderer.shape.swing.StrokableLine$class;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.TraitSetter;

@ScalaSignature(bytes="\u0006\u0001\u0005-b\u0001B\u0001\u0003\u0001E\u0011!C\u0012:fKBc\u0017M\\3FI\u001e,7\u000b[1qK*\u00111\u0001B\u0001\u0006g^Lgn\u001a\u0006\u0003\u000b\u0019\tQa\u001d5ba\u0016T!a\u0002\u0005\u0002\u0011I,g\u000eZ3sKJT!!\u0003\u0006\u0002\u0013)\u0014DM^5fo\u0016\u0014(BA\u0006\r\u0003\t)\u0018N\u0003\u0002\u000e\u001d\u0005YqM]1qQN$(/Z1n\u0015\u0005y\u0011aA8sO\u000e\u00011c\u0001\u0001\u00131A\u00111CF\u0007\u0002))\tQ#A\u0003tG\u0006d\u0017-\u0003\u0002\u0018)\t1\u0011I\\=SK\u001a\u0004\"!\u0007\u000e\u000e\u0003\tI!a\u0007\u0002\u0003%1Kg.Z\"p]:,7\r^8s'\"\f\u0007/\u001a\u0005\u0006;\u0001!\tAH\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003}\u0001\"!\u0007\u0001\t\u000f\u0005\u0002\u0001\u0019!C\tE\u0005AA\u000f[3TQ\u0006\u0004X-F\u0001$!\t!cF\u0004\u0002&Y5\taE\u0003\u0002(Q\u0005!q-Z8n\u0015\tI#&A\u0002boRT\u0011aK\u0001\u0005U\u00064\u0018-\u0003\u0002.M\u00051\u0001+\u0019;ie\u0011K!a\f\u0019\u0003\r\u0011{WO\u00197f\u0015\tic\u0005C\u00043\u0001\u0001\u0007I\u0011C\u001a\u0002\u0019QDWm\u00155ba\u0016|F%Z9\u0015\u0005Q:\u0004CA\n6\u0013\t1DC\u0001\u0003V]&$\bb\u0002\u001d2\u0003\u0003\u0005\raI\u0001\u0004q\u0012\n\u0004B\u0002\u001e\u0001A\u0003&1%A\u0005uQ\u0016\u001c\u0006.\u00199fA!)A\b\u0001C\t{\u0005!Q.Y6f)\r!d\b\u0012\u0005\u0006\u007fm\u0002\r\u0001Q\u0001\u0004E\u000e\\\u0007CA!C\u001b\u0005A\u0011BA\"\t\u0005\u001d\u0011\u0015mY6f]\u0012DQ!R\u001eA\u0002\u0019\u000baaY1nKJ\f\u0007CA!H\u0013\tA\u0005B\u0001\u0004DC6,'/\u0019\u0005\u0006y\u0001!\tB\u0013\u000b\u0007i-c\u0005K\u0015+\t\u000b\u0015K\u0005\u0019\u0001$\t\u000b5K\u0005\u0019\u0001(\u0002\u0007M|\u0007\u0010\u0005\u0002\u0014\u001f&\u0011q\u0006\u0006\u0005\u0006#&\u0003\rAT\u0001\u0004g>L\b\"B*J\u0001\u0004q\u0015aA:xq\")Q+\u0013a\u0001\u001d\u0006\u00191o^=\t\u000b]\u0003A\u0011\u0003-\u0002\u00155\f7.Z*j]\u001edW\r\u0006\u000453j[F,\u0018\u0005\u0006\u000bZ\u0003\rA\u0012\u0005\u0006\u001bZ\u0003\rA\u0014\u0005\u0006#Z\u0003\rA\u0014\u0005\u0006'Z\u0003\rA\u0014\u0005\u0006+Z\u0003\rA\u0014\u0005\u0006?\u0002!\t\u0002Y\u0001\u0010[\u0006\\W-T;mi&|%\u000fT8paR1A'\u00192dI\u0016DQ!\u00120A\u0002\u0019CQ!\u00140A\u00029CQ!\u00150A\u00029CQa\u00150A\u00029CQ!\u00160A\u00029CQa\u001a\u0001\u0005\u0012!\f\u0011\"\\1lK6+H\u000e^5\u0015\rQJ'n\u001b7n\u0011\u0015)e\r1\u0001G\u0011\u0015ie\r1\u0001O\u0011\u0015\tf\r1\u0001O\u0011\u0015\u0019f\r1\u0001O\u0011\u0015)f\r1\u0001O\u0011\u0015y\u0007\u0001\"\u0005q\u0003!i\u0017m[3M_>\u0004HC\u0002\u001breN$X\u000fC\u0003F]\u0002\u0007a\tC\u0003N]\u0002\u0007a\nC\u0003R]\u0002\u0007a\nC\u0003T]\u0002\u0007a\nC\u0003V]\u0002\u0007a\nC\u0003x\u0001\u0011E\u00010\u0001\u0006nC.,7\u000b[1e_^$2\u0001N={\u0011\u0015yd\u000f1\u0001A\u0011\u0015)e\u000f1\u0001G\u0011\u0015a\b\u0001\"\u0001~\u00031\u0011XM\u001c3feNC\u0017\rZ8x)\u001d!dp`A\u0001\u0003#AQaP>A\u0002\u0001CQ!R>A\u0002\u0019Cq!a\u0001|\u0001\u0004\t)!A\u0004fY\u0016lWM\u001c;\u0011\t\u0005\u001d\u0011QB\u0007\u0003\u0003\u0013Q1!a\u0003\u000b\u000319'/\u00199iS\u000e<%/\u00199i\u0013\u0011\ty!!\u0003\u0003\u001d\u001d\u0013\u0018\r\u001d5jG\u0016cW-\\3oi\"9\u00111C>A\u0002\u0005U\u0011\u0001B:lK2\u0004B!a\u0006\u0002\u001a5\ta!C\u0002\u0002\u001c\u0019\u0011\u0001bU6fY\u0016$xN\u001c\u0005\b\u0003?\u0001A\u0011AA\u0011\u0003\u0019\u0011XM\u001c3feRIA'a\t\u0002&\u0005\u001d\u0012\u0011\u0006\u0005\u0007\u007f\u0005u\u0001\u0019\u0001!\t\r\u0015\u000bi\u00021\u0001G\u0011!\t\u0019!!\bA\u0002\u0005\u0015\u0001\u0002CA\n\u0003;\u0001\r!!\u0006")
public class FreePlaneEdgeShape
implements LineConnectorShape {
    private Path2D.Double theShape;
    private ShapeStroke shadowStroke;
    private double theShadowWidth;
    private final Point2 theShadowOff;
    private Color theShadowColor;
    private Color strokeColor;
    private ShapeStroke theStroke;
    private double theStrokeWidth;
    private ShapeStroke fillStroke;
    private double theFillPercent;
    private Color theFillColor;
    private boolean plainFast;
    private String text;
    private ShapeDecor theDecor;
    private GraphicEdge theEdge;
    private double theSize;
    private Point2 theTargetSize;
    private Point2 theSourceSize;
    private boolean isDirected;
    private ConnectorSkeleton skel;

    @Override
    public void org$graphstream$ui$j2dviewer$renderer$shape$swing$LineConnectorShape$$super$configureForGroup(Backend bck, Style style, Camera camera) {
        ConnectorShape$class.configureForGroup(this, bck, style, camera);
    }

    @Override
    public void org$graphstream$ui$j2dviewer$renderer$shape$swing$LineConnectorShape$$super$configureForElement(Backend bck, GraphicElement element, Skeleton skel, Camera camera) {
        ConnectorShape$class.configureForElement(this, bck, element, skel, camera);
    }

    @Override
    public void configureForGroup(Backend bck, Style style, Camera camera) {
        LineConnectorShape$class.configureForGroup(this, bck, style, camera);
    }

    @Override
    public void configureForElement(Backend bck, GraphicElement element, Skeleton skel, Camera camera) {
        LineConnectorShape$class.configureForElement(this, bck, element, skel, camera);
    }

    @Override
    public ShapeStroke shadowStroke() {
        return this.shadowStroke;
    }

    @Override
    public void shadowStroke_$eq(ShapeStroke x$1) {
        this.shadowStroke = x$1;
    }

    @Override
    public double theShadowWidth() {
        return this.theShadowWidth;
    }

    @Override
    public void theShadowWidth_$eq(double x$1) {
        this.theShadowWidth = x$1;
    }

    @Override
    public Point2 theShadowOff() {
        return this.theShadowOff;
    }

    @Override
    public Color theShadowColor() {
        return this.theShadowColor;
    }

    @Override
    public void theShadowColor_$eq(Color x$1) {
        this.theShadowColor = x$1;
    }

    @Override
    public void org$graphstream$ui$j2dviewer$renderer$shape$swing$ShadowableLine$_setter_$theShadowOff_$eq(Point2 x$1) {
        this.theShadowOff = x$1;
    }

    @Override
    public void shadowWidth(double width) {
        ShadowableLine$class.shadowWidth(this, width);
    }

    @Override
    public void shadowOffset(double xoff, double yoff) {
        ShadowableLine$class.shadowOffset(this, xoff, yoff);
    }

    @Override
    public void cast(Graphics2D g, Shape shape) {
        ShadowableLine$class.cast(this, g, shape);
    }

    @Override
    public void configureShadowableLineForGroup(Style style, Camera camera) {
        ShadowableLine$class.configureShadowableLineForGroup(this, style, camera);
    }

    @Override
    public void configureStrokableForGroup(Style style, Camera camera) {
        StrokableLine$class.configureStrokableForGroup(this, style, camera);
    }

    @Override
    public void configureStrokableLineForGroup(Style style, Camera camera) {
        StrokableLine$class.configureStrokableLineForGroup(this, style, camera);
    }

    @Override
    public Color strokeColor() {
        return this.strokeColor;
    }

    @Override
    public void strokeColor_$eq(Color x$1) {
        this.strokeColor = x$1;
    }

    @Override
    public ShapeStroke theStroke() {
        return this.theStroke;
    }

    @Override
    public void theStroke_$eq(ShapeStroke x$1) {
        this.theStroke = x$1;
    }

    @Override
    public double theStrokeWidth() {
        return this.theStrokeWidth;
    }

    @Override
    public void theStrokeWidth_$eq(double x$1) {
        this.theStrokeWidth = x$1;
    }

    @Override
    public void stroke(Graphics2D g, Shape shape) {
        Strokable$class.stroke(this, g, shape);
    }

    @Override
    public ShapeStroke fillStroke() {
        return this.fillStroke;
    }

    @Override
    public void fillStroke_$eq(ShapeStroke x$1) {
        this.fillStroke = x$1;
    }

    @Override
    public double theFillPercent() {
        return this.theFillPercent;
    }

    @Override
    public void theFillPercent_$eq(double x$1) {
        this.theFillPercent = x$1;
    }

    @Override
    public Color theFillColor() {
        return this.theFillColor;
    }

    @Override
    public void theFillColor_$eq(Color x$1) {
        this.theFillColor = x$1;
    }

    @Override
    public boolean plainFast() {
        return this.plainFast;
    }

    @Override
    public void plainFast_$eq(boolean x$1) {
        this.plainFast = x$1;
    }

    @Override
    public void fill(Graphics2D g, double width, double dynColor, Shape shape) {
        FillableLine$class.fill(this, g, width, dynColor, shape);
    }

    @Override
    public void fill(Graphics2D g, double width, Shape shape) {
        FillableLine$class.fill(this, g, width, shape);
    }

    @Override
    public void configureFillableLineForGroup(Backend bck, Style style, Camera camera, double theSize) {
        FillableLine$class.configureFillableLineForGroup(this, bck, style, camera, theSize);
    }

    @Override
    public void configureFillableLineForElement(Style style, Camera camera, GraphicElement element) {
        FillableLine$class.configureFillableLineForElement(this, style, camera, element);
    }

    @Override
    public String text() {
        return this.text;
    }

    @Override
    @TraitSetter
    public void text_$eq(String x$1) {
        this.text = x$1;
    }

    @Override
    public ShapeDecor theDecor() {
        return this.theDecor;
    }

    @Override
    @TraitSetter
    public void theDecor_$eq(ShapeDecor x$1) {
        this.theDecor = x$1;
    }

    @Override
    public void decorArea(Backend backend, Camera camera, IconAndText iconAndText, GraphicElement element, Shape shape) {
        Decorable$class.decorArea(this, backend, camera, iconAndText, element, shape);
    }

    @Override
    public void decorConnector(Backend backend, Camera camera, IconAndText iconAndText, GraphicElement element, Shape shape) {
        Decorable$class.decorConnector(this, backend, camera, iconAndText, element, shape);
    }

    @Override
    public void configureDecorableForGroup(Style style, Camera camera) {
        Decorable$class.configureDecorableForGroup(this, style, camera);
    }

    @Override
    public void configureDecorableForElement(Backend backend, Camera camera, GraphicElement element, Skeleton skel) {
        Decorable$class.configureDecorableForElement(this, backend, camera, element, skel);
    }

    @Override
    public GraphicEdge theEdge() {
        return this.theEdge;
    }

    @Override
    @TraitSetter
    public void theEdge_$eq(GraphicEdge x$1) {
        this.theEdge = x$1;
    }

    @Override
    public double theSize() {
        return this.theSize;
    }

    @Override
    @TraitSetter
    public void theSize_$eq(double x$1) {
        this.theSize = x$1;
    }

    @Override
    public Point2 theTargetSize() {
        return this.theTargetSize;
    }

    @Override
    @TraitSetter
    public void theTargetSize_$eq(Point2 x$1) {
        this.theTargetSize = x$1;
    }

    @Override
    public Point2 theSourceSize() {
        return this.theSourceSize;
    }

    @Override
    @TraitSetter
    public void theSourceSize_$eq(Point2 x$1) {
        this.theSourceSize = x$1;
    }

    @Override
    public boolean isDirected() {
        return this.isDirected;
    }

    @Override
    @TraitSetter
    public void isDirected_$eq(boolean x$1) {
        this.isDirected = x$1;
    }

    @Override
    public Point3 fromPos() {
        return Connector$class.fromPos(this);
    }

    @Override
    public Point3 byPos1() {
        return Connector$class.byPos1(this);
    }

    @Override
    public Point3 byPos2() {
        return Connector$class.byPos2(this);
    }

    @Override
    public Point3 toPos() {
        return Connector$class.toPos(this);
    }

    @Override
    public void configureConnectorForGroup(Style style, Camera camera) {
        Connector$class.configureConnectorForGroup(this, style, camera);
    }

    @Override
    public void configureConnectorForElement(Camera camera, GraphicEdge element, ConnectorSkeleton skel) {
        Connector$class.configureConnectorForElement(this, camera, element, skel);
    }

    @Override
    public ConnectorSkeleton skel() {
        return this.skel;
    }

    @Override
    @TraitSetter
    public void skel_$eq(ConnectorSkeleton x$1) {
        this.skel = x$1;
    }

    public Path2D.Double theShape() {
        return this.theShape;
    }

    public void theShape_$eq(Path2D.Double x$1) {
        this.theShape = x$1;
    }

    @Override
    public void make(Backend bck, Camera camera) {
        this.make(camera, 0.0, 0.0, 0.0, 0.0);
    }

    public void make(Camera camera, double sox, double soy, double swx, double swy) {
        if (this.skel().multi() > 1 || this.skel().isLoop()) {
            this.makeMultiOrLoop(camera, sox, soy, swx, swy);
        } else {
            this.makeSingle(camera, sox, soy, swx, swy);
        }
    }

    public void makeSingle(Camera camera, double sox, double soy, double swx, double swy) {
        try {
            double fromx = this.skel().from().x + sox;
            double fromy = this.skel().from().y + soy - this.theSourceSize().y / (double)2;
            double tox = this.skel().to().x + sox;
            double toy = this.skel().to().y + soy - this.theTargetSize().y / (double)2;
            double length = package$.MODULE$.abs(this.skel().to().x - this.skel().from().x);
            double c1x = 0.0;
            double c1y = 0.0;
            double c2x = 0.0;
            double c2y = 0.0;
            if (this.skel().from().x < this.skel().to().x) {
                c1x = (fromx += this.theSourceSize().x / (double)2) + length / (double)3;
                c2x = (tox -= this.theTargetSize().x / (double)2) - length / (double)3;
                c1y = fromy;
                c2y = toy;
            } else {
                c1x = (fromx -= this.theSourceSize().x / (double)2) - length / (double)3;
                c2x = (tox += this.theTargetSize().x / (double)2) + length / (double)3;
                c1y = fromy;
                c2y = toy;
            }
            this.theShape().reset();
            this.theShape().moveTo(fromx, fromy);
            this.theShape().curveTo(c1x, c1y, c2x, c2y, tox, toy);
            if (sox == 0.0 && soy == 0.0) {
                this.skel().setCurve(fromx, fromy, 0.0, c1x, c1y, 0.0, c2x, c2y, 0.0, tox, toy, 0.0);
            }
        }
        catch (Exception exception) {
            Logger.getLogger(this.getClass().getSimpleName()).log(Level.WARNING, "FOUND!", exception);
        }
    }

    public void makeMultiOrLoop(Camera camera, double sox, double soy, double swx, double swy) {
        if (this.skel().isLoop()) {
            this.makeLoop(camera, sox, soy, swx, swy);
        } else {
            this.makeMulti(camera, sox, soy, swx, swy);
        }
    }

    public void makeMulti(Camera camera, double sox, double soy, double swx, double swy) {
        double fromx = this.skel().apply((int)0).x + sox;
        double fromy = this.skel().apply((int)0).y + soy;
        double tox = this.skel().apply((int)3).x + sox;
        double toy = this.skel().apply((int)3).y + soy;
        double c1x = this.skel().apply((int)1).x + sox;
        double c1y = this.skel().apply((int)1).y + soy;
        double c2x = this.skel().apply((int)2).x + sox;
        double c2y = this.skel().apply((int)2).y + soy;
        this.theShape().reset();
        this.theShape().moveTo(fromx, fromy);
        this.theShape().curveTo(c1x, c1y, c2x, c2y, tox, toy);
    }

    public void makeLoop(Camera camera, double sox, double soy, double swx, double swy) {
        double fromx = this.skel().apply((int)0).x + sox;
        double fromy = this.skel().apply((int)0).y + soy;
        double tox = this.skel().apply((int)3).x + sox;
        double toy = this.skel().apply((int)3).y + soy;
        double c1x = this.skel().apply((int)1).x + sox;
        double c1y = this.skel().apply((int)1).y + soy;
        double c2x = this.skel().apply((int)2).x + sox;
        double c2y = this.skel().apply((int)2).y + soy;
        this.theShape().reset();
        this.theShape().moveTo(fromx, fromy);
        this.theShape().curveTo(c1x, c1y, c2x, c2y, tox, toy);
    }

    @Override
    public void makeShadow(Backend bck, Camera camera) {
        if (this.skel().isCurve()) {
            this.makeMultiOrLoop(camera, this.theShadowOff().x, this.theShadowOff().y, this.theShadowWidth(), this.theShadowWidth());
        } else {
            this.makeSingle(camera, this.theShadowOff().x, this.theShadowOff().y, this.theShadowWidth(), this.theShadowWidth());
        }
    }

    @Override
    public void renderShadow(Backend bck, Camera camera, GraphicElement element, Skeleton skel) {
        this.makeShadow(bck, camera);
        this.cast(bck.graphics2D(), this.theShape());
    }

    @Override
    public void render(Backend bck, Camera camera, GraphicElement element, Skeleton skel) {
        Graphics2D g = bck.graphics2D();
        this.make(bck, camera);
        this.stroke(g, this.theShape());
        this.fill(g, this.theSize(), this.theShape());
        this.decorConnector(bck, camera, skel.iconAndText(), element, this.theShape());
    }

    public FreePlaneEdgeShape() {
        HasSkel$class.$init$(this);
        Connector$class.$init$(this);
        Decorable$class.$init$(this);
        ConnectorShape$class.$init$(this);
        FillableLine$class.$init$(this);
        Strokable$class.$init$(this);
        StrokableLine$class.$init$(this);
        ShadowableLine$class.$init$(this);
        LineConnectorShape$class.$init$(this);
        this.theShape = new Path2D.Double();
    }
}

