/*
 * Decompiled with CFR 0.152.
 */
package org.graphstream.ui.j2dviewer;

import java.util.ArrayList;
import org.graphstream.graph.Node;
import org.graphstream.ui.geom.Point3;
import org.graphstream.ui.graphicGraph.GraphicEdge;
import org.graphstream.ui.graphicGraph.GraphicElement;
import org.graphstream.ui.graphicGraph.GraphicGraph;
import org.graphstream.ui.graphicGraph.GraphicNode;
import org.graphstream.ui.graphicGraph.GraphicSprite;
import org.graphstream.ui.graphicGraph.stylesheet.Selector;
import org.graphstream.ui.graphicGraph.stylesheet.StyleConstants;
import org.graphstream.ui.graphicGraph.stylesheet.Values;
import org.graphstream.ui.j2dviewer.Backend;
import org.graphstream.ui.j2dviewer.renderer.AreaSkeleton;
import org.graphstream.ui.j2dviewer.renderer.ConnectorSkeleton;
import org.graphstream.ui.j2dviewer.renderer.Skeleton$;
import org.graphstream.ui.swingViewer.util.GraphMetrics;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.collection.JavaConversions$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.HashSet;
import scala.collection.mutable.StringBuilder;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;

@ScalaSignature(bytes="\u0006\u0001\r%e\u0001B\u0001\u0003\u0001-\u0011aaQ1nKJ\f'BA\u0002\u0005\u0003%Q'\u0007\u001a<jK^,'O\u0003\u0002\u0006\r\u0005\u0011Q/\u001b\u0006\u0003\u000f!\t1b\u001a:ba\"\u001cHO]3b[*\t\u0011\"A\u0002pe\u001e\u001c\u0001aE\u0002\u0001\u0019Q\u0001\"!\u0004\n\u000e\u00039Q!a\u0004\t\u0002\t1\fgn\u001a\u0006\u0002#\u0005!!.\u0019<b\u0013\t\u0019bB\u0001\u0004PE*,7\r\u001e\t\u0003+ai\u0011A\u0006\u0006\u0003/\u0011\tAA^5fo&\u0011\u0011A\u0006\u0005\t5\u0001\u0011)\u0019!C\t7\u0005)qM]1qQV\tA\u0004\u0005\u0002\u001eA5\taD\u0003\u0002 \t\u0005aqM]1qQ&\u001cwI]1qQ&\u0011\u0011E\b\u0002\r\u000fJ\f\u0007\u000f[5d\u000fJ\f\u0007\u000f\u001b\u0005\tG\u0001\u0011\t\u0011)A\u00059\u00051qM]1qQ\u0002BQ!\n\u0001\u0005\u0002\u0019\na\u0001P5oSRtDCA\u0014*!\tA\u0003!D\u0001\u0003\u0011\u0015QB\u00051\u0001\u001d\u0011\u001dY\u0003A1A\u0005\u00021\nq!\\3ue&\u001c7/F\u0001.!\tq3'D\u00010\u0015\t\u0001\u0014'\u0001\u0003vi&d'B\u0001\u001a\u0005\u0003-\u0019x/\u001b8h-&,w/\u001a:\n\u0005Qz#\u0001D$sCBDW*\u001a;sS\u000e\u001c\bB\u0002\u001c\u0001A\u0003%Q&\u0001\u0005nKR\u0014\u0018nY:!\u0011\u001dA\u0004\u00011A\u0005\u0012e\nq!Y;u_\u001aKG/F\u0001;!\tYd(D\u0001=\u0015\u0005i\u0014!B:dC2\f\u0017BA =\u0005\u001d\u0011un\u001c7fC:Dq!\u0011\u0001A\u0002\u0013E!)A\u0006bkR|g)\u001b;`I\u0015\fHCA\"G!\tYD)\u0003\u0002Fy\t!QK\\5u\u0011\u001d9\u0005)!AA\u0002i\n1\u0001\u001f\u00132\u0011\u0019I\u0005\u0001)Q\u0005u\u0005A\u0011-\u001e;p\r&$\b\u0005C\u0004L\u0001\t\u0007I\u0011\u0003'\u0002\r\r,g\u000e^3s+\u0005i\u0005C\u0001(R\u001b\u0005y%B\u0001)\u0005\u0003\u00119Wm\\7\n\u0005I{%A\u0002)pS:$8\u0007\u0003\u0004U\u0001\u0001\u0006I!T\u0001\bG\u0016tG/\u001a:!\u0011\u001d1\u0006\u00011A\u0005\u0012]\u000bAA_8p[V\t\u0001\f\u0005\u0002<3&\u0011!\f\u0010\u0002\u0007\t>,(\r\\3\t\u000fq\u0003\u0001\u0019!C\t;\u0006A!p\\8n?\u0012*\u0017\u000f\u0006\u0002D=\"9qiWA\u0001\u0002\u0004A\u0006B\u00021\u0001A\u0003&\u0001,A\u0003{_>l\u0007\u0005C\u0004c\u0001\u0001\u0007I\u0011C,\u0002\u0011I|G/\u0019;j_:Dq\u0001\u001a\u0001A\u0002\u0013EQ-\u0001\u0007s_R\fG/[8o?\u0012*\u0017\u000f\u0006\u0002DM\"9qiYA\u0001\u0002\u0004A\u0006B\u00025\u0001A\u0003&\u0001,A\u0005s_R\fG/[8oA!9!\u000e\u0001a\u0001\n#Y\u0017a\u00029bI\u0012LgnZ\u000b\u0002YB\u0011Q\u000e]\u0007\u0002]*\u0011qNH\u0001\u000bgRLH.Z:iK\u0016$\u0018BA9o\u0005\u00191\u0016\r\\;fg\"91\u000f\u0001a\u0001\n#!\u0018a\u00039bI\u0012LgnZ0%KF$\"aQ;\t\u000f\u001d\u0013\u0018\u0011!a\u0001Y\"1q\u000f\u0001Q!\n1\f\u0001\u0002]1eI&tw\r\t\u0005\bs\u0002\u0001\r\u0011\"\u0005{\u0003\r\u00117m[\u000b\u0002wB\u0011\u0001\u0006`\u0005\u0003{\n\u0011qAQ1dW\u0016tG\r\u0003\u0005\u0000\u0001\u0001\u0007I\u0011CA\u0001\u0003\u001d\u00117m[0%KF$2aQA\u0002\u0011\u001d9e0!AA\u0002mDq!a\u0002\u0001A\u0003&10\u0001\u0003cG.\u0004\u0003\"CA\u0006\u0001\t\u0007I\u0011CA\u0007\u00035qw\u000eZ3J]ZL7/\u001b2mKV\u0011\u0011q\u0002\t\u0007\u0003#\tY\"a\b\u000e\u0005\u0005M!\u0002BA\u000b\u0003/\tq!\\;uC\ndWMC\u0002\u0002\u001aq\n!bY8mY\u0016\u001cG/[8o\u0013\u0011\ti\"a\u0005\u0003\u000f!\u000b7\u000f[*fiB!\u0011\u0011EA\u0014\u001d\rY\u00141E\u0005\u0004\u0003Ka\u0014A\u0002)sK\u0012,g-\u0003\u0003\u0002*\u0005-\"AB*ue&twMC\u0002\u0002&qB\u0001\"a\f\u0001A\u0003%\u0011qB\u0001\u000f]>$W-\u00138wSNL'\r\\3!\u0011%\t\u0019\u0004\u0001a\u0001\n#\t)$A\u0005hm&,w\u000f]8siV\u0011\u0011q\u0007\t\u0005w\u0005e\u0002,C\u0002\u0002<q\u0012Q!\u0011:sCfD\u0011\"a\u0010\u0001\u0001\u0004%\t\"!\u0011\u0002\u001b\u001d4\u0018.Z<q_J$x\fJ3r)\r\u0019\u00151\t\u0005\n\u000f\u0006u\u0012\u0011!a\u0001\u0003oA\u0001\"a\u0012\u0001A\u0003&\u0011qG\u0001\u000bOZLWm\u001e9peR\u0004\u0003bBA&\u0001\u0011\u0005\u0011QJ\u0001\u000bO\u0016$X*\u001a;sS\u000e\u001cH#A\u0017\t\r\u0005E\u0003\u0001\"\u0001M\u0003)1\u0018.Z<DK:$XM\u001d\u0005\b\u0003+\u0002A\u0011AA,\u000359W\r\u001e,jK^\u001cUM\u001c;feR\tQ\n\u0003\u0004\u0002\\\u0001!\taV\u0001\fm&,w\u000fU3sG\u0016tG\u000fC\u0004\u0002`\u0001!\t!!\u0019\u0002\u001d\u001d,GOV5foB+'oY3oiR\t\u0001\f\u0003\u0004\u0002f\u0001!\taV\u0001\rm&,wOU8uCRLwN\u001c\u0005\b\u0003S\u0002A\u0011AA1\u0003=9W\r\u001e,jK^\u0014v\u000e^1uS>t\u0007bBA7\u0001\u0011\u0005\u0011\u0011M\u0001\u0012O\u0016$xI]1qQ\u0012KW.\u001a8tS>t\u0007bBA9\u0001\u0011\u0005\u00131O\u0001\ti>\u001cFO]5oOR\u0011\u0011q\u0004\u0005\b\u0003o\u0002A\u0011AA=\u0003%I7OV5tS\ndW\rF\u0002;\u0003wB\u0001\"! \u0002v\u0001\u0007\u0011qP\u0001\bK2,W.\u001a8u!\ri\u0012\u0011Q\u0005\u0004\u0003\u0007s\"AD$sCBD\u0017nY#mK6,g\u000e\u001e\u0005\b\u0003\u000f\u0003A\u0011AAE\u0003=!(/\u00198tM>\u0014X\u000e\u0015=U_\u001e+H#B'\u0002\f\u0006=\u0005bBAG\u0003\u000b\u0003\r\u0001W\u0001\u0002q\"9\u0011\u0011SAC\u0001\u0004A\u0016!A=\t\u000f\u0005U\u0005\u0001\"\u0001\u0002\u0018\u0006yAO]1og\u001a|'/\\$v)>\u0004\u0006\u0010F\u0004N\u00033\u000bY*!(\t\u000f\u00055\u00151\u0013a\u00011\"9\u0011\u0011SAJ\u0001\u0004A\u0006bBAP\u0003'\u0003\r\u0001W\u0001\u0002u\"9\u00111\u0015\u0001\u0005\u0002\u0005\u0015\u0016A\u00054j]\u0012tu\u000eZ3PeN\u0003(/\u001b;f\u0003R$\u0002\"a \u0002(\u0006%\u00161\u0016\u0005\u00075\u0005\u0005\u0006\u0019\u0001\u000f\t\u000f\u00055\u0015\u0011\u0015a\u00011\"9\u0011\u0011SAQ\u0001\u0004A\u0006bBAX\u0001\u0011\u0005\u0011\u0011W\u0001\u0014C2dgj\u001c3fg>\u00138\u000b\u001d:ji\u0016\u001c\u0018J\u001c\u000b\r\u0003g\u000bi,a0\u0002D\u0006\u001d\u00171\u001a\t\u0007\u0003k\u000bI,a \u000e\u0005\u0005]&B\u0001\u0019\u0011\u0013\u0011\tY,a.\u0003\u0013\u0005\u0013(/Y=MSN$\bB\u0002\u000e\u0002.\u0002\u0007A\u0004C\u0004\u0002B\u00065\u0006\u0019\u0001-\u0002\u0005a\f\u0004bBAc\u0003[\u0003\r\u0001W\u0001\u0003sFBq!!3\u0002.\u0002\u0007\u0001,\u0001\u0002ye!9\u0011QZAW\u0001\u0004A\u0016AA=3\u0011\u001d\t\t\u000e\u0001C\u0001\u0003'\f\u0011cZ3u'B\u0014\u0018\u000e^3Q_NLG/[8o)\u001di\u0015Q[Ap\u0003GD\u0001\"a6\u0002P\u0002\u0007\u0011\u0011\\\u0001\u0007gB\u0014\u0018\u000e^3\u0011\u0007u\tY.C\u0002\u0002^z\u0011Qb\u0012:ba\"L7m\u00159sSR,\u0007bBAq\u0003\u001f\u0004\r!T\u0001\u0004a>\u001c\b\u0002CAs\u0003\u001f\u0004\r!a:\u0002\u000bUt\u0017\u000e^:\u0011\t\u0005%(\u0011\u0002\b\u0005\u0003W\u0014)A\u0004\u0003\u0002n\n\ra\u0002BAx\u0005\u0003qA!!=\u0002\u0000:!\u00111_A\u007f\u001d\u0011\t)0a?\u000e\u0005\u0005](bAA}\u0015\u00051AH]8pizJ\u0011!C\u0005\u0003\u000f!I!!\u0002\u0004\n\u0005}!\u0011BA8\u001f\u0013\r\u00119A\\\u0001\u000f'RLH.Z\"p]N$\u0018M\u001c;t\u0013\u0011\u0011YA!\u0004\u0003\u000bUs\u0017\u000e^:\u000b\u0007\t\u001da\u000eC\u0004\u0003\u0012\u0001!\t!!\u000e\u0002\u001b\u001d\u0014\u0018\r\u001d5WS\u0016<\bo\u001c:u\u0011\u001d\u0011)\u0002\u0001C\u0001\u0005/\t!b]3u\u0005\u0006\u001c7.\u001a8e)\r\u0019%\u0011\u0004\u0005\b\u00057\u0011\u0019\u00021\u0001|\u0003\u001d\u0011\u0017mY6f]\u0012DqAa\b\u0001\t\u0003\u0011\t#\u0001\ttKR<%/\u00199i-&,w\u000f]8siRI1Ia\t\u0003(\t-\"q\u0006\u0005\b\u0005K\u0011i\u00021\u0001Y\u0003\u0011i\u0017N\u001c=\t\u000f\t%\"Q\u0004a\u00011\u0006!Q.\u001b8z\u0011\u001d\u0011iC!\bA\u0002a\u000bA!\\1yq\"9!\u0011\u0007B\u000f\u0001\u0004A\u0016\u0001B7bqfDqA!\u000e\u0001\t\u0003\u00119$A\nsK6|g/Z$sCBDg+[3xa>\u0014H\u000fF\u0001D\u0011\u001d\u0011Y\u0004\u0001C\u0001\u0005o\t\u0011B]3tKR4\u0016.Z<\t\u000f\t}\u0002\u0001\"\u0001\u0003B\u0005A\u0001/^:i-&,w\u000fF\u0002D\u0005\u0007BaA\u0007B\u001f\u0001\u0004a\u0002b\u0002B$\u0001\u0011\u0005!qG\u0001\ba>\u0004h+[3x\u0011\u001d\u0011Y\u0005\u0001C\t\u0005o\t1\"Y;u_\u001aKGOV5fo\"9!q\n\u0001\u0005\u0012\t]\u0012\u0001C;tKJ4\u0016.Z<\t\u000f\tM\u0003\u0001\"\u0001\u0003V\u0005q1/\u001a;BkR|g)\u001b;WS\u0016<HcA\"\u0003X!9!\u0011\fB)\u0001\u0004Q\u0014AA8o\u0011\u001d\u0011i\u0006\u0001C\u0001\u0005?\nQb]3u-&,woQ3oi\u0016\u0014HcB\"\u0003b\t\r$Q\r\u0005\b\u0003\u001b\u0013Y\u00061\u0001Y\u0011\u001d\t\tJa\u0017A\u0002aCq!a(\u0003\\\u0001\u0007\u0001\fC\u0004\u0003j\u0001!\tAa\u001b\u0002\u001fYLWm\u001e)fe\u000e,g\u000e^0%KF$2a\u0011B7\u0011\u001d\tyJa\u001aA\u0002aCqA!\u001d\u0001\t\u0003\u0011\u0019(\u0001\btKR4\u0016.Z<QKJ\u001cWM\u001c;\u0015\u0007\r\u0013)\bC\u0004\u0002 \n=\u0004\u0019\u0001-\t\u000f\te\u0004\u0001\"\u0001\u0003|\u0005\u0001b/[3x%>$\u0018\r^5p]~#S-\u001d\u000b\u0004\u0007\nu\u0004b\u0002B@\u0005o\u0002\r\u0001W\u0001\u0006C:<G.\u001a\u0005\b\u0005\u0007\u0003A\u0011\u0001BC\u0003=\u0019X\r\u001e,jK^\u0014v\u000e^1uS>tGcA\"\u0003\b\"9!q\u0010BA\u0001\u0004A\u0006b\u0002BF\u0001\u0011\u0005!QR\u0001\fg\u0016$h+[3xa>\u0014H\u000fF\u0005D\u0005\u001f\u0013\tJa%\u0003\u0018\"9\u0011Q\u0012BE\u0001\u0004A\u0006bBAI\u0005\u0013\u0003\r\u0001\u0017\u0005\b\u0005+\u0013I\t1\u0001Y\u000351\u0018.Z<q_J$x+\u001b3uQ\"9!\u0011\u0014BE\u0001\u0004A\u0016A\u0004<jK^\u0004xN\u001d;IK&<\u0007\u000e\u001e\u0005\b\u0005;\u0003A\u0011\u0001BP\u0003%\u0019X\r\u001e\"pk:$7\u000fF\u0007D\u0005C\u0013\u0019K!*\u0003*\n-&Q\u0016\u0005\b\u0005K\u0011Y\n1\u0001Y\u0011\u001d\u0011ICa'A\u0002aCqAa*\u0003\u001c\u0002\u0007\u0001,\u0001\u0003nS:T\bb\u0002B\u0017\u00057\u0003\r\u0001\u0017\u0005\b\u0005c\u0011Y\n1\u0001Y\u0011\u001d\u0011yKa'A\u0002a\u000bA!\\1yu\"9!Q\u0014\u0001\u0005\u0002\tMFcA\"\u00036\"1!D!-A\u0002qAqA!/\u0001\t#\u0011Y,\u0001\u0006tKR\u0004\u0016\r\u001a3j]\u001e$2a\u0011B_\u0011\u0019Q\"q\u0017a\u00019!9!\u0011\u0019\u0001\u0005\u0012\t\r\u0017aD2iK\u000e\\g+[:jE&d\u0017\u000e^=\u0015\u0007\r\u0013)\r\u0003\u0004\u001b\u0005\u007f\u0003\r\u0001\b\u0005\u0007\u0005\u0013\u0004A\u0011C,\u0002\u0015A\fG\rZ5oOb;W\u000f\u0003\u0004\u0003N\u0002!\tbV\u0001\u000ba\u0006$G-\u001b8h3\u001e,\bB\u0002Bi\u0001\u0011Eq+\u0001\u0006qC\u0012$\u0017N\\4YabDaA!6\u0001\t#9\u0016A\u00039bI\u0012LgnZ-qq\"9!\u0011\u001c\u0001\u0005\u0012\tm\u0017aD5t'B\u0014\u0018\u000e^3WSNL'\r\\3\u0015\u0007i\u0012i\u000e\u0003\u0005\u0002X\n]\u0007\u0019AAm\u0011\u001d\u0011\t\u000f\u0001C\t\u0005G\fQ\"[:FI\u001e,g+[:jE2,Gc\u0001\u001e\u0003f\"A!q\u001dBp\u0001\u0004\u0011I/\u0001\u0003fI\u001e,\u0007cA\u000f\u0003l&\u0019!Q\u001e\u0010\u0003\u0017\u001d\u0013\u0018\r\u001d5jG\u0016#w-\u001a\u0005\b\u0005c\u0004A\u0011\u0003Bz\u0003!I7OT8eK&sGc\u0003\u001e\u0003v\n}81AB\u0004\u0007\u0017A\u0001Ba>\u0003p\u0002\u0007!\u0011`\u0001\u0005]>$W\rE\u0002\u001e\u0005wL1A!@\u001f\u0005-9%/\u00199iS\u000etu\u000eZ3\t\u000f\r\u0005!q\u001ea\u00011\u0006\u0011\u0001,\r\u0005\b\u0007\u000b\u0011y\u000f1\u0001Y\u0003\tI\u0016\u0007C\u0004\u0004\n\t=\b\u0019\u0001-\u0002\u0005a\u0013\u0004bBB\u0007\u0005_\u0004\r\u0001W\u0001\u00033JBqa!\u0005\u0001\t#\u0019\u0019\"\u0001\u0006jgN\u0003(/\u001b;f\u0013:$2BOB\u000b\u0007/\u0019Iba\u0007\u0004\u001e!A\u0011q[B\b\u0001\u0004\tI\u000eC\u0004\u0004\u0002\r=\u0001\u0019\u0001-\t\u000f\r\u00151q\u0002a\u00011\"91\u0011BB\b\u0001\u0004A\u0006bBB\u0007\u0007\u001f\u0001\r\u0001\u0017\u0005\b\u0007C\u0001A\u0011CB\u0012\u0003A\u0019\bO]5uKB{7/\u001b;j_:\u0004\u0006\u0010F\u0002N\u0007KA\u0001\"a6\u0004 \u0001\u0007\u0011\u0011\u001c\u0005\b\u0007S\u0001A\u0011CB\u0016\u00031qw\u000eZ3D_:$\u0018-\u001b8t)\u001dQ4QFB\u0019\u0007gA\u0001ba\f\u0004(\u0001\u0007\u0011qP\u0001\u0004K2$\bbBAG\u0007O\u0001\r\u0001\u0017\u0005\b\u0003#\u001b9\u00031\u0001Y\u0011\u001d\u00199\u0004\u0001C\t\u0007s\tab\u001d9sSR,7i\u001c8uC&t7\u000fF\u0004;\u0007w\u0019ida\u0010\t\u0011\r=2Q\u0007a\u0001\u0003\u007fBq!!$\u00046\u0001\u0007\u0001\fC\u0004\u0002\u0012\u000eU\u0002\u0019\u0001-\t\u000f\r\r\u0003\u0001\"\u0005\u0004F\u0005\u0019r-\u001a;O_\u0012,wJ]*qe&$XmU5{KR\u0019Ana\u0012\t\u0011\r=2\u0011\ta\u0001\u0003\u007fBqaa\u0013\u0001\t#\u0019i%\u0001\u0007tifdWMV5tS\ndW\rF\u0002;\u0007\u001fB\u0001\"! \u0004J\u0001\u0007\u0011q\u0010\u0005\b\u0007'\u0002A\u0011AB+\u00035I7\u000fV3yiZK7/\u001b2mKR\u0019!ha\u0016\t\u0011\u0005u4\u0011\u000ba\u0001\u0003\u007fBqaa\u0017\u0001\t\u0003\u0019i&A\rhKRtu\u000eZ3PeN\u0003(/\u001b;f!>\u001c\u0018\u000e^5p]\u001e+F#B'\u0004`\r\u0005\u0004\u0002CB\u0018\u00073\u0002\r!a \t\u000f\u0005\u00058\u0011\fa\u0001\u001b\"91Q\r\u0001\u0005\u0012\r\u001d\u0014!F4fiN\u0003(/\u001b;f!>\u001c\u0018\u000e^5p]\u001a\u0013X-\u001a\u000b\b\u001b\u000e%41NB8\u0011!\t9na\u0019A\u0002\u0005e\u0007bBB7\u0007G\u0002\r!T\u0001\ta>\u001c\u0018\u000e^5p]\"A\u0011Q]B2\u0001\u0004\t9\u000fC\u0004\u0004t\u0001!\tb!\u001e\u0002+\u001d,Go\u00159sSR,\u0007k\\:ji&|gNT8eKR9Qja\u001e\u0004z\rm\u0004\u0002CAl\u0007c\u0002\r!!7\t\u000f\r54\u0011\u000fa\u0001\u001b\"A\u0011Q]B9\u0001\u0004\t9\u000fC\u0004\u0004\u0000\u0001!\tb!!\u0002+\u001d,Go\u00159sSR,\u0007k\\:ji&|g.\u00123hKR9Qja!\u0004\u0006\u000e\u001d\u0005\u0002CAl\u0007{\u0002\r!!7\t\u000f\r54Q\u0010a\u0001\u001b\"A\u0011Q]B?\u0001\u0004\t9\u000f")
public class Camera
implements org.graphstream.ui.view.Camera {
    private final GraphicGraph graph;
    private final GraphMetrics metrics;
    private boolean autoFit;
    private final Point3 center;
    private double zoom;
    private double rotation;
    private Values padding;
    private Backend bck;
    private final HashSet<String> nodeInvisible;
    private double[] gviewport;

    public GraphicGraph graph() {
        return this.graph;
    }

    public GraphMetrics metrics() {
        return this.metrics;
    }

    public boolean autoFit() {
        return this.autoFit;
    }

    public void autoFit_$eq(boolean x$1) {
        this.autoFit = x$1;
    }

    public Point3 center() {
        return this.center;
    }

    public double zoom() {
        return this.zoom;
    }

    public void zoom_$eq(double x$1) {
        this.zoom = x$1;
    }

    public double rotation() {
        return this.rotation;
    }

    public void rotation_$eq(double x$1) {
        this.rotation = x$1;
    }

    public Values padding() {
        return this.padding;
    }

    public void padding_$eq(Values x$1) {
        this.padding = x$1;
    }

    public Backend bck() {
        return this.bck;
    }

    public void bck_$eq(Backend x$1) {
        this.bck = x$1;
    }

    public HashSet<String> nodeInvisible() {
        return this.nodeInvisible;
    }

    public double[] gviewport() {
        return this.gviewport;
    }

    public void gviewport_$eq(double[] x$1) {
        this.gviewport = x$1;
    }

    public GraphMetrics getMetrics() {
        return this.metrics();
    }

    public Point3 viewCenter() {
        return this.center();
    }

    public Point3 getViewCenter() {
        return this.viewCenter();
    }

    public double viewPercent() {
        return this.zoom();
    }

    public double getViewPercent() {
        return this.viewPercent();
    }

    public double viewRotation() {
        return this.rotation();
    }

    public double getViewRotation() {
        return this.viewRotation();
    }

    public double getGraphDimension() {
        return this.metrics().getDiagonal();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder(new StringOps(Predef$.MODULE$.augmentString("Camera :%n")).format(Nil$.MODULE$));
        builder.append(new StringOps(Predef$.MODULE$.augmentString("    autoFit  = %b%n")).format(Predef$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToBoolean(this.autoFit())})));
        builder.append(new StringOps(Predef$.MODULE$.augmentString("    center   = %s%n")).format(Predef$.MODULE$.genericWrapArray(new Object[]{this.center()})));
        builder.append(new StringOps(Predef$.MODULE$.augmentString("    rotation = %f%n")).format(Predef$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToDouble(this.rotation())})));
        builder.append(new StringOps(Predef$.MODULE$.augmentString("    zoom     = %f%n")).format(Predef$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToDouble(this.zoom())})));
        builder.append(new StringOps(Predef$.MODULE$.augmentString("    padding  = %s%n")).format(Predef$.MODULE$.genericWrapArray(new Object[]{this.padding()})));
        builder.append(new StringOps(Predef$.MODULE$.augmentString("    metrics  = %s%n")).format(Predef$.MODULE$.genericWrapArray(new Object[]{this.metrics()})));
        return builder.toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isVisible(GraphicElement element) {
        boolean bl;
        if (this.autoFit()) {
            if (element.hidden) return false;
            StyleConstants.VisibilityMode visibilityMode = element.style.getVisibilityMode();
            StyleConstants.VisibilityMode visibilityMode2 = StyleConstants.VisibilityMode.HIDDEN;
            if (visibilityMode != null) {
                if (!visibilityMode.equals(visibilityMode2)) return true;
                return false;
            }
            if (visibilityMode2 == null) return false;
            return true;
        }
        if (!this.styleVisible(element)) return false;
        Selector.Type type = element.getSelectorType();
        Selector.Type type2 = Selector.Type.NODE;
        Selector.Type type3 = type;
        if (!(type2 != null ? !type2.equals(type3) : type3 != null)) {
            if (!this.nodeInvisible().contains(element.getId())) return true;
            return false;
        }
        Selector.Type type4 = Selector.Type.EDGE;
        Selector.Type type5 = type;
        if (!(type4 != null ? !type4.equals(type5) : type5 != null)) {
            bl = this.isEdgeVisible((GraphicEdge)element);
        } else {
            Selector.Type type6 = Selector.Type.SPRITE;
            Selector.Type type7 = type;
            if (type6 == null) {
                if (type7 != null) {
                    return false;
                }
            } else if (!type6.equals(type7)) return false;
            bl = this.isSpriteVisible((GraphicSprite)element);
        }
        boolean bl2 = bl;
        return bl2;
    }

    public Point3 transformPxToGu(double x, double y) {
        return this.bck().inverseTransform(x, y, 0.0);
    }

    public Point3 transformGuToPx(double x, double y, double z) {
        return this.bck().transform(x, y, 0.0);
    }

    public GraphicElement findNodeOrSpriteAt(GraphicGraph graph, double x, double y) {
        ObjectRef<Object> ge = new ObjectRef<Object>(null);
        JavaConversions$.MODULE$.iterableAsScalaIterable(graph.getEachNode()).foreach(new Serializable(this, x, y, ge){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ Camera $outer;
            private final double x$1;
            private final double y$1;
            private final ObjectRef ge$1;

            public final void apply(Node n) {
                GraphicNode node = (GraphicNode)n;
                if (this.$outer.nodeContains((GraphicElement)node, this.x$1, this.y$1)) {
                    this.ge$1.elem = node;
                }
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.x$1 = x$1;
                this.y$1 = y$1;
                this.ge$1 = ge$1;
            }
        });
        JavaConversions$.MODULE$.iterableAsScalaIterable(graph.spriteSet()).foreach(new Serializable(this, x, y, ge){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ Camera $outer;
            private final double x$1;
            private final double y$1;
            private final ObjectRef ge$1;

            public final void apply(GraphicSprite sprite) {
                if (this.$outer.spriteContains((GraphicElement)sprite, this.x$1, this.y$1)) {
                    this.ge$1.elem = sprite;
                }
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.x$1 = x$1;
                this.y$1 = y$1;
                this.ge$1 = ge$1;
            }
        });
        return (GraphicElement)ge.elem;
    }

    public ArrayList<GraphicElement> allNodesOrSpritesIn(GraphicGraph graph, double x1, double y1, double x2, double y2) {
        ArrayList<GraphicElement> elts = new ArrayList<GraphicElement>();
        JavaConversions$.MODULE$.iterableAsScalaIterable(graph.getEachNode()).foreach(new Serializable(this, x1, y1, x2, y2, elts){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ Camera $outer;
            private final double x1$1;
            private final double y1$1;
            private final double x2$1;
            private final double y2$1;
            private final ArrayList elts$1;

            public final Object apply(Node node) {
                return this.$outer.isNodeIn((GraphicNode)node, this.x1$1, this.y1$1, this.x2$1, this.y2$1) ? BoxesRunTime.boxToBoolean(this.elts$1.add((GraphicNode)node)) : BoxedUnit.UNIT;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.x1$1 = x1$1;
                this.y1$1 = y1$1;
                this.x2$1 = x2$1;
                this.y2$1 = y2$1;
                this.elts$1 = elts$1;
            }
        });
        JavaConversions$.MODULE$.iterableAsScalaIterable(graph.spriteSet()).foreach(new Serializable(this, x1, y1, x2, y2, elts){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ Camera $outer;
            private final double x1$1;
            private final double y1$1;
            private final double x2$1;
            private final double y2$1;
            private final ArrayList elts$1;

            public final Object apply(GraphicSprite sprite) {
                return this.$outer.isSpriteIn(sprite, this.x1$1, this.y1$1, this.x2$1, this.y2$1) ? BoxesRunTime.boxToBoolean(this.elts$1.add(sprite)) : BoxedUnit.UNIT;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.x1$1 = x1$1;
                this.y1$1 = y1$1;
                this.x2$1 = x2$1;
                this.y2$1 = y2$1;
                this.elts$1 = elts$1;
            }
        });
        return elts;
    }

    public Point3 getSpritePosition(GraphicSprite sprite, Point3 pos, StyleConstants.Units units) {
        return sprite.isAttachedToNode() ? this.getSpritePositionNode(sprite, pos, units) : (sprite.isAttachedToEdge() ? this.getSpritePositionEdge(sprite, pos, units) : this.getSpritePositionFree(sprite, pos, units));
    }

    public double[] graphViewport() {
        return this.gviewport();
    }

    public void setBackend(Backend backend) {
        this.bck_$eq(backend);
    }

    public void setGraphViewport(double minx, double miny, double maxx, double maxy) {
        this.gviewport_$eq(new double[]{minx, miny, maxx, maxy});
    }

    public void removeGraphViewport() {
        this.gviewport_$eq(null);
    }

    public void resetView() {
        this.setAutoFitView(true);
        this.setViewRotation(0.0);
    }

    public void pushView(GraphicGraph graph) {
        this.bck().pushTransform();
        this.setPadding(graph);
        if (this.autoFit()) {
            this.autoFitView();
        } else {
            this.userView();
        }
        this.checkVisibility(graph);
    }

    public void popView() {
        this.bck().popTransform();
    }

    public void autoFitView() {
        double sx = 0.0;
        double sy = 0.0;
        double tx = 0.0;
        double ty = 0.0;
        double padXgu = this.paddingXgu() * (double)2;
        double padYgu = this.paddingYgu() * (double)2;
        double padXpx = this.paddingXpx() * (double)2;
        double padYpx = this.paddingYpx() * (double)2;
        if (padXpx > this.metrics().viewport[2]) {
            padXpx = this.metrics().viewport[2] / 10.0;
        }
        if (padYpx > this.metrics().viewport[3]) {
            padYpx = this.metrics().viewport[3] / 10.0;
        }
        sx = (this.metrics().viewport[2] - padXpx) / (this.metrics().size.data[0] + padXgu);
        sy = (this.metrics().viewport[3] - padYpx) / (this.metrics().size.data[1] + padYgu);
        tx = this.metrics().lo.x + this.metrics().size.data[0] / (double)2;
        ty = this.metrics().lo.y + this.metrics().size.data[1] / (double)2;
        if (sx > sy) {
            sx = sy;
        } else {
            sy = sx;
        }
        this.bck().beginTransform();
        this.bck().setIdentity();
        this.bck().translate(this.metrics().viewport[2] / (double)2, this.metrics().viewport[3] / (double)2, 0.0);
        if (this.rotation() != 0.0) {
            this.bck().rotate(this.rotation() / (180.0 / package$.MODULE$.Pi()), 0.0, 0.0, 1.0);
        }
        this.bck().scale(sx, -sy, 0.0);
        this.bck().translate(-tx, -ty, 0.0);
        this.bck().endTransform();
        this.zoom_$eq(1.0);
        this.center().set(tx, ty, 0.0);
        this.metrics().ratioPx2Gu = sx;
        this.metrics().loVisible.copy(this.metrics().lo);
        this.metrics().hiVisible.copy(this.metrics().hi);
    }

    public void userView() {
        double gh;
        double sx = 0.0;
        double sy = 0.0;
        double tx = 0.0;
        double ty = 0.0;
        double padXgu = this.paddingXgu() * (double)2;
        double padYgu = this.paddingYgu() * (double)2;
        double padXpx = this.paddingXpx() * (double)2;
        double padYpx = this.paddingYpx() * (double)2;
        double gw = this.gviewport() != null ? this.gviewport()[2] - this.gviewport()[0] : this.metrics().size.data[0];
        double d = gh = this.gviewport() != null ? this.gviewport()[3] - this.gviewport()[1] : this.metrics().size.data[1];
        if (padXpx > this.metrics().viewport[2]) {
            padXpx = this.metrics().viewport[2] / 10.0;
        }
        if (padYpx > this.metrics().viewport[3]) {
            padYpx = this.metrics().viewport[3] / 10.0;
        }
        sx = (this.metrics().viewport[2] - padXpx) / ((gw + padXgu) * this.zoom());
        sy = (this.metrics().viewport[3] - padYpx) / ((gh + padYgu) * this.zoom());
        tx = this.center().x;
        ty = this.center().y;
        if (sx > sy) {
            sx = sy;
        } else {
            sy = sx;
        }
        this.bck().beginTransform();
        this.bck().setIdentity();
        this.bck().translate(this.metrics().viewport[2] / (double)2, this.metrics().viewport[3] / (double)2, 0.0);
        if (this.rotation() != 0.0) {
            this.bck().rotate(this.rotation() / (180.0 / package$.MODULE$.Pi()), 0.0, 0.0, 1.0);
        }
        this.bck().scale(sx, -sy, 0.0);
        this.bck().translate(-tx, -ty, 0.0);
        this.bck().endTransform();
        this.metrics().ratioPx2Gu = sx;
        double w2 = this.metrics().viewport[2] / sx / 2.0;
        double h2 = this.metrics().viewport[3] / sx / 2.0;
        this.metrics().loVisible.set(this.center().x - w2, this.center().y - h2);
        this.metrics().hiVisible.set(this.center().x + w2, this.center().y + h2);
    }

    public void setAutoFitView(boolean on) {
        if (this.autoFit() && !on) {
            this.zoom_$eq(1.0);
            this.center().set(this.metrics().lo.x + this.metrics().size.data[0] / (double)2, this.metrics().lo.y + this.metrics().size.data[1] / (double)2, 0.0);
        }
        this.autoFit_$eq(on);
    }

    public void setViewCenter(double x, double y, double z) {
        this.setAutoFitView(false);
        this.center().set(x, y, z);
        this.graph().graphChanged = true;
    }

    public void viewPercent_$eq(double z) {
        this.zoom_$eq(z);
        this.graph().graphChanged = true;
    }

    public void setViewPercent(double z) {
        this.setAutoFitView(false);
        this.zoom_$eq(z);
        this.graph().graphChanged = true;
    }

    public void viewRotation_$eq(double angle) {
        this.rotation_$eq(angle);
        this.graph().graphChanged = true;
    }

    public void setViewRotation(double angle) {
        this.rotation_$eq(angle);
        this.graph().graphChanged = true;
    }

    public void setViewport(double x, double y, double viewportWidth, double viewportHeight) {
        this.metrics().setViewport(x, y, viewportWidth, viewportHeight);
    }

    public void setBounds(double minx, double miny, double minz, double maxx, double maxy, double maxz) {
        this.metrics().setBounds(minx, miny, minz, maxx, maxy, maxz);
    }

    public void setBounds(GraphicGraph graph) {
        this.setBounds(graph.getMinPos().x, graph.getMinPos().y, 0.0, graph.getMaxPos().x, graph.getMaxPos().y, 0.0);
    }

    public void setPadding(GraphicGraph graph) {
        this.padding().copy(graph.getStyle().getPadding());
    }

    public void checkVisibility(GraphicGraph graph) {
        this.nodeInvisible().clear();
        if (!this.autoFit()) {
            double X = this.metrics().viewport[0];
            double Y = this.metrics().viewport[1];
            double W = this.metrics().viewport[2];
            double H = this.metrics().viewport[3];
            JavaConversions$.MODULE$.iterableAsScalaIterable(graph.getEachNode()).foreach(new Serializable(this, X, Y, W, H){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ Camera $outer;
                private final double X$1;
                private final double Y$1;
                private final double W$1;
                private final double H$1;

                public final Object apply(Node node) {
                    GraphicNode n = (GraphicNode)node;
                    boolean visible = this.$outer.isNodeIn(n, this.X$1, this.Y$1, this.X$1 + this.W$1, this.Y$1 + this.H$1) && !n.hidden && n.positionned;
                    return visible ? BoxedUnit.UNIT : this.$outer.nodeInvisible().$plus$eq((Object)node.getId());
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                    this.X$1 = X$1;
                    this.Y$1 = Y$1;
                    this.W$1 = W$1;
                    this.H$1 = H$1;
                }
            });
        }
    }

    public double paddingXgu() {
        StyleConstants.Units units = this.padding().units;
        StyleConstants.Units units2 = StyleConstants.Units.GU;
        return !(units != null ? !units.equals(units2) : units2 != null) && this.padding().size() > 0 ? this.padding().get(0) : 0.0;
    }

    public double paddingYgu() {
        StyleConstants.Units units = this.padding().units;
        StyleConstants.Units units2 = StyleConstants.Units.GU;
        return !(units != null ? !units.equals(units2) : units2 != null) && this.padding().size() > 1 ? this.padding().get(1) : this.paddingXgu();
    }

    public double paddingXpx() {
        StyleConstants.Units units = this.padding().units;
        StyleConstants.Units units2 = StyleConstants.Units.PX;
        return !(units != null ? !units.equals(units2) : units2 != null) && this.padding().size() > 0 ? this.padding().get(0) : 0.0;
    }

    public double paddingYpx() {
        StyleConstants.Units units = this.padding().units;
        StyleConstants.Units units2 = StyleConstants.Units.PX;
        return !(units != null ? !units.equals(units2) : units2 != null) && this.padding().size() > 1 ? this.padding().get(1) : this.paddingXpx();
    }

    public boolean isSpriteVisible(GraphicSprite sprite) {
        return this.isSpriteIn(sprite, 0.0, 0.0, this.metrics().viewport[2], this.metrics().viewport[3]);
    }

    public boolean isEdgeVisible(GraphicEdge edge) {
        boolean bl;
        if (((GraphicNode)edge.getNode0()).positionned && ((GraphicNode)edge.getNode1()).positionned) {
            if (edge.hidden) {
                bl = false;
            } else {
                boolean node0Invis = this.nodeInvisible().contains(edge.getNode0().getId());
                boolean node1Invis = this.nodeInvisible().contains(edge.getNode1().getId());
                bl = !node0Invis || !node1Invis;
            }
        } else {
            bl = false;
        }
        return bl;
    }

    public boolean isNodeIn(GraphicNode node, double X1, double Y1, double X2, double Y2) {
        Values size2 = this.getNodeOrSpriteSize((GraphicElement)node);
        double w2 = this.metrics().lengthToPx(size2, 0) / (double)2;
        double h2 = size2.size() > 1 ? this.metrics().lengthToPx(size2, 1) / (double)2 : w2;
        Point3 src = new Point3(node.getX(), node.getY(), 0.0);
        this.bck().transform(src);
        double x1 = src.x - w2;
        double x2 = src.x + w2;
        double y1 = src.y - h2;
        double y2 = src.y + h2;
        return x2 < X1 ? false : (y2 < Y1 ? false : (x1 > X2 ? false : !(y1 > Y2)));
    }

    public boolean isSpriteIn(GraphicSprite sprite, double X1, double Y1, double X2, double Y2) {
        boolean bl;
        if (sprite.isAttachedToNode() && this.nodeInvisible().contains(sprite.getNodeAttachment().getId())) {
            bl = false;
        } else if (sprite.isAttachedToEdge() && !this.isEdgeVisible(sprite.getEdgeAttachment())) {
            bl = false;
        } else {
            Values size2 = sprite.getStyle().getSize();
            double w2 = this.metrics().lengthToPx(size2, 0) / (double)2;
            double h2 = size2.size() > 1 ? this.metrics().lengthToPx(size2, 1) / (double)2 : w2;
            Point3 src = this.spritePositionPx(sprite);
            double x1 = src.x - w2;
            double x2 = src.x + w2;
            double y1 = src.y - h2;
            double y2 = src.y + h2;
            bl = x2 < X1 ? false : (y2 < Y1 ? false : (x1 > X2 ? false : !(y1 > Y2)));
        }
        return bl;
    }

    public Point3 spritePositionPx(GraphicSprite sprite) {
        return this.getSpritePosition(sprite, new Point3(), StyleConstants.Units.PX);
    }

    public boolean nodeContains(GraphicElement elt, double x, double y) {
        Values size2 = this.getNodeOrSpriteSize(elt);
        double w2 = this.metrics().lengthToPx(size2, 0) / (double)2;
        double h2 = size2.size() > 1 ? this.metrics().lengthToPx(size2, 1) / (double)2 : w2;
        Point3 dst = this.bck().transform(elt.getX(), elt.getY(), 0.0);
        double x1 = dst.x - w2;
        double x2 = dst.x + w2;
        double y1 = dst.y - h2;
        double y2 = dst.y + h2;
        return x < x1 ? false : (y < y1 ? false : (x > x2 ? false : !(y > y2)));
    }

    public boolean spriteContains(GraphicElement elt, double x, double y) {
        GraphicSprite sprite = (GraphicSprite)elt;
        Values size2 = this.getNodeOrSpriteSize(elt);
        double w2 = this.metrics().lengthToPx(size2, 0) / (double)2;
        double h2 = size2.size() > 1 ? this.metrics().lengthToPx(size2, 1) / (double)2 : w2;
        Point3 dst = this.spritePositionPx(sprite);
        double x1 = dst.x - w2;
        double x2 = dst.x + w2;
        double y1 = dst.y - h2;
        double y2 = dst.y + h2;
        return x < x1 ? false : (y < y1 ? false : (x > x2 ? false : !(y > y2)));
    }

    public Values getNodeOrSpriteSize(GraphicElement elt) {
        AreaSkeleton info = (AreaSkeleton)elt.getAttribute(Skeleton$.MODULE$.attributeName());
        return info != null ? new Values(StyleConstants.Units.GU, new double[]{info.theSize().x, info.theSize().y}) : elt.getStyle().getSize();
    }

    public boolean styleVisible(GraphicElement element) {
        boolean bl;
        Values visibility = element.getStyle().getVisibility();
        StyleConstants.VisibilityMode visibilityMode = element.getStyle().getVisibilityMode();
        StyleConstants.VisibilityMode visibilityMode2 = StyleConstants.VisibilityMode.HIDDEN;
        StyleConstants.VisibilityMode visibilityMode3 = visibilityMode;
        if (!(visibilityMode2 != null ? !visibilityMode2.equals(visibilityMode3) : visibilityMode3 != null)) {
            bl = false;
        } else {
            StyleConstants.VisibilityMode visibilityMode4 = StyleConstants.VisibilityMode.AT_ZOOM;
            StyleConstants.VisibilityMode visibilityMode5 = visibilityMode;
            if (!(visibilityMode4 != null ? !visibilityMode4.equals(visibilityMode5) : visibilityMode5 != null)) {
                bl = this.zoom() == visibility.get(0);
            } else {
                StyleConstants.VisibilityMode visibilityMode6 = StyleConstants.VisibilityMode.UNDER_ZOOM;
                StyleConstants.VisibilityMode visibilityMode7 = visibilityMode;
                if (!(visibilityMode6 != null ? !visibilityMode6.equals(visibilityMode7) : visibilityMode7 != null)) {
                    bl = this.zoom() <= visibility.get(0);
                } else {
                    StyleConstants.VisibilityMode visibilityMode8 = StyleConstants.VisibilityMode.OVER_ZOOM;
                    StyleConstants.VisibilityMode visibilityMode9 = visibilityMode;
                    if (!(visibilityMode8 != null ? !visibilityMode8.equals(visibilityMode9) : visibilityMode9 != null)) {
                        bl = this.zoom() >= visibility.get(0);
                    } else {
                        StyleConstants.VisibilityMode visibilityMode10 = StyleConstants.VisibilityMode.ZOOM_RANGE;
                        StyleConstants.VisibilityMode visibilityMode11 = visibilityMode;
                        if (!(visibilityMode10 != null ? !visibilityMode10.equals(visibilityMode11) : visibilityMode11 != null)) {
                            bl = visibility.size() > 1 ? this.zoom() >= visibility.get(0) && this.zoom() <= visibility.get(1) : true;
                        } else {
                            StyleConstants.VisibilityMode visibilityMode12 = StyleConstants.VisibilityMode.ZOOMS;
                            StyleConstants.VisibilityMode visibilityMode13 = visibilityMode;
                            bl = !(visibilityMode12 != null ? !visibilityMode12.equals(visibilityMode13) : visibilityMode13 != null) ? Predef$.MODULE$.refArrayOps((Object[])Selector.Type.values()).contains(BoxesRunTime.boxToDouble(visibility.get(0))) : true;
                        }
                    }
                }
            }
        }
        return bl;
    }

    public boolean isTextVisible(GraphicElement element) {
        boolean bl;
        Values visibility = element.getStyle().getTextVisibility();
        StyleConstants.TextVisibilityMode textVisibilityMode = element.getStyle().getTextVisibilityMode();
        StyleConstants.TextVisibilityMode textVisibilityMode2 = StyleConstants.TextVisibilityMode.HIDDEN;
        StyleConstants.TextVisibilityMode textVisibilityMode3 = textVisibilityMode;
        if (!(textVisibilityMode2 != null ? !textVisibilityMode2.equals(textVisibilityMode3) : textVisibilityMode3 != null)) {
            bl = false;
        } else {
            StyleConstants.TextVisibilityMode textVisibilityMode4 = StyleConstants.TextVisibilityMode.AT_ZOOM;
            StyleConstants.TextVisibilityMode textVisibilityMode5 = textVisibilityMode;
            if (!(textVisibilityMode4 != null ? !textVisibilityMode4.equals(textVisibilityMode5) : textVisibilityMode5 != null)) {
                bl = this.zoom() == visibility.get(0);
            } else {
                StyleConstants.TextVisibilityMode textVisibilityMode6 = StyleConstants.TextVisibilityMode.UNDER_ZOOM;
                StyleConstants.TextVisibilityMode textVisibilityMode7 = textVisibilityMode;
                if (!(textVisibilityMode6 != null ? !textVisibilityMode6.equals(textVisibilityMode7) : textVisibilityMode7 != null)) {
                    bl = this.zoom() <= visibility.get(0);
                } else {
                    StyleConstants.TextVisibilityMode textVisibilityMode8 = StyleConstants.TextVisibilityMode.OVER_ZOOM;
                    StyleConstants.TextVisibilityMode textVisibilityMode9 = textVisibilityMode;
                    if (!(textVisibilityMode8 != null ? !textVisibilityMode8.equals(textVisibilityMode9) : textVisibilityMode9 != null)) {
                        bl = this.zoom() >= visibility.get(0);
                    } else {
                        StyleConstants.TextVisibilityMode textVisibilityMode10 = StyleConstants.TextVisibilityMode.ZOOM_RANGE;
                        StyleConstants.TextVisibilityMode textVisibilityMode11 = textVisibilityMode;
                        if (!(textVisibilityMode10 != null ? !textVisibilityMode10.equals(textVisibilityMode11) : textVisibilityMode11 != null)) {
                            bl = visibility.size() > 1 ? this.zoom() >= visibility.get(0) && this.zoom() <= visibility.get(1) : true;
                        } else {
                            StyleConstants.TextVisibilityMode textVisibilityMode12 = StyleConstants.TextVisibilityMode.ZOOMS;
                            StyleConstants.TextVisibilityMode textVisibilityMode13 = textVisibilityMode;
                            bl = !(textVisibilityMode12 != null ? !textVisibilityMode12.equals(textVisibilityMode13) : textVisibilityMode13 != null) ? Predef$.MODULE$.refArrayOps((Object[])Selector.Type.values()).contains(BoxesRunTime.boxToDouble(visibility.get(0))) : true;
                        }
                    }
                }
            }
        }
        return bl;
    }

    public Point3 getNodeOrSpritePositionGU(GraphicElement elt, Point3 pos) {
        GraphicElement graphicElement;
        block6: {
            Point3 point3;
            block5: {
                Point3 p;
                block4: {
                    p = pos;
                    if (p == null) {
                        p = new Point3();
                    }
                    if (!((graphicElement = elt) instanceof GraphicNode)) break block4;
                    GraphicNode graphicNode = (GraphicNode)graphicElement;
                    p.x = graphicNode.getX();
                    p.y = graphicNode.getY();
                    point3 = p;
                    break block5;
                }
                if (!(graphicElement instanceof GraphicSprite)) break block6;
                GraphicSprite graphicSprite = (GraphicSprite)graphicElement;
                point3 = this.getSpritePosition(graphicSprite, p, StyleConstants.Units.GU);
            }
            return point3;
        }
        throw new MatchError(graphicElement);
    }

    public Point3 getSpritePositionFree(GraphicSprite sprite, Point3 position, StyleConstants.Units units) {
        block10: {
            Point3 pos;
            block5: {
                BoxedUnit boxedUnit;
                block9: {
                    block8: {
                        block7: {
                            block6: {
                                block4: {
                                    pos = position;
                                    if (pos == null) {
                                        pos = new Point3();
                                    }
                                    StyleConstants.Units units2 = sprite.getUnits();
                                    StyleConstants.Units units3 = units;
                                    if (units2 != null ? !units2.equals(units3) : units3 != null) break block4;
                                    pos.x = sprite.getX();
                                    pos.y = sprite.getY();
                                    boxedUnit = BoxedUnit.UNIT;
                                    break block5;
                                }
                                StyleConstants.Units units4 = units;
                                StyleConstants.Units units5 = StyleConstants.Units.GU;
                                if (units4 != null ? !units4.equals(units5) : units5 != null) break block6;
                                StyleConstants.Units units6 = sprite.getUnits();
                                StyleConstants.Units units7 = StyleConstants.Units.PX;
                                if (units6 != null ? !units6.equals(units7) : units7 != null) break block6;
                                pos.x = sprite.getX();
                                pos.y = sprite.getY();
                                boxedUnit = this.bck().inverseTransform(pos);
                                break block5;
                            }
                            StyleConstants.Units units8 = units;
                            StyleConstants.Units units9 = StyleConstants.Units.PX;
                            if (units8 != null ? !units8.equals(units9) : units9 != null) break block7;
                            StyleConstants.Units units10 = sprite.getUnits();
                            StyleConstants.Units units11 = StyleConstants.Units.GU;
                            if (units10 != null ? !units10.equals(units11) : units11 != null) break block7;
                            pos.x = sprite.getX();
                            pos.y = sprite.getY();
                            boxedUnit = this.bck().transform(pos);
                            break block5;
                        }
                        StyleConstants.Units units12 = units;
                        StyleConstants.Units units13 = StyleConstants.Units.GU;
                        if (units12 != null ? !units12.equals(units13) : units13 != null) break block8;
                        StyleConstants.Units units14 = sprite.getUnits();
                        StyleConstants.Units units15 = StyleConstants.Units.PERCENTS;
                        if (units14 != null ? !units14.equals(units15) : units15 != null) break block8;
                        pos.x = this.metrics().lo.x + sprite.getX() / 100.0 * this.metrics().graphWidthGU();
                        pos.y = this.metrics().lo.y + sprite.getY() / 100.0 * this.metrics().graphHeightGU();
                        break block9;
                    }
                    StyleConstants.Units units16 = units;
                    StyleConstants.Units units17 = StyleConstants.Units.PX;
                    if (units16 != null ? !units16.equals(units17) : units17 != null) break block10;
                    StyleConstants.Units units18 = sprite.getUnits();
                    StyleConstants.Units units19 = StyleConstants.Units.PERCENTS;
                    if (units18 != null ? !units18.equals(units19) : units19 != null) break block10;
                    pos.x = sprite.getX() / 100.0 * this.metrics().viewport[2];
                    pos.y = sprite.getY() / 100.0 * this.metrics().viewport[3];
                }
                boxedUnit = BoxedUnit.UNIT;
            }
            return pos;
        }
        throw new RuntimeException(new StringOps(Predef$.MODULE$.augmentString("Unhandled yet sprite positioning convertion %s to %s.")).format(Predef$.MODULE$.genericWrapArray(new Object[]{sprite.getUnits(), units})));
    }

    public Point3 getSpritePositionNode(GraphicSprite sprite, Point3 position, StyleConstants.Units units) {
        Point3 pos = position;
        if (pos == null) {
            pos = new Point3();
        }
        GraphicNode node = sprite.getNodeAttachment();
        double radius = this.metrics().lengthToGu(sprite.getX(), sprite.getUnits());
        double z = sprite.getZ() * (package$.MODULE$.Pi() / 180.0);
        pos.x = node.x + package$.MODULE$.cos(z) * radius;
        pos.y = node.y + package$.MODULE$.sin(z) * radius;
        StyleConstants.Units units2 = units;
        StyleConstants.Units units3 = StyleConstants.Units.PX;
        BoxedUnit boxedUnit = !(units2 != null ? !units2.equals(units3) : units3 != null) ? this.bck().transform(pos) : BoxedUnit.UNIT;
        return pos;
    }

    public Point3 getSpritePositionEdge(GraphicSprite sprite, Point3 position, StyleConstants.Units units) {
        GraphicEdge edge;
        ConnectorSkeleton info;
        Point3 pos = position;
        if (pos == null) {
            pos = new Point3();
        }
        if ((info = (ConnectorSkeleton)(edge = sprite.getEdgeAttachment()).getAttribute(Skeleton$.MODULE$.attributeName())) != null) {
            double o = this.metrics().lengthToGu(sprite.getY(), sprite.getUnits());
            if (o == 0.0) {
                Point3 p = info.pointOnShape(sprite.getX());
                pos.x = p.x;
                pos.y = p.y;
            } else {
                Point3 p = info.pointOnShapeAndPerpendicular(sprite.getX(), o);
                pos.x = p.x;
                pos.y = p.y;
            }
        } else {
            double x = 0.0;
            double y = 0.0;
            double dx = 0.0;
            double dy = 0.0;
            double d = sprite.getX();
            double o = this.metrics().lengthToGu(sprite.getY(), sprite.getUnits());
            x = edge.from.x;
            y = edge.from.y;
            dx = edge.to.x - x;
            dy = edge.to.y - y;
            d = d > 1.0 ? 1.0 : d;
            d = d < 0.0 ? 0.0 : d;
            x += dx * d;
            y += dy * d;
            if (o != 0.0) {
                d = package$.MODULE$.sqrt(dx * dx + dy * dy);
                x += -(dy /= d) * o;
                y += (dx /= d) * o;
            }
            pos.x = x;
            pos.y = y;
        }
        StyleConstants.Units units2 = units;
        StyleConstants.Units units3 = StyleConstants.Units.PX;
        BoxedUnit boxedUnit = !(units2 != null ? !units2.equals(units3) : units3 != null) ? this.bck().transform(pos) : BoxedUnit.UNIT;
        return pos;
    }

    public Camera(GraphicGraph graph) {
        this.graph = graph;
        this.metrics = new GraphMetrics();
        this.autoFit = true;
        this.center = new Point3();
        this.zoom = 1.0;
        this.rotation = 0.0;
        this.padding = new Values(StyleConstants.Units.GU, new double[]{0.0, 0.0, 0.0});
        this.bck = null;
        this.nodeInvisible = new HashSet();
        this.gviewport = null;
    }
}

