/*
 * Decompiled with CFR 0.152.
 */
package ancestris.report.svgtree.arrange;

import ancestris.report.svgtree.IndiBox;
import ancestris.report.svgtree.arrange.AbstractArranger;

public class AlignLeftArranger
extends AbstractArranger {
    public AlignLeftArranger(int spacing) {
        super(spacing);
    }

    @Override
    public void filter(IndiBox indibox) {
        indibox.wPlus = indibox.width;
        indibox.hPlus = 1;
        super.filter(indibox);
    }

    @Override
    protected void arrangeSpouse(IndiBox indibox, IndiBox spouse) {
        spouse.wPlus = spouse.width;
        spouse.x = indibox.width;
    }

    @Override
    protected void arrangeChildren(IndiBox indibox) {
        int currentX = 0;
        if (indibox.getDir() == IndiBox.Direction.PARENT) {
            currentX = indibox.prev.width / 2 - indibox.x + this.spacing;
        }
        for (int i = 0; i < indibox.children.length; ++i) {
            IndiBox child = indibox.children[i];
            child.y = 1;
            this.filter(child);
            child.x = currentX + child.wMinus;
            currentX += child.wMinus + child.wPlus + this.spacing;
        }
        int parentWidth = indibox.wMinus + indibox.wPlus;
        int childrenWidth = currentX - this.spacing;
        if (parentWidth > childrenWidth) {
            int diff = (parentWidth - childrenWidth) / 2 - indibox.wMinus;
            for (int i = 0; i < indibox.children.length; ++i) {
                IndiBox child = indibox.children[i];
                child.x += diff;
            }
        }
    }

    @Override
    protected void arrangeNextMarriages(IndiBox indibox, IndiBox next) {
        this.filter(next);
        next.x = indibox.wPlus + next.wMinus + this.spacing;
        if (indibox.spouse != null && indibox.spouse.nextMarriage == next) {
            next.x -= indibox.spouse.x;
        }
    }

    @Override
    protected void arrangeSpouseParent(IndiBox indibox, IndiBox parent) {
        this.filter(parent);
        parent.x = parent.wMinus;
        parent.y = -parent.hPlus;
    }

    @Override
    protected void arrangeParent(IndiBox indibox, IndiBox parent) {
        this.filter(parent);
        parent.y = -indibox.hMinus - parent.hPlus;
    }
}

