/*
 * Decompiled with CFR 0.152.
 */
package ancestris.gedcom.privacy.standard;

import ancestris.gedcom.privacy.PrivacyPolicy;
import ancestris.gedcom.privacy.standard.Options;
import genj.gedcom.Entity;
import genj.gedcom.Fam;
import genj.gedcom.Gedcom;
import genj.gedcom.Indi;
import genj.gedcom.Property;
import genj.gedcom.PropertyDate;
import genj.gedcom.PropertyXRef;
import genj.gedcom.time.Delta;
import genj.io.Filter;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.netbeans.api.options.OptionsDisplayer;
import org.openide.util.NbBundle;

public class PrivacyPolicyImpl
extends PrivacyPolicy
implements Filter {
    private Set<Entity> privateYearsEntities = new HashSet<Entity>();
    private Set<Entity> aliveEntities = new HashSet<Entity>();
    private static final PrivacyPolicy PUBLIC = new PrivacyPolicyImpl(){

        @Override
        public boolean isPrivate(Property prop) {
            return false;
        }
    };
    private static final PrivacyPolicy PRIVATE = new PrivacyPolicyImpl(){

        @Override
        public boolean isPrivate(Property prop) {
            return true;
        }
    };

    public PrivacyPolicy getAllPublic() {
        return PUBLIC;
    }

    public PrivacyPolicy getAllPrivate() {
        return PRIVATE;
    }

    public String getPrivateMask() {
        return Options.getInstance().getPrivateMask();
    }

    public void openPreferences() {
        OptionsDisplayer.getDefault().open("OptionFormat/Privacy");
    }

    public boolean isPrivate(Property prop) {
        if (Options.getInstance().deadIsPublic() && this.isInfoOfDeceased(prop)) {
            return false;
        }
        if (Options.getInstance().getPrivateYears() > 0 && this.isWithinPrivateYears(prop)) {
            return true;
        }
        if (Options.getInstance().aliveIsPrivate() && this.isInfoOfAlive(prop)) {
            return true;
        }
        return Options.getInstance().getPrivateTag() != null && this.hasTagMarkingPrivate(prop);
    }

    private boolean isWithinPrivateYears(Property prop) {
        if (prop == null) {
            return false;
        }
        Entity ent = prop.getEntity();
        if (this.privateYearsEntities.contains(ent)) {
            return true;
        }
        if (ent instanceof Indi || ent instanceof Fam) {
            if (this.hasPrivateYearsDate((Property)ent)) {
                this.privateYearsEntities.add(ent);
                return true;
            }
        } else {
            List<Entity> list = this.getRelatedPeople(ent);
            if (!list.isEmpty()) {
                for (Entity entity : list) {
                    if (this.privateYearsEntities.contains(entity)) {
                        return true;
                    }
                    if (!this.hasPrivateYearsDate((Property)entity)) continue;
                    this.privateYearsEntities.add(entity);
                    this.privateYearsEntities.add(ent);
                    return true;
                }
            }
        }
        return false;
    }

    private boolean isInfoOfAlive(Property prop) {
        if (prop == null) {
            return false;
        }
        Entity ent = prop.getEntity();
        if (this.aliveEntities.contains(ent)) {
            return true;
        }
        if (ent instanceof Indi) {
            if (this.isAlive((Indi)ent)) {
                this.aliveEntities.add(ent);
                return true;
            }
        } else {
            if (ent instanceof Fam) {
                Indi husband = ((Fam)ent).getHusband();
                if (husband != null && this.isAlive(husband)) {
                    this.aliveEntities.add((Entity)husband);
                    this.aliveEntities.add(ent);
                    return true;
                }
                Indi wife = ((Fam)ent).getWife();
                if (wife != null && this.isAlive(wife)) {
                    this.aliveEntities.add((Entity)wife);
                    this.aliveEntities.add(ent);
                    return true;
                }
                return false;
            }
            List<Entity> list = this.getRelatedPeople(ent);
            if (!list.isEmpty()) {
                for (Entity entity : list) {
                    if (this.aliveEntities.contains(entity)) {
                        return true;
                    }
                    if (entity instanceof Indi && this.isAlive((Indi)entity)) {
                        this.aliveEntities.add(entity);
                        this.aliveEntities.add(ent);
                        return true;
                    }
                    if (!(entity instanceof Fam)) continue;
                    Indi husband = ((Fam)entity).getHusband();
                    if (husband != null && this.isAlive(husband)) {
                        this.aliveEntities.add((Entity)husband);
                        this.aliveEntities.add(ent);
                        return true;
                    }
                    Indi wife = ((Fam)entity).getWife();
                    if (wife == null || !this.isAlive(wife)) continue;
                    this.aliveEntities.add((Entity)wife);
                    this.aliveEntities.add(ent);
                    return true;
                }
            }
        }
        return false;
    }

    private boolean hasTagMarkingPrivate(Property prop) {
        if (this.getPropertyFor(prop, Options.getInstance().getPrivateTag(), Property.class) != null) {
            return true;
        }
        if ((prop = prop.getParent()) != null) {
            return this.hasTagMarkingPrivate(prop);
        }
        return false;
    }

    private boolean isInfoOfDeceased(Property prop) {
        Entity e = prop.getEntity();
        if (e instanceof Indi) {
            return ((Indi)e).isDeceased();
        }
        if (e instanceof Fam) {
            Indi husband = ((Fam)e).getHusband();
            if (husband != null && !husband.isDeceased()) {
                return false;
            }
            Indi wife = ((Fam)e).getWife();
            return wife != null && wife.isDeceased();
        }
        return false;
    }

    private boolean hasPrivateYearsDate(Property prop) {
        List dateProps = prop.getProperties(PropertyDate.class);
        for (PropertyDate propertyDate : dateProps) {
            if (!this.isDatePrivate(propertyDate)) continue;
            return true;
        }
        return false;
    }

    private boolean isDatePrivate(PropertyDate date) {
        if (date == null) {
            return false;
        }
        Delta anniversary = date.getAnniversary();
        return anniversary != null && anniversary.getYears() < Options.getInstance().getPrivateYears();
    }

    private boolean isAlive(Indi indi) {
        PropertyDate bdate = indi.getBirthDate();
        PropertyDate ddate = indi.getDeathDate();
        if (bdate == null) {
            return false;
        }
        Delta anniversary = bdate.getAnniversary();
        return ddate == null && anniversary != null && anniversary.getYears() < Options.getInstance().getYearsIndiCanBeAlive();
    }

    private List<Entity> getRelatedPeople(Entity ent) {
        ArrayList<Entity> list = new ArrayList<Entity>();
        List refProps = ent.getProperties(PropertyXRef.class);
        for (PropertyXRef propertyXRef : refProps) {
            Entity target = propertyXRef.getTargetEntity();
            if (list.contains(target) || !(target instanceof Indi) && !(target instanceof Fam)) continue;
            list.add(target);
        }
        return list;
    }

    private Property getPropertyFor(Property prop, String tag, Class<?> type) {
        int j = prop.getNoOfProperties();
        for (int i = 0; i < j; ++i) {
            Property child = prop.getProperty(i);
            if (!child.getTag().equals(tag) || !type.isAssignableFrom(child.getClass())) continue;
            return child;
        }
        return null;
    }

    public String getFilterName() {
        return NbBundle.getMessage(PrivacyPolicyImpl.class, (String)"PrivacyFilterName");
    }

    public boolean veto(Property property) {
        return this.isPrivate(property);
    }

    public boolean veto(Entity entity) {
        return this.isPrivate((Property)entity);
    }

    public boolean canApplyTo(Gedcom gedcom) {
        return true;
    }

    public void clear() {
        this.privateYearsEntities.clear();
        this.aliveEntities.clear();
    }
}

