/*
 * Decompiled with CFR 0.152.
 */
package ancestris.explorer;

import ancestris.explorer.EntitiesNode;
import ancestris.explorer.GedcomEntities;
import genj.gedcom.Entity;
import genj.gedcom.Gedcom;
import java.util.ArrayList;
import java.util.HashSet;
import org.openide.nodes.Children;
import org.openide.nodes.Node;

public class EntitiesChildren
extends Children.Keys<GedcomEntities> {
    private final Gedcom gedcom;

    EntitiesChildren(Gedcom gedcom) {
        this.gedcom = gedcom;
    }

    protected Node[] createNodes(GedcomEntities key) {
        return new Node[]{new EntitiesNode(this.gedcom, key)};
    }

    protected void addNotify() {
        super.addNotify();
        HashSet<String> tagEntities = new HashSet<String>();
        for (String e : Gedcom.ENTITIES) {
            tagEntities.add(e);
        }
        for (Entity e : this.gedcom.getEntities()) {
            tagEntities.add(e.getTag());
        }
        tagEntities.remove("HEAD");
        ArrayList<String> tagsList = new ArrayList<String>();
        for (String e : Gedcom.ENTITIES) {
            tagsList.add(e);
            tagEntities.remove(e);
        }
        tagsList.addAll(tagEntities);
        Object[] objs = new GedcomEntities[tagsList.size()];
        String[] tags = tagsList.toArray(new String[0]);
        for (int i = 0; i < objs.length; ++i) {
            GedcomEntities cat = new GedcomEntities(this.gedcom, tags[i]);
            objs[i] = cat;
        }
        this.setKeys(objs);
    }
}

