/*
 * Decompiled with CFR 0.152.
 */
package org.miv.pherd.ntree;

import org.miv.pherd.Particle;
import org.miv.pherd.geom.Point3;
import org.miv.pherd.ntree.Anchor;
import org.miv.pherd.ntree.CellSpace;

public class QuadtreeCellSpace
extends CellSpace {
    protected Anchor C;

    public QuadtreeCellSpace(Anchor lo, Anchor hi) {
        super(lo, hi);
    }

    @Override
    public int getDivisions() {
        return 4;
    }

    @Override
    public boolean contains(Particle particle) {
        Point3 pos = particle.getPosition();
        return this.contains(pos.x, pos.y);
    }

    @Override
    public boolean contains(double x, double y, double z) {
        if (x < this.lo.x || x >= this.hi.x) {
            return false;
        }
        return !(y < this.lo.y) && !(y >= this.hi.y);
    }

    public boolean contains(double x, double y) {
        if (x < this.lo.x || x >= this.hi.x) {
            return false;
        }
        return !(y < this.lo.y) && !(y >= this.hi.y);
    }

    @Override
    public CellSpace newSubCellSpace(int i) {
        if (this.C == null) {
            double cx = this.lo.x + (this.hi.x - this.lo.x) / 2.0;
            double cy = this.lo.y + (this.hi.y - this.lo.y) / 2.0;
            this.C = new Anchor(cx, cy, this.hi.z);
        }
        Anchor BL = this.lo;
        Anchor TR = this.hi;
        switch (i) {
            case 0: {
                this.C.z = this.hi.z;
                return new QuadtreeCellSpace(BL, this.C);
            }
            case 1: {
                Anchor BR1 = new Anchor(this.C.x, BL.y, this.lo.z);
                Anchor BR2 = new Anchor(TR.x, this.C.y, this.hi.z);
                return new QuadtreeCellSpace(BR1, BR2);
            }
            case 2: {
                Anchor TL1 = new Anchor(BL.x, this.C.y, this.lo.z);
                Anchor TL2 = new Anchor(this.C.x, TR.y, this.hi.z);
                return new QuadtreeCellSpace(TL1, TL2);
            }
            case 3: {
                this.C.z = this.lo.z;
                return new QuadtreeCellSpace(this.C, TR);
            }
        }
        throw new RuntimeException("invalid subcell space index '" + i + "' for quad tree");
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        sb.append(this.lo.x);
        sb.append(", ");
        sb.append(this.lo.y);
        sb.append(" -> ");
        sb.append(this.hi.x);
        sb.append(", ");
        sb.append(this.hi.y);
        sb.append("]");
        return sb.toString();
    }

    @Override
    public void resize(Point3 min, Point3 max) {
        super.resize(min, max);
        double cx = this.lo.x + (this.hi.x - this.lo.x) / 2.0;
        double cy = this.lo.y + (this.hi.y - this.lo.y) / 2.0;
        double cz = this.lo.z + (this.hi.z - this.lo.z) / 2.0;
        this.C = new Anchor(cx, cy, cz);
    }
}

