/*
 * Decompiled with CFR 0.152.
 */
package org.miv.pherd.ntree;

import java.util.ArrayList;
import org.miv.mbox.MBoxListener;
import org.miv.mbox.MBoxStandalone;
import org.miv.pherd.ntree.Anchor;
import org.miv.pherd.ntree.Cell;
import org.miv.pherd.ntree.NTree;
import org.miv.pherd.ntree.NTreeListener;

public class NTreeListenerProxy
implements NTreeListener,
MBoxListener {
    protected MBoxStandalone events;
    protected ArrayList<NTreeListener> listeners = new ArrayList();

    public NTreeListenerProxy(NTree tree, boolean replay) {
        this.events = new MBoxStandalone(this);
        this.connect(tree, replay);
    }

    public void disconnect(NTree tree) {
        tree.removeListener(this);
    }

    public void connect(NTree tree, boolean replay) {
        tree.addListener(this);
        if (replay) {
            this.replayTree(tree);
        }
    }

    protected void replayTree(NTree tree) {
        this.replayTree(tree.getRootCell());
    }

    protected void replayTree(Cell cell) {
        this.cellAdded(cell.getId(), cell.getParent() != null ? cell.getParent().getId() : null, cell.getSpace().getLoAnchor(), cell.getSpace().getHiAnchor(), cell.getDepth(), cell.getIndex());
        if (!cell.isLeaf()) {
            int n = cell.getSpace().getDivisions();
            for (int i = 0; i < n; ++i) {
                this.replayTree(cell.getSub(i));
            }
        }
    }

    public void addNTreeListener(NTreeListener listener) {
        this.listeners.add(listener);
    }

    public void removeNTReeListener(NTreeListener listener) {
        int index = this.listeners.indexOf(listener);
        if (index >= 0) {
            this.listeners.remove(index);
        }
    }

    public void checkEvents() {
        this.events.processMessages();
    }

    @Override
    public void processMessage(String from, Object[] data) {
        if (data.length > 0) {
            if (data[0].equals("CA")) {
                Anchor lo = (Anchor)data[3];
                Anchor hi = (Anchor)data[4];
                int depth = ((Number)data[5]).intValue();
                int index = ((Number)data[6]).intValue();
                for (NTreeListener listener : this.listeners) {
                    listener.cellAdded(data[1], data[2], lo, hi, depth, index);
                }
            } else if (data[0].equals("CD")) {
                String msg = (String)data[2];
                for (NTreeListener listener : this.listeners) {
                    listener.cellData(data[1], msg, data[3]);
                }
            } else if (data[0].equals("CR")) {
                for (NTreeListener listener : this.listeners) {
                    listener.cellRemoved(data[1]);
                }
            } else {
                if (data.length > 0 && data[0] instanceof String) {
                    throw new RuntimeException("NTReeListenerProxy: uncaught message from " + from + " : " + data[0] + "[" + data.length + "]");
                }
                throw new RuntimeException("NTreeListenerProxy: uncaught message from " + from + " : [" + data.length + "]");
            }
        }
    }

    @Override
    public void cellAdded(Object id, Object parentId, Anchor lo, Anchor hi, int depth, int index) {
        this.events.post("me", "CA", id, parentId, lo, hi, depth, index);
    }

    @Override
    public void cellData(Object id, String message, Object data) {
        this.events.post("me", "CD", id, message, data);
    }

    @Override
    public void cellRemoved(Object id) {
        this.events.post("me", "CR", id);
    }
}

