/*
 * Decompiled with CFR 0.152.
 */
package org.miv.pherd.geom;

import org.miv.pherd.geom.Point3;
import org.miv.pherd.geom.Vector2;

public class Vector3
extends Vector2 {
    private static final long serialVersionUID = 8839258036865851454L;

    public Vector3() {
        this.data = new double[3];
        this.data[0] = 0.0;
        this.data[1] = 0.0;
        this.data[2] = 0.0;
    }

    public Vector3(double x, double y, double z) {
        this.data = new double[3];
        this.data[0] = x;
        this.data[1] = y;
        this.data[2] = z;
    }

    public Vector3(Vector3 other) {
        this.data = new double[3];
        this.copy(other);
    }

    public Vector3(Point3 point) {
        this.data = new double[3];
        this.copy(point);
    }

    @Override
    public boolean isZero() {
        return this.data[0] == 0.0 && this.data[1] == 0.0 && this.data[2] == 0.0;
    }

    @Override
    public boolean equals(Object other) {
        if (!(other instanceof Vector3)) {
            return false;
        }
        Vector3 v = (Vector3)other;
        return this.data[0] == v.data[0] && this.data[1] == v.data[1] && this.data[2] == v.data[2];
    }

    public boolean equals(Vector3 other) {
        return this.data[0] == other.data[0] && this.data[1] == other.data[1] && this.data[2] == other.data[2];
    }

    @Override
    public boolean validComponent(int i) {
        return i >= 0 && i < 3;
    }

    @Override
    public Object clone() {
        return new Vector3(this);
    }

    public double dotProduct(Vector3 other) {
        return this.data[0] * other.data[0] + this.data[1] * other.data[1] + this.data[2] * other.data[2];
    }

    @Override
    public double length() {
        return Math.sqrt(this.data[0] * this.data[0] + this.data[1] * this.data[1] + this.data[2] * this.data[2]);
    }

    @Override
    public void fill(double value) {
        this.data[1] = this.data[2] = value;
        this.data[0] = this.data[2];
    }

    @Override
    public void set(int i, double value) {
        this.data[i] = value;
    }

    public void set(double x, double y, double z) {
        this.data[0] = x;
        this.data[1] = y;
        this.data[2] = z;
    }

    public void add(Vector3 other) {
        this.data[0] = this.data[0] + other.data[0];
        this.data[1] = this.data[1] + other.data[1];
        this.data[2] = this.data[2] + other.data[2];
    }

    public void sub(Vector3 other) {
        this.data[0] = this.data[0] - other.data[0];
        this.data[1] = this.data[1] - other.data[1];
        this.data[2] = this.data[2] - other.data[2];
    }

    public void mult(Vector3 other) {
        this.data[0] = this.data[0] * other.data[0];
        this.data[1] = this.data[1] * other.data[1];
        this.data[2] = this.data[2] * other.data[2];
    }

    @Override
    public void scalarAdd(double value) {
        this.data[0] = this.data[0] + value;
        this.data[1] = this.data[1] + value;
        this.data[2] = this.data[2] + value;
    }

    @Override
    public void scalarSub(double value) {
        this.data[0] = this.data[0] - value;
        this.data[1] = this.data[1] - value;
        this.data[2] = this.data[2] - value;
    }

    @Override
    public void scalarMult(double value) {
        this.data[0] = this.data[0] * value;
        this.data[1] = this.data[1] * value;
        this.data[2] = this.data[2] * value;
    }

    @Override
    public void scalarDiv(double value) {
        this.data[0] = this.data[0] / value;
        this.data[1] = this.data[1] / value;
        this.data[2] = this.data[2] / value;
    }

    public void crossProduct(Vector3 other) {
        double x = this.data[1] * other.data[2] - this.data[2] * other.data[1];
        double y = this.data[2] * other.data[0] - this.data[0] * other.data[2];
        this.data[2] = this.data[0] * other.data[1] - this.data[1] * other.data[0];
        this.data[0] = x;
        this.data[1] = y;
    }

    public void crossProduct(Vector3 A, Vector3 B) {
        this.data[0] = A.data[1] * B.data[2] - A.data[2] * B.data[1];
        this.data[1] = A.data[2] * B.data[0] - A.data[0] * B.data[2];
        this.data[2] = A.data[0] * B.data[1] - A.data[1] * B.data[0];
    }

    @Override
    public double normalize() {
        double len = this.length();
        if (len != 0.0) {
            this.data[0] = this.data[0] / len;
            this.data[1] = this.data[1] / len;
            this.data[2] = this.data[2] / len;
        }
        return len;
    }

    public void copy(Vector3 other) {
        this.data[0] = other.data[0];
        this.data[1] = other.data[1];
        this.data[2] = other.data[2];
    }

    public void copy(Point3 point) {
        this.data[0] = point.x;
        this.data[1] = point.y;
        this.data[2] = point.z;
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer("[");
        sb.append(this.data[0]);
        sb.append('|');
        sb.append(this.data[1]);
        sb.append('|');
        sb.append(this.data[2]);
        sb.append(']');
        return sb.toString();
    }
}

