/*
 * Decompiled with CFR 0.152.
 */
package org.miv.mbox;

import java.util.ArrayList;
import org.miv.mbox.MBox;
import org.miv.mbox.MBoxListener;

public abstract class MBoxBase
implements MBox,
MBoxListener {
    protected ArrayList<Message> mtmp = new ArrayList();
    protected ArrayList<Message> messages = new ArrayList();

    public synchronized boolean isMBoxEmpty() {
        return this.messages.size() <= 0;
    }

    public synchronized int getMessageCount() {
        return this.messages.size();
    }

    @Override
    public synchronized void post(String from, Object ... data) {
        this.messages.add(new Message(from, data));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processMessages() {
        MBoxBase mBoxBase = this;
        synchronized (mBoxBase) {
            ArrayList<Message> tmp = this.messages;
            this.messages = this.mtmp;
            this.mtmp = tmp;
        }
        int n = this.mtmp.size();
        for (int i = 0; i < n; ++i) {
            Message msg = this.mtmp.get(i);
            this.processMessage(msg.from, msg.data);
        }
        if (n > 0) {
            this.mtmp.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<Message> popPendingMessages() {
        ArrayList<Message> m = new ArrayList<Message>();
        MBoxBase mBoxBase = this;
        synchronized (mBoxBase) {
            int n = this.messages.size();
            if (n > 0) {
                m.ensureCapacity(n);
                m.addAll(this.messages);
                this.messages.clear();
            }
        }
        return m;
    }

    @Override
    public abstract void processMessage(String var1, Object[] var2);

    public static class Message {
        public String from;
        public Object[] data;

        protected Message(String from, Object[] data) {
            this.from = from;
            this.data = data;
        }

        public String getFrom() {
            return this.from;
        }

        public Object[] getData() {
            return this.data;
        }
    }
}

