/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.installer.utils.system;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import java.util.regex.Pattern;
import org.netbeans.installer.utils.ErrorManager;
import org.netbeans.installer.utils.FileUtils;
import org.netbeans.installer.utils.LogManager;
import org.netbeans.installer.utils.ResourceUtils;
import org.netbeans.installer.utils.StringUtils;
import org.netbeans.installer.utils.SystemUtils;
import org.netbeans.installer.utils.exceptions.NativeException;
import org.netbeans.installer.utils.helper.ApplicationDescriptor;
import org.netbeans.installer.utils.helper.EnvironmentScope;
import org.netbeans.installer.utils.helper.FilesList;
import org.netbeans.installer.utils.helper.Platform;
import org.netbeans.installer.utils.progress.Progress;
import org.netbeans.installer.utils.system.NativeUtils;
import org.netbeans.installer.utils.system.cleaner.OnExitCleanerHandler;
import org.netbeans.installer.utils.system.cleaner.ProcessOnExitCleanerHandler;
import org.netbeans.installer.utils.system.launchers.Launcher;
import org.netbeans.installer.utils.system.shortcut.FileShortcut;
import org.netbeans.installer.utils.system.shortcut.InternetShortcut;
import org.netbeans.installer.utils.system.shortcut.LocationType;
import org.netbeans.installer.utils.system.shortcut.Shortcut;
import org.netbeans.installer.utils.system.windows.FileExtension;
import org.netbeans.installer.utils.system.windows.SystemApplication;
import org.netbeans.installer.utils.system.windows.WindowsRegistry;

public class WindowsNativeUtils
extends NativeUtils {
    public static final String LIBRARY_PATH_X86 = "native/jnilib/windows/windows-x86.dll";
    public static final String LIBRARY_PATH_X64 = "native/jnilib/windows/windows-x64.dll";
    public static final String LIBRARY_PATH_IA64 = "native/jnilib/windows/windows-ia64.dll";
    private static final String CLEANER_RESOURCE = "native/cleaner/windows/cleaner.exe";
    private static final String CLEANER_FILENAME = "nbi-cleaner.exe";
    public static final String UNINSTALL_KEY = "SOFTWARE\\Microsoft\\Windows\\CurrentVersion\\Uninstall";
    public static final String DISPLAY_NAME = "DisplayName";
    public static final String DISPLAY_ICON = "DisplayIcon";
    public static final String UNINSTALL_STRING = "UninstallString";
    public static final String MODIFY_STRING = "ModifyPath";
    public static final String NO_MODIFY = "NoModify";
    public static final String NO_REPAIR = "NoRepair";
    public static final String INSTALL_LOCATION = "InstallLocation";
    private static final String NBI_UID_PREFIX = "nbi-";
    private static final String UID_SEPARATOR = "-";
    private static final int MIN_UID_INDEX = 1;
    private static final int MAX_UID_INDEX = 100;
    private static final String SHELL_FOLDERS_KEY = "Software\\Microsoft\\Windows\\CurrentVersion\\Explorer\\Shell Folders";
    public static final String CURRENT_USER_ENVIRONMENT_KEY = "Environment";
    public static final String ALL_USERS_ENVIRONMENT_KEY = "SYSTEM\\CurrentControlSet\\Control\\Session Manager\\Environment";
    private static final String RUNONCE_KEY = "Software\\Microsoft\\Windows\\CurrentVersion\\RunOnce";
    private static final String RUNONCE_DELETE_VALUE_NAME = "NBI Temporary Files Delete";
    private static final String EXT_PREFIX = "NBI.";
    private static final String EXT_SUFFIX = "";
    private static final String SEP = "\\";
    private static final String PERCEIVED_TYPE_VALUE_NAME = "PerceivedType";
    private static final String CONTENT_TYPE_VALUE_NAME = "Content Type";
    private static final String DEFAULT_ICON_KEY_NAME = "DefaultIcon";
    private static final String SHELL_OPEN_COMMAND = "\\shell\\open\\command";
    private static final String CONTENT_TYPE_KEY = "MIME\\Database\\Content Type";
    private static final String APPLICATIONS_KEY_NAME = "Applications";
    private static final String FRIENDLYAPPNAME_VALUE_NAME = "FriendlyAppName";
    private static final String APPLICATION_VALUE_NAME = "Application";
    private static final String OPEN_WITH_LIST_KEY_NAME = "OpenWithList";
    private static final String EXTENSION_VALUE_NAME = "Extension";
    public static final String DEFAULT_OPEN_COMMAND = "\"%1\"";
    private static final String CURRENT_USER_FILE_EXT_KEY = "Software\\Microsoft\\Windows\\CurrentVersion\\Explorer\\FileExts";
    private static final String CURRENT_USER_MUI_CACHE_KEY = "Software\\Microsoft\\Windows\\ShellNoRoam\\MUICache";
    private static final String OPEN_WITH_PROGIDS_KEY_NAME = "OpenWithProgids";
    private static final String MRULIST_VALUE_NAME = "MRUList";
    private static final String MRU_VALUES = "abcdefghijklmnopqrstuvwxyz";
    private static final String CREATED = "created";
    private static final String EXT_PERCEIVEDTYPE_PROPERTY = "perceivedType";
    private static final String EXT_CONTENTTYPE_PROPERTY = "contentType";
    private static final String EXT_LONGEXT_PROPERTY = "longExt";
    private static final String EXT_DESCRIPTION_PROPERTY = "description";
    private static final String EXT_ICON_PROPERTY = "defaultIcon";
    private static final String EXT_HKCRSHELL_OPEN_COMMAND_PROPERTY = "hkcrShellOpenCommand";
    private static final String EXT_HKCU_DEFAULTAPP_PROPERTY = "hkcuDefaultApp";
    private static final String EXT_HKCU_FILEXT_PROPERTY = "hkcuFileExt";
    private static final String EXT_HKCR_APPLICATIONS_PROPERTY = "hkcrApplications";
    private static final String EXT_HKCR_OPENWITHPROGIDS_PROPERTY = "hkcrOpenWithProgids";
    private static final String EXT_HKCR_OPENWITHLIST_PROPERTY = "hkcrOpenWithList";
    private static final String EXT_HKCU_MUICACHE_PROPERTY = "hkcuMuiCache";
    private static final String EXT_HKCU_OPENWITHPROGIDS_PROPERTY = "hkcuOpenWithProgids";
    private static final String EXT_HKCU_OPENWITHLIST_PROPERTY = "hkcuOpenWithList";
    private static final String CURRENT_USER_CLASSES = "Software\\Classes\\";
    private int clSection;
    private String clKey;
    private int uninstallSection;
    private boolean isUserAdminSet;
    private boolean isUserAdmin;
    private String browserCommand;
    private static final int FILE_READ_DATA = 0;
    private static final int FILE_LIST_DIRECTORY = 0;
    private static final int FILE_WRITE_DATA = 1;
    private static final int FILE_ADD_FILE = 1;
    private static final int FILE_APPEND_DATA = 4;
    private static final int FILE_ADD_SUBDIRECTORY = 4;
    private static final int FILE_READ_EA = 8;
    private static final int FILE_WRITE_EA = 16;
    private static final int FILE_EXECUTE = 32;
    private static final int FILE_TRAVERSE = 32;
    private static final int FILE_DELETE_CHILD = 64;
    private static final int FILE_READ_ATTRIBUTES = 128;
    private static final int FILE_WRITE_ATTRIBUTES = 256;
    private static final int FILE_DELETE = 65536;
    private static final WindowsRegistry registry = new WindowsRegistry();
    private static final String[] FORBIDDEN_DELETING_FILES_WINDOWS = new String[]{System.getenv("ProgramFiles"), System.getenv("SystemRoot"), System.getenv("USERPROFILE"), System.getenv("SystemDrive") + File.separator};
    private File defaultApplicationsLocation;

    WindowsNativeUtils() {
        String libraryPath = SystemUtils.isCurrentJava64Bit() ? (System.getProperty("os.arch").equals("ia64") ? LIBRARY_PATH_IA64 : LIBRARY_PATH_X64) : LIBRARY_PATH_X86;
        try {
            this.loadNativeLibrary(libraryPath);
        }
        catch (NativeException e) {
            ErrorManager.notifyCritical("Cannot load native library which is strictly necessary to work correctly.", e);
        }
        if (nativeLibraryLoaded) {
            this.initializeForbiddenFiles(new String[0]);
            this.initializeRegistryKeys();
        }
    }

    @Override
    protected Platform getPlatform() {
        return SystemUtils.isCurrentJava64Bit() ? (System.getProperty("os.arch").equals("ia64") ? Platform.WINDOWS_IA64 : Platform.WINDOWS_X64) : Platform.WINDOWS_X86;
    }

    private void initializeRegistryKeys() {
        boolean result = false;
        try {
            result = this.isCurrentUserAdmin();
        }
        catch (NativeException ex) {
            LogManager.log(ex);
        }
        try {
            this.clSection = registry.canModifyKey(0, EXT_SUFFIX) ? 0 : 1;
            this.clKey = result ? EXT_SUFFIX : CURRENT_USER_CLASSES;
            this.uninstallSection = registry.canModifyKey(2, UNINSTALL_KEY) ? 2 : 1;
        }
        catch (NativeException ex) {
            LogManager.log(ex);
            this.clSection = 1;
            this.clKey = CURRENT_USER_CLASSES;
            this.uninstallSection = 1;
        }
    }

    @Override
    public boolean isSystem64Bit() {
        String arch = System.getenv("PROCESSOR_ARCHITECTURE");
        String wow64Arch = System.getenv("PROCESSOR_ARCHITEW6432");
        return arch.endsWith("64") || wow64Arch != null && wow64Arch.endsWith("64");
    }

    @Override
    public boolean isCurrentUserAdmin() throws NativeException {
        boolean result;
        if (this.isUserAdminSet) {
            return this.isUserAdmin;
        }
        this.isUserAdmin = result = this.isCurrentUserAdmin0();
        this.isUserAdminSet = true;
        return result;
    }

    @Override
    protected OnExitCleanerHandler newDeleteOnExitCleanerHandler() {
        return new WindowsProcessOnExitCleanerHandler(CLEANER_FILENAME);
    }

    @Override
    public File getDefaultApplicationsLocation() throws NativeException {
        if (this.defaultApplicationsLocation == null) {
            this.defaultApplicationsLocation = SystemUtils.getUserHomeDirectory();
            String path = SystemUtils.getEnvironmentVariable("ProgramFiles");
            if (path != null) {
                this.defaultApplicationsLocation = new File(path).getAbsoluteFile();
            } else {
                ErrorManager.notify(4, "Value of the environment variable ProgramFiles is not set");
            }
        }
        return this.defaultApplicationsLocation;
    }

    @Override
    public long getFreeSpace(File file) throws NativeException {
        if (file == null || !this.isPathValid(file.getPath())) {
            return 0L;
        }
        return this.getFreeSpace0(file.getPath());
    }

    @Override
    public boolean isUNCPath(String path) {
        return path.matches("^\\\\\\\\.+(\\\\|/).+");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public File getRoot(File file) {
        if (this.isUNCPath(file.getPath())) {
            File parent = file;
            File previous = null;
            try {
                while (parent.getParentFile() != null) {
                    File can = parent.getCanonicalFile();
                    previous = parent;
                    parent = parent.getParentFile();
                }
            }
            catch (IOException iOException) {}
            finally {
                return previous;
            }
        }
        return super.getRoot(file);
    }

    @Override
    public boolean isPathValid(String path) {
        if (path.length() > 256) {
            return false;
        }
        if (!path.matches("^[A-Z,a-z]:\\\\.*") && !this.isUNCPath(path)) {
            return false;
        }
        String[] parts = path.split("\\\\");
        for (int i = 1; i < parts.length; ++i) {
            if (Pattern.compile("[\\/:*\\?\"<>|]").matcher(parts[i]).find()) {
                return false;
            }
            if (!parts[i].startsWith(" ") && !parts[i].startsWith("\t") && !parts[i].endsWith(" ") && !parts[i].endsWith("\t")) continue;
            return false;
        }
        return true;
    }

    @Override
    public File getShortcutLocation(Shortcut shortcut, LocationType locationType) throws NativeException {
        if (shortcut.getPath() != null) {
            return new File(shortcut.getPath());
        }
        String path = shortcut.getRelativePath();
        if (path == null) {
            path = EXT_SUFFIX;
        }
        String fileName = shortcut.getName();
        if (shortcut instanceof FileShortcut) {
            fileName = fileName + ".lnk";
        } else if (shortcut instanceof InternetShortcut) {
            fileName = fileName + ".url";
        }
        String allUsersRootPath = SystemUtils.getEnvironmentVariable("allusersprofile");
        File shortcutFile = null;
        switch (locationType) {
            case CURRENT_USER_DESKTOP: {
                String userDesktop = registry.getStringValue(1, SHELL_FOLDERS_KEY, "Desktop", false);
                if (userDesktop == null) {
                    userDesktop = SystemUtils.getUserHomeDirectory() + File.separator + "Desktop";
                }
                shortcutFile = new File(userDesktop, fileName);
                break;
            }
            case ALL_USERS_DESKTOP: {
                String commonDesktop = registry.getStringValue(2, SHELL_FOLDERS_KEY, "Common Desktop", false);
                if (commonDesktop == null) {
                    commonDesktop = allUsersRootPath + File.separator + "Desktop";
                }
                shortcutFile = new File(commonDesktop, fileName);
                break;
            }
            case CURRENT_USER_START_MENU: {
                String userStartMenu = registry.getStringValue(1, SHELL_FOLDERS_KEY, "Programs", false);
                if (userStartMenu == null) {
                    userStartMenu = SystemUtils.getUserHomeDirectory() + File.separator + "Start Menu" + File.separator + "Programs";
                }
                shortcutFile = new File(userStartMenu, path + File.separator + fileName);
                break;
            }
            case ALL_USERS_START_MENU: {
                String commonStartMenu = registry.getStringValue(2, SHELL_FOLDERS_KEY, "Common Programs", false);
                if (commonStartMenu == null) {
                    commonStartMenu = SystemUtils.getUserHomeDirectory() + File.separator + "Start Menu" + File.separator + "Programs";
                }
                shortcutFile = new File(commonStartMenu, path + File.separator + fileName);
                break;
            }
            case CUSTOM: {
                shortcutFile = new File(path + File.separator + fileName);
            }
        }
        if (shortcutFile != null) {
            shortcut.setPath(shortcutFile.getAbsolutePath());
        }
        return shortcutFile;
    }

    protected void createURLShortcut(InternetShortcut shortcut) throws NativeException {
        try {
            LinkedList<String> lines = new LinkedList<String>();
            lines.add("[InternetShortcut]");
            lines.add("URL=" + shortcut.getURL());
            lines.add("IconFile=" + shortcut.getIconPath());
            lines.add("IconIndex=" + shortcut.getIconIndex());
            lines.add("HotKey=0");
            lines.add("IDList=");
            lines.add(SystemUtils.getLineSeparator());
            FileUtils.writeStringList(new File(shortcut.getPath()), lines);
        }
        catch (IOException ex) {
            throw new NativeException("Can`t create URL shortcut", ex);
        }
    }

    @Override
    public File createShortcut(Shortcut shortcut, LocationType locationType) throws NativeException {
        File shortcutFile = this.getShortcutLocation(shortcut, locationType);
        if (shortcut instanceof FileShortcut) {
            this.createShortcut0((FileShortcut)shortcut);
        } else if (shortcut instanceof InternetShortcut) {
            this.createURLShortcut((InternetShortcut)shortcut);
        }
        return shortcutFile;
    }

    @Override
    public void removeShortcut(Shortcut shortcut, LocationType locationType, boolean cleanupParents) throws NativeException {
        File shortcutFile = this.getShortcutLocation(shortcut, locationType);
        try {
            FileUtils.deleteFile(shortcutFile);
            if (cleanupParents) {
                switch (locationType) {
                    case CURRENT_USER_START_MENU: 
                    case ALL_USERS_START_MENU: 
                    case CUSTOM: {
                        FileUtils.deleteEmptyParents(shortcutFile);
                        break;
                    }
                }
            }
        }
        catch (IOException e) {
            LogManager.log("Can`t remove shortcut", (Throwable)e);
        }
    }

    @Override
    public FilesList addComponentToSystemInstallManager(ApplicationDescriptor descriptor) throws NativeException {
        String command;
        FilesList list = new FilesList();
        Launcher modifyLauncher = null;
        Launcher uninstallLauncher = null;
        try {
            if (descriptor.getModifyCommand() != null) {
                modifyLauncher = this.createUninstaller(descriptor, false, new Progress());
                list.add(modifyLauncher.getOutputFile());
            }
            if (descriptor.getUninstallCommand() != null) {
                uninstallLauncher = this.createUninstaller(descriptor, true, new Progress());
                list.add(uninstallLauncher.getOutputFile());
            }
        }
        catch (IOException e) {
            throw new NativeException("Can`t create uninstaller", e);
        }
        LogManager.log("adding new Add or Remove Programs entry with id [" + descriptor.getUid() + "]");
        String uid = this.getVacantUninstallUid(descriptor.getUid());
        String key = "SOFTWARE\\Microsoft\\Windows\\CurrentVersion\\Uninstall\\" + uid;
        registry.createKey(this.uninstallSection, key);
        if (descriptor.getDisplayName() != null) {
            LogManager.log("Set 'DisplayName' = [" + descriptor.getDisplayName() + "]");
            registry.setStringValue(this.uninstallSection, key, DISPLAY_NAME, descriptor.getDisplayName(), false);
        }
        if (descriptor.getIcon() != null) {
            LogManager.log("Set 'DisplayIcon' = [" + descriptor.getIcon() + "]");
            registry.setStringValue(this.uninstallSection, key, DISPLAY_ICON, descriptor.getIcon(), false);
        }
        if (descriptor.getInstallPath() != null) {
            LogManager.log("Set 'InstallLocation' = [" + descriptor.getInstallPath() + "]");
            registry.setStringValue(this.uninstallSection, key, INSTALL_LOCATION, descriptor.getInstallPath(), false);
        }
        if (descriptor.getModifyCommand() != null) {
            LogManager.log("Set 'NoRepair' = [1]");
            registry.set32BitValue(this.uninstallSection, key, NO_REPAIR, 1);
            command = "\"" + StringUtils.asString(modifyLauncher.getExecutionCommand(), "\" \"") + "\"";
            LogManager.log("Set 'ModifyPath' = [" + command + "]");
            registry.setStringValue(this.uninstallSection, key, MODIFY_STRING, command, false);
        } else {
            LogManager.log("Set 'NoModify' = [1]");
            registry.set32BitValue(this.uninstallSection, key, NO_MODIFY, 1);
        }
        if (descriptor.getUninstallCommand() != null) {
            command = "\"" + StringUtils.asString(uninstallLauncher.getExecutionCommand(), "\" \"") + "\"";
            LogManager.log("Set 'UninstallString' = [" + command + "]");
            registry.setStringValue(this.uninstallSection, key, UNINSTALL_STRING, command, false);
        }
        registry.setAdditionalValues(this.uninstallSection, key, descriptor.getParameters());
        return list;
    }

    @Override
    public void removeComponentFromSystemInstallManager(ApplicationDescriptor descriptor) throws NativeException {
        String properUid = this.getProperUninstallUid(descriptor.getUid(), descriptor.getInstallPath());
        if (properUid != null) {
            registry.deleteKey(this.uninstallSection, UNINSTALL_KEY, properUid);
        }
    }

    @Override
    public String getEnvironmentVariable(String name, EnvironmentScope scope, boolean expand) throws NativeException {
        String value = null;
        if (scope != null && name != null) {
            if (scope == EnvironmentScope.PROCESS) {
                value = System.getenv(name);
            } else {
                String rootKey = null;
                int section = 0;
                if (scope == EnvironmentScope.CURRENT_USER) {
                    rootKey = CURRENT_USER_ENVIRONMENT_KEY;
                    section = 1;
                }
                if (scope == EnvironmentScope.ALL_USERS) {
                    rootKey = ALL_USERS_ENVIRONMENT_KEY;
                    section = 2;
                }
                if (registry.keyExists(section, rootKey)) {
                    if (registry.valueExists(section, rootKey, name)) {
                        value = registry.getStringValue(section, rootKey, name, expand);
                    } else {
                        LogManager.log(4, "Environment variable " + name + " doesn`t exist.");
                    }
                } else {
                    LogManager.log(4, "Root environment key doesn`t exist. Can`t get environment variable");
                }
            }
        }
        return value;
    }

    @Override
    public void setEnvironmentVariable(String name, String value, EnvironmentScope scope, boolean expand) throws NativeException {
        if (name != null && scope != null) {
            if (scope == EnvironmentScope.PROCESS) {
                SystemUtils.getEnvironment().put(name, value);
            } else {
                String rootKey = null;
                int section = 0;
                if (scope == EnvironmentScope.CURRENT_USER) {
                    rootKey = CURRENT_USER_ENVIRONMENT_KEY;
                    section = 1;
                }
                if (scope == EnvironmentScope.ALL_USERS) {
                    rootKey = ALL_USERS_ENVIRONMENT_KEY;
                    section = 2;
                }
                if (registry.keyExists(section, rootKey)) {
                    if (value != null) {
                        registry.setStringValue(section, rootKey, name, value, expand);
                    } else if (registry.valueExists(section, rootKey, name)) {
                        registry.deleteValue(section, rootKey, name);
                    } else {
                        LogManager.log(3, "Environment variable " + name + " is not set");
                    }
                    this.notifyEnvironmentChanged0();
                } else {
                    LogManager.log(2, "Root envonment key doesn`t exist. Can`t set environment variable");
                }
            }
        }
    }

    @Override
    public List<File> findIrrelevantFiles(File parent) throws IOException {
        LinkedList<File> files;
        block4: {
            files = new LinkedList<File>();
            if (!parent.exists()) break block4;
            if (parent.isDirectory()) {
                for (File child : parent.listFiles()) {
                    files.addAll(this.findIrrelevantFiles(child));
                }
            } else {
                String[] unixExtensions;
                File child = parent;
                String name = child.getName();
                for (String ext : unixExtensions = new String[]{".sh", ".so", ".dylib"}) {
                    if (!name.endsWith(ext)) continue;
                    files.add(child);
                    break;
                }
            }
        }
        return files;
    }

    @Override
    public List<File> findExecutableFiles(File parent) throws IOException {
        LinkedList<File> files;
        block4: {
            files = new LinkedList<File>();
            if (!parent.exists()) break block4;
            if (parent.isDirectory()) {
                File[] children;
                for (File child : children = parent.listFiles()) {
                    files.addAll(this.findIrrelevantFiles(child));
                }
            } else {
                String[] windowsExecutableExtensions;
                File child = parent;
                String name = child.getName();
                for (String ext : windowsExecutableExtensions = new String[]{".exe", ".com", ".bat", ".cmd", ".vbs", ".vbe", ".js", ".jse", ".wsf", ".wsh"}) {
                    if (!name.endsWith(ext)) continue;
                    files.add(child);
                    break;
                }
            }
        }
        return files;
    }

    @Override
    public void correctFilesPermissions(File parent) {
    }

    @Override
    public void setPermissions(File file, int mode, int change) throws IOException {
    }

    @Override
    public int getPermissions(File file) throws IOException {
        return 0;
    }

    @Override
    public List<File> getFileSystemRoots(String ... files) throws IOException {
        return Arrays.asList(File.listRoots());
    }

    public WindowsRegistry getWindowsRegistry() {
        return registry;
    }

    public void deleteFileOnReboot(File file) throws NativeException {
        String path = file.getAbsolutePath();
        if (this.isCurrentUserAdmin()) {
            this.deleteFileOnReboot0(path);
        } else {
            if (!registry.keyExists(1, RUNONCE_KEY)) {
                registry.createKey(1, RUNONCE_KEY);
            }
            String name = RUNONCE_DELETE_VALUE_NAME;
            int i = 0;
            while (registry.valueExists(1, RUNONCE_KEY, name)) {
                name = "NBI Temporary Files Delete-" + i;
                ++i;
            }
            String command = "cmd /q /c del /F /Q \"" + path + "\"";
            registry.setStringValue(1, RUNONCE_KEY, name, command);
        }
    }

    private String getVacantUninstallUid(String baseUid) throws NativeException {
        String vacantUid = baseUid;
        String key = "SOFTWARE\\Microsoft\\Windows\\CurrentVersion\\Uninstall\\" + vacantUid;
        if (registry.keyExists(this.uninstallSection, key)) {
            for (int index = 1; index < 100; ++index) {
                vacantUid = baseUid + UID_SEPARATOR + index;
                key = "SOFTWARE\\Microsoft\\Windows\\CurrentVersion\\Uninstall\\" + vacantUid;
                if (registry.keyExists(this.uninstallSection, key)) continue;
                return vacantUid;
            }
            return null;
        }
        return vacantUid;
    }

    private String getProperUninstallUid(String baseUid, String installLocation) throws NativeException {
        String properUid = baseUid;
        String key = "SOFTWARE\\Microsoft\\Windows\\CurrentVersion\\Uninstall\\" + properUid;
        if (registry.keyExists(this.uninstallSection, key) && registry.getStringValue(this.uninstallSection, key, INSTALL_LOCATION).equals(installLocation)) {
            return properUid;
        }
        for (int index = 1; index < 100; ++index) {
            properUid = baseUid + UID_SEPARATOR + index;
            key = "SOFTWARE\\Microsoft\\Windows\\CurrentVersion\\Uninstall\\" + properUid;
            if (!registry.keyExists(this.uninstallSection, key) || !registry.getStringValue(this.uninstallSection, key, INSTALL_LOCATION).equals(installLocation)) continue;
            return properUid;
        }
        return null;
    }

    @Override
    public boolean checkFileAccess(File file, boolean isReadNotModify) throws NativeException {
        int result = 0;
        try {
            int accessLevel = 0;
            accessLevel = isReadNotModify ? 0 : 5;
            result = this.checkAccessTokenAccessLevel0(file.getPath(), accessLevel);
        }
        catch (UnsatisfiedLinkError e) {
            throw new NativeException("Cannot access native method", e);
        }
        return result == 1;
    }

    public synchronized void setFileAssociation(FileExtension ext, SystemApplication app, Properties props) throws NativeException {
        if (ext == null && this.isEmpty(ext.getName())) {
            return;
        }
        this.notifyAssociationChanged();
        FileExtensionKey feExt = new FileExtensionKey(ext, this.getLongExtensionName(ext));
        this.setExtensionDetails(feExt, props);
        if (app != null && !this.isEmpty(app.getLocation())) {
            SystemApplicationKey appExt = new SystemApplicationKey(app, this.getApplicationKey(app));
            this.registerApplication(appExt, feExt, props);
            this.changeDefaultApplication(appExt, feExt, props);
            this.addToOpenWithList(appExt, feExt, props);
        }
        this.notifyAssociationChanged();
    }

    public synchronized void removeFileAssociation(FileExtension ext, SystemApplication app, Properties props) throws NativeException {
        if (ext == null && this.isEmpty(ext.getName())) {
            return;
        }
        this.notifyAssociationChanged();
        String prefix = EXTENSION_VALUE_NAME + ext.getDotName();
        if (props.getProperty(prefix) != null && registry.valueExists(this.clSection, this.clKey + ext.getDotName(), EXT_SUFFIX)) {
            String extKey = registry.getStringValue(this.clSection, this.clKey + ext.getDotName(), EXT_SUFFIX);
            FileExtensionKey feExt = new FileExtensionKey(ext, extKey);
            String appKey = this.getApplicationKey(app);
            SystemApplicationKey sap = new SystemApplicationKey(app, appKey);
            this.removeFromOpenWithList(sap, feExt, props);
            this.rollbackDefaultApplication(sap, feExt, props);
            this.unregisterApplication(sap, feExt, props);
            this.clearExtensionDetails(sap, feExt, props);
        }
        this.notifyAssociationChanged();
    }

    private void setExtensionDetails(FileExtensionKey ext, Properties props) throws NativeException {
        String name = ext.getDotName();
        String extKey = ext.getKey();
        if (!registry.keyExists(this.clSection, this.clKey + name)) {
            registry.createKey(this.clSection, this.clKey + name);
            this.setExtProperty(props, name, CREATED);
        }
        if (ext.getPerceivedType() != null && !registry.valueExists(this.clSection, this.clKey + name, PERCEIVED_TYPE_VALUE_NAME)) {
            registry.setStringValue(this.clSection, this.clKey + name, PERCEIVED_TYPE_VALUE_NAME, ext.getPerceivedType().toString());
            this.setExtProperty(props, name, EXT_PERCEIVEDTYPE_PROPERTY, CREATED);
        }
        if (!this.isEmpty(ext.getMimeType())) {
            registry.setStringValue(this.clSection, this.clKey + name, CONTENT_TYPE_VALUE_NAME, ext.getMimeType());
            if (!registry.keyExists(this.clSection, this.clKey + CONTENT_TYPE_KEY, ext.getMimeType())) {
                registry.createKey(this.clSection, this.clKey + CONTENT_TYPE_KEY, ext.getMimeType());
                registry.setStringValue(this.clSection, this.clKey + CONTENT_TYPE_KEY + SEP + ext.getMimeType(), EXTENSION_VALUE_NAME, name);
                this.setExtProperty(props, name, EXT_CONTENTTYPE_PROPERTY, CREATED);
            }
        }
        registry.setStringValue(this.clSection, this.clKey + name, EXT_SUFFIX, extKey);
        if (!registry.keyExists(this.clSection, this.clKey + extKey)) {
            registry.createKey(this.clSection, this.clKey + extKey);
            this.setExtProperty(props, name, EXT_LONGEXT_PROPERTY, CREATED);
        }
        if (!this.isEmpty(ext.getDescription())) {
            if (registry.valueExists(this.clSection, this.clKey + extKey, EXT_SUFFIX)) {
                this.setExtProperty(props, name, EXT_DESCRIPTION_PROPERTY, registry.getStringValue(this.clSection, this.clKey + extKey, EXT_SUFFIX));
            }
            registry.setStringValue(this.clSection, this.clKey + extKey, EXT_SUFFIX, ext.getDescription());
        }
        if (!this.isEmpty(ext.getIcon()) && !registry.keyExists(this.clSection, this.clKey + extKey, DEFAULT_ICON_KEY_NAME)) {
            registry.createKey(this.clSection, this.clKey + extKey, DEFAULT_ICON_KEY_NAME);
            registry.setStringValue(this.clSection, this.clKey + extKey + SEP + DEFAULT_ICON_KEY_NAME, EXT_SUFFIX, ext.getIcon());
            this.setExtProperty(props, name, EXT_ICON_PROPERTY, CREATED);
        }
        if (!registry.keyExists(1, CURRENT_USER_FILE_EXT_KEY, name)) {
            registry.createKey(1, CURRENT_USER_FILE_EXT_KEY, name);
            this.setExtProperty(props, name, EXT_HKCU_FILEXT_PROPERTY, CREATED);
        }
    }

    private void clearExtensionDetails(SystemApplicationKey app, FileExtensionKey fe, Properties props) throws NativeException {
        String name = fe.getDotName();
        String extKey = fe.getKey();
        String property = this.getExtProperty(props, name, EXT_HKCU_FILEXT_PROPERTY);
        if (property != null && registry.keyExists(1, "Software\\Microsoft\\Windows\\CurrentVersion\\Explorer\\FileExts\\" + name)) {
            if (registry.keyExists(1, "Software\\Microsoft\\Windows\\CurrentVersion\\Explorer\\FileExts\\" + name, OPEN_WITH_LIST_KEY_NAME)) {
                registry.deleteKey(1, "Software\\Microsoft\\Windows\\CurrentVersion\\Explorer\\FileExts\\" + name, OPEN_WITH_LIST_KEY_NAME);
            }
            if (registry.keyExists(1, "Software\\Microsoft\\Windows\\CurrentVersion\\Explorer\\FileExts\\" + name, OPEN_WITH_PROGIDS_KEY_NAME)) {
                registry.deleteKey(1, "Software\\Microsoft\\Windows\\CurrentVersion\\Explorer\\FileExts\\" + name, OPEN_WITH_PROGIDS_KEY_NAME);
            }
            if (registry.getSubKeys(1, "Software\\Microsoft\\Windows\\CurrentVersion\\Explorer\\FileExts\\" + name).length == 0) {
                registry.deleteKey(1, CURRENT_USER_FILE_EXT_KEY, name);
            }
        }
        if ((property = this.getExtProperty(props, name, EXT_DESCRIPTION_PROPERTY)) != null) {
            registry.setStringValue(this.clSection, this.clKey + extKey, EXT_SUFFIX, property);
        }
        if ((property = this.getExtProperty(props, name, EXT_ICON_PROPERTY)) != null && registry.keyExists(this.clSection, this.clKey + extKey + SEP + DEFAULT_ICON_KEY_NAME)) {
            registry.deleteKey(this.clSection, this.clKey + extKey + SEP + DEFAULT_ICON_KEY_NAME);
        }
        if ((property = this.getExtProperty(props, name, EXT_LONGEXT_PROPERTY)) != null && registry.getSubKeys(this.clSection, this.clKey + extKey).length == 0) {
            registry.deleteKey(this.clSection, this.clKey + extKey);
        }
        if ((property = this.getExtProperty(props, name, EXT_CONTENTTYPE_PROPERTY)) != null && registry.getSubKeys(this.clSection, this.clKey + CONTENT_TYPE_KEY + SEP + fe.getMimeType()).length == 0) {
            registry.deleteKey(this.clSection, this.clKey + CONTENT_TYPE_KEY, fe.getMimeType());
        }
        if ((property = this.getExtProperty(props, name, EXT_PERCEIVEDTYPE_PROPERTY)) != null) {
            registry.deleteValue(this.clSection, this.clKey + name, PERCEIVED_TYPE_VALUE_NAME);
        }
        if ((property = this.getExtProperty(props, name)) != null && registry.keyExists(this.clSection, this.clKey + name) && registry.getSubKeys(this.clSection, this.clKey + name).length == 0) {
            registry.deleteKey(this.clSection, this.clKey + name);
        }
    }

    private void changeDefaultApplication(SystemApplicationKey app, FileExtensionKey fe, Properties props) throws NativeException {
        if (app.isUseByDefault() == null || app.isUseByDefault().booleanValue()) {
            String name = fe.getDotName();
            String extKey = fe.getKey();
            String appKey = app.getKey();
            if (!registry.keyExists(this.clSection, this.clKey + extKey + SHELL_OPEN_COMMAND)) {
                registry.createKey(this.clSection, this.clKey + extKey + SHELL_OPEN_COMMAND);
                registry.setStringValue(this.clSection, this.clKey + extKey + SHELL_OPEN_COMMAND, EXT_SUFFIX, this.constructCommand(app));
                this.setExtProperty(props, name, EXT_HKCRSHELL_OPEN_COMMAND_PROPERTY, CREATED);
            }
            String s = null;
            if (registry.valueExists(1, "Software\\Microsoft\\Windows\\CurrentVersion\\Explorer\\FileExts\\" + name, APPLICATION_VALUE_NAME)) {
                s = registry.getStringValue(1, "Software\\Microsoft\\Windows\\CurrentVersion\\Explorer\\FileExts\\" + name, APPLICATION_VALUE_NAME);
            }
            if (app.isUseByDefault() != null || s == null) {
                registry.setStringValue(1, "Software\\Microsoft\\Windows\\CurrentVersion\\Explorer\\FileExts\\" + name, APPLICATION_VALUE_NAME, appKey);
                if (s != null) {
                    this.setExtProperty(props, name, EXT_HKCU_DEFAULTAPP_PROPERTY, s);
                }
            }
        }
    }

    private void rollbackDefaultApplication(SystemApplicationKey app, FileExtensionKey fe, Properties props) throws NativeException {
        if (app.isUseByDefault() == null || app.isUseByDefault().booleanValue()) {
            String name = fe.getDotName();
            String extKey = fe.getKey();
            String property = this.getExtProperty(props, name, EXT_HKCRSHELL_OPEN_COMMAND_PROPERTY);
            if (property != null) {
                String s = SHELL_OPEN_COMMAND;
                registry.deleteKey(this.clSection, this.clKey + extKey + s);
                s = s.substring(0, s.lastIndexOf(SEP));
                registry.deleteKey(this.clSection, this.clKey + extKey + s);
                s = s.substring(0, s.lastIndexOf(SEP));
                registry.deleteKey(this.clSection, this.clKey + extKey + s);
            }
            property = this.getExtProperty(props, name, ".hkcuDefaultApp");
            if (registry.keyExists(1, "Software\\Microsoft\\Windows\\CurrentVersion\\Explorer\\FileExts\\" + name)) {
                if (property != null) {
                    registry.setStringValue(1, "Software\\Microsoft\\Windows\\CurrentVersion\\Explorer\\FileExts\\" + name, APPLICATION_VALUE_NAME, property);
                } else if (app.isUseByDefault() != null) {
                    registry.deleteValue(1, "Software\\Microsoft\\Windows\\CurrentVersion\\Explorer\\FileExts\\" + name, APPLICATION_VALUE_NAME);
                }
            }
        }
    }

    private void addToOpenWithList(SystemApplicationKey app, FileExtensionKey ext, Properties props) throws NativeException {
        String name = ext.getDotName();
        String extKey = ext.getKey();
        String appName = app.getKey();
        if (app.isAddOpenWithList() && !this.isEmpty(name) && !this.isEmpty(extKey) && !this.isEmpty(appName)) {
            if (!registry.keyExists(this.clSection, this.clKey + name + SEP + OPEN_WITH_LIST_KEY_NAME, appName)) {
                registry.createKey(this.clSection, this.clKey + name + SEP + OPEN_WITH_LIST_KEY_NAME, appName);
                this.setExtProperty(props, name, EXT_HKCR_OPENWITHLIST_PROPERTY, CREATED);
            }
            this.addCurrentUserOpenWithList(name, extKey, appName, props);
            if (!registry.keyExists(this.clSection, this.clKey + name + SEP + OPEN_WITH_PROGIDS_KEY_NAME)) {
                registry.createKey(this.clSection, this.clKey + name + SEP + OPEN_WITH_PROGIDS_KEY_NAME);
                this.setExtProperty(props, name, EXT_HKCR_OPENWITHPROGIDS_PROPERTY, CREATED);
            }
            registry.setNoneValue(this.clSection, this.clKey + name + SEP + OPEN_WITH_PROGIDS_KEY_NAME, extKey, new byte[0]);
            this.addCurrentUserOpenWithProgids(name, extKey, appName, props);
        }
    }

    private void removeFromOpenWithList(SystemApplicationKey app, FileExtensionKey ext, Properties props) throws NativeException {
        String name = ext.getDotName();
        String extKey = ext.getKey();
        String appName = app.getKey();
        String property = this.getExtProperty(props, name, EXT_HKCR_OPENWITHLIST_PROPERTY);
        if (property != null) {
            if (registry.keyExists(this.clSection, this.clKey + name + SEP + OPEN_WITH_LIST_KEY_NAME, appName)) {
                registry.deleteKey(this.clSection, this.clKey + name + SEP + OPEN_WITH_LIST_KEY_NAME, appName);
            }
            if (registry.keyExists(this.clSection, this.clKey + name + SEP + OPEN_WITH_LIST_KEY_NAME) && registry.getSubKeys(this.clSection, this.clKey + name + SEP + OPEN_WITH_LIST_KEY_NAME).length == 0) {
                registry.deleteKey(this.clSection, this.clKey + name + SEP + OPEN_WITH_LIST_KEY_NAME);
            }
        }
        if ((property = this.getExtProperty(props, name, EXT_HKCR_OPENWITHPROGIDS_PROPERTY)) != null && registry.keyExists(this.clSection, this.clKey + name + SEP + OPEN_WITH_PROGIDS_KEY_NAME)) {
            if (registry.valueExists(this.clSection, this.clKey + name + SEP + OPEN_WITH_PROGIDS_KEY_NAME, extKey)) {
                registry.deleteValue(this.clSection, this.clKey + name + SEP + OPEN_WITH_PROGIDS_KEY_NAME, extKey);
            }
            if (registry.keyEmpty(this.clSection, this.clKey + name + SEP + OPEN_WITH_PROGIDS_KEY_NAME)) {
                registry.deleteKey(this.clSection, this.clKey + name + SEP + OPEN_WITH_PROGIDS_KEY_NAME);
            }
        }
        String cuExtKey = "Software\\Microsoft\\Windows\\CurrentVersion\\Explorer\\FileExts\\" + name;
        property = this.getExtProperty(props, name, EXT_HKCU_OPENWITHPROGIDS_PROPERTY);
        if (property != null && registry.keyExists(1, cuExtKey, OPEN_WITH_PROGIDS_KEY_NAME) && registry.valueExists(1, cuExtKey + SEP + OPEN_WITH_PROGIDS_KEY_NAME, ext.getKey())) {
            registry.deleteValue(1, cuExtKey + SEP + OPEN_WITH_PROGIDS_KEY_NAME, ext.getKey());
        }
        if ((property = this.getExtProperty(props, name, EXT_HKCU_OPENWITHLIST_PROPERTY)) != null && registry.keyExists(1, cuExtKey, OPEN_WITH_LIST_KEY_NAME)) {
            for (int i = 0; i < MRU_VALUES.length(); ++i) {
                String ch = MRU_VALUES.substring(i, i + 1);
                if (!registry.valueExists(1, cuExtKey + SEP + OPEN_WITH_LIST_KEY_NAME, ch) || !registry.getStringValue(1, cuExtKey + SEP + OPEN_WITH_LIST_KEY_NAME, ch).equals(appName)) continue;
                registry.deleteValue(1, cuExtKey + SEP + OPEN_WITH_LIST_KEY_NAME, ch);
                if (!registry.valueExists(1, cuExtKey + SEP + OPEN_WITH_LIST_KEY_NAME, MRULIST_VALUE_NAME)) break;
                String mru = registry.getStringValue(1, cuExtKey + SEP + OPEN_WITH_LIST_KEY_NAME, MRULIST_VALUE_NAME);
                if ((mru = mru.replace(ch, EXT_SUFFIX)).equals(EXT_SUFFIX)) {
                    registry.deleteValue(1, cuExtKey + SEP + OPEN_WITH_LIST_KEY_NAME, MRULIST_VALUE_NAME);
                    break;
                }
                registry.setStringValue(1, cuExtKey + SEP + OPEN_WITH_LIST_KEY_NAME, MRULIST_VALUE_NAME, mru);
                break;
            }
            if (registry.keyEmpty(1, cuExtKey + SEP + OPEN_WITH_LIST_KEY_NAME)) {
                registry.deleteKey(1, cuExtKey, OPEN_WITH_LIST_KEY_NAME);
            }
        }
    }

    private void addCurrentUserOpenWithList(String name, String extKey, String appName, Properties props) throws NativeException {
        boolean found = false;
        String freeValue = MRU_VALUES.substring(0, 1);
        String cuExtKey = "Software\\Microsoft\\Windows\\CurrentVersion\\Explorer\\FileExts\\" + name;
        if (!registry.keyExists(1, cuExtKey, OPEN_WITH_LIST_KEY_NAME)) {
            registry.createKey(1, cuExtKey, OPEN_WITH_LIST_KEY_NAME);
        } else {
            freeValue = null;
            for (int i = 0; i < MRU_VALUES.length(); ++i) {
                String s = MRU_VALUES.substring(i, i + 1);
                if (registry.valueExists(1, cuExtKey + SEP + OPEN_WITH_LIST_KEY_NAME, s)) {
                    String app = registry.getStringValue(1, cuExtKey + SEP + OPEN_WITH_LIST_KEY_NAME, s);
                    if (!app.equals(appName)) continue;
                    found = true;
                    continue;
                }
                if (freeValue != null) continue;
                freeValue = s;
            }
        }
        if (!found) {
            registry.setStringValue(1, cuExtKey + SEP + OPEN_WITH_LIST_KEY_NAME, freeValue, appName);
            this.setExtProperty(props, name, EXT_HKCU_OPENWITHLIST_PROPERTY, CREATED);
            String mru = freeValue;
            if (registry.valueExists(1, cuExtKey + SEP + OPEN_WITH_LIST_KEY_NAME, MRULIST_VALUE_NAME)) {
                mru = mru + registry.getStringValue(1, cuExtKey + SEP + OPEN_WITH_LIST_KEY_NAME, MRULIST_VALUE_NAME);
            }
            registry.setStringValue(1, cuExtKey + SEP + OPEN_WITH_LIST_KEY_NAME, MRULIST_VALUE_NAME, mru);
        }
    }

    private void addCurrentUserOpenWithProgids(String name, String extKey, String appName, Properties props) throws NativeException {
        String cuExtKey = "Software\\Microsoft\\Windows\\CurrentVersion\\Explorer\\FileExts\\" + name;
        if (!registry.keyExists(1, cuExtKey, OPEN_WITH_PROGIDS_KEY_NAME)) {
            registry.createKey(1, cuExtKey, OPEN_WITH_PROGIDS_KEY_NAME);
        } else {
            String[] values;
            for (String value : values = registry.getValueNames(1, cuExtKey + SEP + OPEN_WITH_PROGIDS_KEY_NAME)) {
                if (!value.equals(appName)) continue;
                return;
            }
        }
        registry.setNoneValue(1, cuExtKey + SEP + OPEN_WITH_PROGIDS_KEY_NAME, extKey, new byte[0]);
        this.setExtProperty(props, name, EXT_HKCU_OPENWITHPROGIDS_PROPERTY, CREATED);
    }

    private void registerApplication(SystemApplicationKey app, FileExtensionKey key, Properties props) throws NativeException {
        String appLocation = app.getLocation();
        String appKey = app.getKey();
        String appFriendlyName = app.getFriendlyName();
        String name = key.getDotName();
        if (!registry.keyExists(this.clSection, this.clKey + APPLICATIONS_KEY_NAME, appKey)) {
            registry.createKey(this.clSection, this.clKey + APPLICATIONS_KEY_NAME, appKey);
            this.setExtProperty(props, name, EXT_HKCR_APPLICATIONS_PROPERTY, CREATED);
            if (!this.isEmpty(appFriendlyName)) {
                registry.setStringValue(this.clSection, this.clKey + APPLICATIONS_KEY_NAME + SEP + appKey, FRIENDLYAPPNAME_VALUE_NAME, appFriendlyName);
                if (registry.keyExists(1, CURRENT_USER_MUI_CACHE_KEY)) {
                    String s = CREATED;
                    if (registry.valueExists(1, CURRENT_USER_MUI_CACHE_KEY, appLocation)) {
                        s = registry.getStringValue(1, CURRENT_USER_MUI_CACHE_KEY, appLocation);
                    }
                    registry.setStringValue(1, CURRENT_USER_MUI_CACHE_KEY, appLocation, appFriendlyName);
                    this.setExtProperty(props, name, EXT_HKCU_MUICACHE_PROPERTY, s);
                }
            }
            registry.createKey(this.clSection, this.clKey + APPLICATIONS_KEY_NAME + SEP + appKey + SHELL_OPEN_COMMAND);
            registry.setStringValue(this.clSection, this.clKey + APPLICATIONS_KEY_NAME + SEP + appKey + SHELL_OPEN_COMMAND, EXT_SUFFIX, this.constructCommand(app));
        }
    }

    private void unregisterApplication(SystemApplicationKey app, FileExtensionKey key, Properties props) throws NativeException {
        String name = key.getDotName();
        String property = this.getExtProperty(props, name, EXT_HKCR_APPLICATIONS_PROPERTY);
        if (property != null) {
            String appKey = app.getKey();
            if (registry.keyExists(this.clSection, this.clKey + APPLICATIONS_KEY_NAME, appKey)) {
                String[] openCommandKey = SHELL_OPEN_COMMAND.split("\\\\");
                for (int i = openCommandKey.length - 1; i >= 0; --i) {
                    String str = EXT_SUFFIX;
                    for (int j = i - 1; j >= 0; --j) {
                        str = str + SEP + openCommandKey[i - j];
                    }
                    if (!registry.keyExists(this.clSection, this.clKey + APPLICATIONS_KEY_NAME + SEP + appKey + str) || registry.getSubKeys(this.clSection, this.clKey + APPLICATIONS_KEY_NAME + SEP + appKey + str).length != 0) continue;
                    registry.deleteKey(this.clSection, this.clKey + APPLICATIONS_KEY_NAME + SEP + appKey + str);
                }
            }
        }
        if ((property = this.getExtProperty(props, name, EXT_HKCU_MUICACHE_PROPERTY)) != null && registry.valueExists(1, CURRENT_USER_MUI_CACHE_KEY, app.getLocation())) {
            if (property.equals(CREATED)) {
                registry.deleteValue(1, CURRENT_USER_MUI_CACHE_KEY, app.getLocation());
            } else {
                registry.setStringValue(1, CURRENT_USER_MUI_CACHE_KEY, app.getLocation(), property);
            }
        }
    }

    private String getApplicationKey(SystemApplication app) throws NativeException {
        String command;
        String appName;
        String appKey = appName = new File(app.getLocation()).getName();
        int index = 1;
        while (!(!registry.keyExists(this.clSection, this.clKey + APPLICATIONS_KEY_NAME, appKey) || registry.keyExists(this.clSection, this.clKey + APPLICATIONS_KEY_NAME + SEP + appKey + SHELL_OPEN_COMMAND) && (command = registry.getStringValue(this.clSection, this.clKey + APPLICATIONS_KEY_NAME + SEP + appKey + SHELL_OPEN_COMMAND, EXT_SUFFIX)).equals(this.constructCommand(app)))) {
            appKey = appName + "." + index++;
        }
        return appKey;
    }

    private String getLongExtensionName(FileExtension ext) throws NativeException {
        String dotname = ext.getDotName();
        String name = ext.getName();
        String key = null;
        if (registry.keyExists(this.clSection, this.clKey + dotname)) {
            key = registry.getStringValue(this.clSection, this.clKey + dotname, EXT_SUFFIX);
        }
        if (this.isEmpty(key) || !registry.keyExists(this.clSection, this.clKey + key)) {
            int index = 1;
            do {
                key = EXT_PREFIX + name + EXT_SUFFIX + "." + index++;
            } while (registry.keyExists(this.clSection, this.clKey + key));
        }
        return key;
    }

    private String constructCommand(SystemApplication app) {
        String command = app.getCommand();
        if (command == null) {
            command = DEFAULT_OPEN_COMMAND;
        }
        return "\"" + app.getLocation() + "\"" + " " + command;
    }

    private boolean isEmpty(String str) {
        return str == null || str.equals(EXT_SUFFIX);
    }

    private void initBrowser() {
        if (this.browserCommand != null) {
            return;
        }
        try {
            String type = null;
            if (registry.keyExists(1, "Software\\Classes\\.html")) {
                type = registry.getStringValue(1, "Software\\Classes\\.html", EXT_SUFFIX);
            } else if (registry.keyExists(0, ".html")) {
                type = registry.getStringValue(0, ".html", EXT_SUFFIX);
            }
            LogManager.log("... html type : " + type);
            if (type != null && !type.equals(EXT_SUFFIX)) {
                this.browserCommand = null;
                String userCmdKey = CURRENT_USER_CLASSES + type + SHELL_OPEN_COMMAND;
                String systemCmdKey = type + SHELL_OPEN_COMMAND;
                if (registry.keyExists(1, userCmdKey)) {
                    this.browserCommand = registry.getStringValue(1, userCmdKey, EXT_SUFFIX);
                    LogManager.log("... using user browser");
                } else if (registry.keyExists(0, systemCmdKey)) {
                    this.browserCommand = registry.getStringValue(0, systemCmdKey, EXT_SUFFIX);
                    LogManager.log("... using system browser");
                }
                if (this.browserCommand != null && !this.browserCommand.contains("%1")) {
                    userCmdKey = CURRENT_USER_CLASSES + type + "\\shell\\opennew\\command";
                    systemCmdKey = type + "\\shell\\opennew\\command";
                    if (registry.keyExists(1, userCmdKey)) {
                        this.browserCommand = registry.getStringValue(1, userCmdKey, EXT_SUFFIX);
                        LogManager.log("... using user browser");
                    } else if (registry.keyExists(0, systemCmdKey)) {
                        this.browserCommand = registry.getStringValue(0, systemCmdKey, EXT_SUFFIX);
                        LogManager.log("... using system browser");
                    }
                }
                LogManager.log("... command : " + this.browserCommand);
                if (this.browserCommand != null && !this.browserCommand.equals(EXT_SUFFIX) && this.browserCommand.contains("%1") && !this.browserCommand.contains(DEFAULT_OPEN_COMMAND)) {
                    this.browserCommand = this.browserCommand.replace("%1", DEFAULT_OPEN_COMMAND);
                }
            }
        }
        catch (NativeException e) {
            LogManager.log(e);
        }
    }

    @Override
    public boolean openBrowser(URI uri) {
        if (this.isBrowseSupported()) {
            String command = this.browserCommand.replace("%1", uri.toString());
            try {
                LogManager.log("... running : " + command);
                Runtime.getRuntime().exec(command);
                return true;
            }
            catch (IOException e) {
                LogManager.log(e);
            }
        }
        return false;
    }

    @Override
    public boolean isBrowseSupported() {
        this.initBrowser();
        return this.browserCommand != null;
    }

    private void notifyAssociationChanged() throws NativeException {
        this.notifyAssociationChanged0();
    }

    private String getExtProperty(Properties props, String name) {
        return props.getProperty(EXTENSION_VALUE_NAME + name);
    }

    private String getExtProperty(Properties props, String name, String prop) {
        return props.getProperty(EXTENSION_VALUE_NAME + name + "." + prop);
    }

    private void setExtProperty(Properties props, String name, String value) {
        props.setProperty(EXTENSION_VALUE_NAME + name, value);
    }

    private void setExtProperty(Properties props, String name, String prop, String value) {
        props.setProperty(EXTENSION_VALUE_NAME + name + "." + prop, value);
    }

    private native boolean isCurrentUserAdmin0();

    private native long getFreeSpace0(String var1);

    private native void createShortcut0(FileShortcut var1);

    private native void createProcessWithoutHandles0(String var1) throws NativeException;

    private native void deleteFileOnReboot0(String var1);

    private native void notifyAssociationChanged0();

    private native int checkAccessTokenAccessLevel0(String var1, int var2) throws NativeException;

    private native int notifyEnvironmentChanged0() throws NativeException;

    private class FileExtensionKey
    extends FileExtension {
        private String key;

        public FileExtensionKey(FileExtension fe, String key) {
            super(fe);
            this.key = key;
        }

        public String getKey() {
            return this.key;
        }
    }

    private class SystemApplicationKey
    extends SystemApplication {
        private String key;

        public SystemApplicationKey(SystemApplication sapp, String extKey) {
            super(sapp);
            this.key = extKey;
        }

        public String getKey() {
            return this.key;
        }
    }

    private class WindowsProcessOnExitCleanerHandler
    extends ProcessOnExitCleanerHandler {
        public WindowsProcessOnExitCleanerHandler(String cleanerDefaultFileName) {
            super(cleanerDefaultFileName);
        }

        @Override
        protected void writeCleaner(File cleanerFile) throws IOException {
            InputStream is = ResourceUtils.getResource(WindowsNativeUtils.CLEANER_RESOURCE);
            FileUtils.writeFile(cleanerFile, is);
            is.close();
        }

        @Override
        protected void writeCleaningFileList(File listFile, List<String> files) throws IOException {
            FileUtils.writeStringList(listFile, files, "UNICODE");
        }

        @Override
        public void run() {
            this.init();
            if (this.runningCommand != null) {
                try {
                    String command = WindowsNativeUtils.EXT_SUFFIX;
                    for (int i = 0; i < this.runningCommand.size(); ++i) {
                        if (i != 0) {
                            command = command + " ";
                        }
                        command = command + "\"" + (String)this.runningCommand.get(i) + "\"";
                    }
                    WindowsNativeUtils.this.createProcessWithoutHandles0(command);
                }
                catch (NativeException e) {
                    LogManager.log(e);
                }
            }
        }
    }
}

