/*
 * Decompiled with CFR 0.152.
 */
package genj.timeline;

import genj.almanac.Almanac;
import genj.gedcom.Gedcom;
import genj.gedcom.Grammar;
import genj.gedcom.PropertyEvent;
import genj.gedcom.TagPath;
import genj.timeline.AlmanacPanel;
import genj.timeline.TimelineView;
import genj.util.Resources;
import genj.util.swing.ColorsWidget;
import genj.util.swing.ImageIcon;
import genj.util.swing.ListSelectionWidget;
import genj.util.swing.NestedBlockLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTabbedPane;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class TimelineViewSettings
extends JTabbedPane {
    private Resources resources = Resources.get((Object)this);
    private ListSelectionWidget<TagPath> pathsList;
    private AlmanacPanel almanacPanel = null;
    private JCheckBox checkTags;
    private JCheckBox checkDates;
    private JCheckBox checkGrid;
    private JCheckBox packIndi;
    private JSpinner spinCmBefEvent;
    private JSpinner spinCmAftEvent;
    private ColorsWidget colorWidget;
    public Commit commit;

    TimelineViewSettings(TimelineView view) {
        final Gedcom gedcom = view.getModel().getGedcom();
        this.commit = new Commit(view);
        this.pathsList = new ListSelectionWidget<TagPath>(){

            protected ImageIcon getIcon(TagPath path) {
                Grammar grammar = Grammar.V55;
                if (gedcom != null) {
                    grammar = gedcom.getGrammar();
                }
                return grammar.getMeta(path).getImage();
            }

            protected String getText(TagPath path) {
                return path.getName();
            }
        };
        if (gedcom != null) {
            this.pathsList.setChoices((Object[])PropertyEvent.getTagPaths((Gedcom)gedcom));
        }
        this.pathsList.setCheckedChoices(view.getModel().getPaths());
        this.pathsList.addChangeListener((ChangeListener)this.commit);
        Almanac almanac = Almanac.getInstance();
        almanac.waitLoaded();
        this.almanacPanel = new AlmanacPanel(almanac, view, this.commit);
        JPanel panelOptions = new JPanel((LayoutManager)new NestedBlockLayout("<col><check gx=\"1\"/><check gx=\"1\"/><check gx=\"1\"/><check gx=\"1\"/><row><label/><spin/></row><row><label/><spin/></row></col>"));
        panelOptions.setOpaque(false);
        this.checkTags = this.createCheck("info.show.tags", view.isPaintTags());
        this.checkDates = this.createCheck("info.show.dates", view.isPaintDates());
        this.checkGrid = this.createCheck("info.show.grid", view.isPaintGrid());
        this.packIndi = this.createCheck("info.pack.indi", view.isPackIndi());
        panelOptions.add(this.checkTags);
        panelOptions.add(this.checkDates);
        panelOptions.add(this.checkGrid);
        panelOptions.add(this.packIndi);
        this.spinCmBefEvent = this.createSpinner(0.1, view.getCmBeforeEvents(), 2.0, "info.befevent.tip");
        panelOptions.add(new JLabel(this.resources.getString("info.befevent")));
        panelOptions.add(this.spinCmBefEvent);
        this.spinCmAftEvent = this.createSpinner(2.0, view.getCmAfterEvents(), 9.0, "info.aftevent.tip");
        panelOptions.add(new JLabel(this.resources.getString("info.aftevent")));
        panelOptions.add(this.spinCmAftEvent);
        JPanel panelMain = new JPanel(new BorderLayout());
        panelMain.add((Component)new JLabel(this.resources.getString("info.events")), "North");
        panelMain.add((Component)this.pathsList, "Center");
        panelMain.add((Component)panelOptions, "South");
        this.colorWidget = new ColorsWidget();
        ArrayList<String> keys = new ArrayList<String>(view.colors.keySet());
        Collections.sort(keys);
        for (String key : keys) {
            String name = this.resources.getString("color." + key).replace("color.", "");
            this.colorWidget.addColor(key, name, view.colors.get(key));
        }
        this.colorWidget.addChangeListener((ChangeListener)this.commit);
        this.add(this.resources.getString("page.main"), panelMain);
        this.add(this.resources.getString("page.almanac"), this.almanacPanel);
        this.add(this.resources.getString("page.colors"), (Component)this.colorWidget);
    }

    private JCheckBox createCheck(String key, boolean on) {
        JCheckBox result = new JCheckBox(this.resources.getString(key), on);
        result.addActionListener(this.commit);
        result.setOpaque(false);
        return result;
    }

    private JSpinner createSpinner(double min, double value, double max, String tip) {
        JSpinner result = new JSpinner(new SpinnerNumberModel(value, min, max, 0.1));
        JSpinner.NumberEditor editor = new JSpinner.NumberEditor(result, "##0.0");
        result.setEditor(editor);
        result.addChangeListener(editor);
        result.addChangeListener(this.commit);
        result.setToolTipText(this.resources.getString(tip));
        return result;
    }

    public class Commit
    implements ChangeListener,
    ActionListener {
        private TimelineView view;

        private Commit(TimelineView view) {
            this.view = view;
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            this.actionPerformed(new ActionEvent(e.getSource(), 0, ""));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JCheckBox cb;
            Object source = e.getSource();
            String command = e.getActionCommand();
            if (source instanceof ListSelectionWidget) {
                command = "rebuild";
            }
            if (source instanceof JSpinner) {
                command = "redraw";
            }
            if (source instanceof JCheckBox && (cb = (JCheckBox)source) == TimelineViewSettings.this.packIndi) {
                command = "redraw";
            }
            this.view.getModel().setPaths(TimelineViewSettings.this.pathsList.getCheckedChoices(), command.equals("rebuild"));
            this.view.setPaintTags(TimelineViewSettings.this.checkTags.isSelected());
            this.view.setPaintDates(TimelineViewSettings.this.checkDates.isSelected());
            this.view.setPaintGrid(TimelineViewSettings.this.checkGrid.isSelected());
            this.view.setCMPerEvents((Double)TimelineViewSettings.this.spinCmBefEvent.getModel().getValue(), (Double)TimelineViewSettings.this.spinCmAftEvent.getModel().getValue(), command.equals("redraw"));
            this.view.setPackIndi(TimelineViewSettings.this.packIndi.isSelected(), command.equals("redraw"));
            for (String key : this.view.colors.keySet()) {
                this.view.colors.put(key, TimelineViewSettings.this.colorWidget.getColor(key));
            }
            this.view.getRegistry().put("color", this.view.colors);
            this.view.setAlmanacs(TimelineViewSettings.this.almanacPanel.getCheckedAlmanacs());
            this.view.setAlmanacCategories(TimelineViewSettings.this.almanacPanel.getCheckedCategories());
            this.view.setAlmanacSigLevel(TimelineViewSettings.this.almanacPanel.getAlmanacSigLevel());
            this.view.saveInRegistry();
        }
    }
}

