/*
 * Decompiled with CFR 0.152.
 */
package genj.timeline;

import ancestris.core.actions.AbstractAncestrisAction;
import ancestris.core.pluginservice.AncestrisPlugin;
import ancestris.swing.ToolBar;
import ancestris.view.SelectionDispatcher;
import genj.almanac.Almanac;
import genj.almanac.Event;
import genj.gedcom.Context;
import genj.gedcom.Entity;
import genj.gedcom.Gedcom;
import genj.gedcom.GedcomException;
import genj.gedcom.Indi;
import genj.gedcom.Property;
import genj.gedcom.PropertyEvent;
import genj.gedcom.TagPath;
import genj.gedcom.time.PointInTime;
import genj.io.Filter;
import genj.renderer.DPI;
import genj.renderer.RenderOptions;
import genj.renderer.RenderSelectionHintKey;
import genj.timeline.AlmanacPanel;
import genj.timeline.ContentRenderer;
import genj.timeline.Model;
import genj.timeline.RulerRenderer;
import genj.timeline.TimelineViewSettings;
import genj.util.Registry;
import genj.util.Resources;
import genj.util.WordBuffer;
import genj.util.swing.ImageIcon;
import genj.util.swing.ScrollPaneWidget;
import genj.util.swing.SliderWidget;
import genj.util.swing.UnitGraphics;
import genj.util.swing.ViewPortAdapter;
import genj.view.ScreenshotAction;
import genj.view.SelectionListener;
import genj.view.SettingsAction;
import genj.view.View;
import genj.view.ViewContext;
import java.awt.AWTEvent;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.Point2D;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.openide.util.NbBundle;

public class TimelineView
extends View
implements SelectionListener,
Filter {
    private final DPI DPI;
    private final Point2D DPC;
    private Resources resources = Resources.get((Object)((Object)this));
    private String prefix = this.resources.getString("info.almanac") + "-";
    Map<String, Color> colors = new HashMap<String, Color>();
    private Model model;
    private Content content;
    private List<Model.Event> selectionEvent = new LinkedList<Model.Event>();
    private List<Model.EventSerie> selectionEventSerie = new LinkedList<Model.EventSerie>();
    private Ruler ruler;
    private SliderWidget sliderCmPerYear;
    private JScrollPane scrollContent;
    private RulerRenderer rulerRenderer = new RulerRenderer();
    private ContentRenderer contentRenderer = new ContentRenderer();
    private List<String> ignoredAlmanacCategories = new ArrayList<String>();
    private List<String> ignoredAlmanacsList = new ArrayList<String>();
    private int almanacSigLevel = AlmanacPanel.MAX_SIG;
    static final double MIN_CM_PER_YEAR = 0.1;
    static final double DEF_CM_PER_YEAR = 1.0;
    static final double MAX_CM_PER_YEAR = 20.0;
    static final double MIN_CM_BEF_EVENT = 0.1;
    static final double DEF_CM_BEF_EVENT = 0.5;
    static final double MAX_CM_BEF_EVENT = 2.0;
    static final double MIN_CM_AFT_EVENT = 2.0;
    static final double DEF_CM_AFT_EVENT = 2.0;
    static final double MAX_CM_AFT_EVENT = 9.0;
    private double cmPerYear = 1.0;
    private double cmBefEvent = 0.5;
    private double cmAftEvent = 2.0;
    private int defaulFontHeight = 0;
    private double centeredYear = 0.0;
    private boolean isPaintDates = true;
    private boolean isPaintGrid = false;
    private boolean isPaintTags = true;
    private boolean isPackIndi = false;
    private static final Registry REGISTRY = Registry.get(TimelineView.class);
    private ModelListener callback = new ModelListener();
    public static int INDI_MODE = 0;
    public static int EVENT_MODE = 1;
    public int mode = INDI_MODE;
    private CenterToSelectionAction ctsButton;
    private CenterTreeToIndividual cttiButton;
    private JLabel rootTitle;
    private List<Indi> filteredIndis;

    public TimelineView() {
        this.DPI = RenderOptions.getInstance().getDPI();
        this.DPC = new Point2D.Float((float)this.DPI.horizontal() / 2.54f, (float)this.DPI.vertical() / 2.54f);
        this.cmPerYear = Math.max(0.1, Math.min(20.0, (double)REGISTRY.get("cmperyear", 1.0f)));
        this.cmBefEvent = Math.max(0.1, Math.min(2.0, (double)REGISTRY.get("cmbefevent", 0.5f)));
        this.cmAftEvent = Math.max(2.0, Math.min(9.0, (double)REGISTRY.get("cmaftevent", 2.0f)));
        this.isPaintDates = REGISTRY.get("paintdates", true);
        this.isPaintGrid = REGISTRY.get("paintgrid", false);
        this.isPaintTags = REGISTRY.get("painttags", false);
        this.isPackIndi = REGISTRY.get("packindi", false);
        this.colors.put("background", Color.WHITE);
        this.colors.put("text", Color.BLACK);
        this.colors.put("tag", Color.GREEN);
        this.colors.put("date", Color.GRAY);
        this.colors.put("timespanM", Color.BLUE);
        this.colors.put("timespanF", Color.RED);
        this.colors.put("timespanU", Color.GRAY);
        this.colors.put("grid", Color.LIGHT_GRAY);
        this.colors.put("selected", Color.RED);
        this.colors.put("selectedBg", new Color(254, 255, 150));
        String[] ignoredNames = REGISTRY.get("almanac.ignorenames", new String[0]);
        this.ignoredAlmanacsList.addAll(Arrays.asList(ignoredNames));
        String[] ignored = REGISTRY.get("almanac.ignore", new String[0]);
        this.ignoredAlmanacCategories.addAll(Arrays.asList(ignored));
        this.almanacSigLevel = REGISTRY.get("almanac.siglevel", AlmanacPanel.MAX_SIG);
        this.mode = REGISTRY.get("display.mode", this.mode);
        this.model = new Model(this);
        this.model.setTimePerEvent(this.cmBefEvent / this.cmPerYear, this.cmAftEvent / this.cmPerYear, this.cmPerYear, false);
        this.model.setPackIndi(this.isPackIndi, false);
        String[] ps = REGISTRY.get("paths", (String[])null);
        if (ps != null) {
            ArrayList<TagPath> paths = new ArrayList<TagPath>(ps.length);
            for (String p : ps) {
                try {
                    paths.add(new TagPath(p));
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            this.model.setPaths(paths, true);
        } else {
            this.model.setPaths(null, false);
        }
        this.ruler = new Ruler();
        this.content = new Content();
        this.scrollContent = new ScrollPaneWidget((JComponent)this.content);
        this.scrollContent.setViewportBorder(BorderFactory.createEmptyBorder(5, 0, 0, 0));
        this.scrollContent.setBackground(Color.WHITE);
        this.scrollContent.setColumnHeaderView((Component)new ViewPortAdapter((JComponent)this.ruler));
        this.scrollContent.getViewport().addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                double x = ((TimelineView)TimelineView.this).scrollContent.getViewport().getViewPosition().x + ((TimelineView)TimelineView.this).scrollContent.getViewport().getSize().width / 2;
                TimelineView.this.centeredYear = TimelineView.this.pixel2year(x);
            }
        });
        this.setLayout(new BorderLayout());
        this.add(this.scrollContent, "Center");
        this.centeredYear = REGISTRY.get("centeryear", 0.0f);
        this.defaulFontHeight = this.getFontMetrics(UIManager.getDefaults().getFont("ScrollPane.font")).getHeight() + 1;
    }

    public void addNotify() {
        super.addNotify();
        this.model.addListener(this.callback);
        AncestrisPlugin.register((Object)((Object)this));
    }

    public void removeNotify() {
        this.model.removeListener(this.callback);
        this.saveInRegistry();
        AncestrisPlugin.unregister((Object)((Object)this));
        super.removeNotify();
    }

    public void saveInRegistry() {
        REGISTRY.put("cmperyear", (float)Math.rint(this.cmPerYear * 10.0) / 10.0f);
        REGISTRY.put("cmbefevent", (float)this.cmBefEvent);
        REGISTRY.put("cmaftevent", (float)this.cmAftEvent);
        REGISTRY.put("paintdates", Boolean.valueOf(this.isPaintDates));
        REGISTRY.put("paintgrid", Boolean.valueOf(this.isPaintGrid));
        REGISTRY.put("packindi", Boolean.valueOf(this.isPackIndi));
        REGISTRY.put("painttags", Boolean.valueOf(this.isPaintTags));
        REGISTRY.put("filter", this.model.getPaths());
        REGISTRY.put("centeryear", (float)this.centeredYear);
        REGISTRY.put("color", this.colors);
        REGISTRY.put("paths", this.model.getPaths());
        Object[] ignoredNames = new String[this.ignoredAlmanacsList.size()];
        for (int i = 0; i < ignoredNames.length; ++i) {
            ignoredNames[i] = this.ignoredAlmanacsList.get(i).toString();
        }
        REGISTRY.put("almanac.ignorenames", ignoredNames);
        Object[] ignored = new String[this.ignoredAlmanacCategories.size()];
        for (int i = 0; i < ignored.length; ++i) {
            ignored[i] = this.ignoredAlmanacCategories.get(i).toString();
        }
        REGISTRY.put("almanac.ignore", ignored);
        REGISTRY.put("almanac.siglevel", this.almanacSigLevel);
        REGISTRY.put("display.mode", this.mode);
    }

    public Dimension getPreferredSize() {
        return new Dimension(480, 256);
    }

    public Model getModel() {
        return this.model;
    }

    public void eraseModel() {
        this.model.eraseAll();
    }

    public Registry getRegistry() {
        return REGISTRY;
    }

    public List<String> getAlmanacList() {
        ArrayList<String> result = new ArrayList<String>(Almanac.getInstance().getAlmanacs());
        result.removeAll(this.ignoredAlmanacsList);
        return result;
    }

    public List<String> getAlmanacCategories() {
        ArrayList<String> result = new ArrayList<String>(Almanac.getInstance().getCategories());
        result.removeAll(this.ignoredAlmanacCategories);
        return result;
    }

    public int getAlmanacSigLevel() {
        return this.almanacSigLevel;
    }

    public void setAlmanacs(Set<String> set) {
        this.ignoredAlmanacsList.clear();
        this.ignoredAlmanacsList.addAll(Almanac.getInstance().getAlmanacs());
        this.ignoredAlmanacsList.removeAll(set);
        this.repaint();
    }

    public void setAlmanacCategories(Set<String> set) {
        this.ignoredAlmanacCategories.clear();
        this.ignoredAlmanacCategories.addAll(Almanac.getInstance().getCategories());
        this.ignoredAlmanacCategories.removeAll(set);
        this.repaint();
    }

    public void setAlmanacSigLevel(int set) {
        this.almanacSigLevel = set;
        this.repaint();
    }

    public List<String> getAlmanacColorLabels() {
        ArrayList<String> ret = new ArrayList<String>();
        Collator comparator = this.getCollator();
        comparator.setStrength(0);
        ArrayList<String> alms = new ArrayList<String>(Almanac.getInstance().getAlmanacs());
        Collections.sort(alms, comparator);
        for (String alm : alms) {
            ret.add(this.prefix + alm);
        }
        return ret;
    }

    public boolean isPaintTags() {
        return this.isPaintTags;
    }

    public void setPaintTags(boolean set) {
        this.isPaintTags = set;
        this.repaint();
    }

    public boolean isPaintDates() {
        return this.isPaintDates;
    }

    public void setPaintDates(boolean set) {
        this.isPaintDates = set;
        this.repaint();
    }

    public boolean isPaintGrid() {
        return this.isPaintGrid;
    }

    public void setPaintGrid(boolean set) {
        this.isPaintGrid = set;
        this.repaint();
    }

    public boolean isPackIndi() {
        return this.isPackIndi;
    }

    public void setPackIndi(boolean set, boolean redraw) {
        this.isPackIndi = set;
        this.model.setPackIndi(set, redraw);
        this.repaint();
    }

    public void setCMPerEvents(double before, double after, boolean redraw) {
        this.cmBefEvent = before;
        this.cmAftEvent = after;
        this.model.setTimePerEvent(this.cmBefEvent / this.cmPerYear, this.cmAftEvent / this.cmPerYear, this.cmPerYear, redraw);
        this.repaint();
    }

    public double getCmBeforeEvents() {
        return this.cmBefEvent;
    }

    public double getCmAfterEvents() {
        return this.cmAftEvent;
    }

    public void populate(ToolBar toolbar) {
        int value = (int)(Math.log((this.cmPerYear - 0.1) / 19.9 * Math.exp(10.0)) * 10.0);
        this.sliderCmPerYear = new SliderWidget(1, 100, Math.min(100, Math.max(1, value)));
        this.setTooltipText();
        this.sliderCmPerYear.addChangeListener((ChangeListener)new ChangeCmPerYear());
        this.sliderCmPerYear.setOpaque(false);
        this.ctsButton = new CenterToSelectionAction();
        this.cttiButton = new CenterTreeToIndividual();
        toolbar.setFloatable(false);
        toolbar.add((JComponent)this.sliderCmPerYear);
        toolbar.add((Action)((Object)new ToggleModeAction()));
        toolbar.add((Action)((Object)this.ctsButton));
        toolbar.add((Action)((Object)this.cttiButton));
        toolbar.addSeparator();
        toolbar.add((Action)new ScreenshotAction((JComponent)this.content));
        this.rootTitle = new JLabel();
        this.rootTitle.setHorizontalAlignment(0);
        toolbar.add((Component)this.rootTitle, (Object)"growx, pushx, center");
        this.rootTitle.setText("");
        toolbar.addSeparator();
        toolbar.add((Action)((Object)new Settings()));
    }

    public void setRootTitle(String title) {
        if (this.rootTitle != null && title != null) {
            this.rootTitle.setText("<html><center>" + this.resources.getString("root.name") + " " + title + "</center></html");
        }
    }

    public void setContext(Context context) {
        if (context == null) {
            this.model.setGedcom(null);
        } else {
            this.model.setGedcom(context);
        }
    }

    public void update() {
        this.selectionEvent = this.model.getEvents();
        this.selectionEventSerie = this.model.getIndis();
        int layer = this.scrollContent.getVerticalScrollBar().getValue() / this.defaulFontHeight;
        if (this.mode == INDI_MODE && !this.selectionEventSerie.isEmpty() || this.mode == EVENT_MODE && !this.selectionEvent.isEmpty()) {
            this.centerToSelection();
        } else {
            this.scroll2year(this.centeredYear);
            this.scroll2layer(layer);
            this.ctsButton.setEnabled(false);
            this.ctsButton.setTip(false, "");
            this.cttiButton.setEnabled(false);
            this.cttiButton.setTip(false, "");
        }
        this.setTooltipText();
        this.repaint();
        this.scrollContent.setViewportView(this.content);
    }

    public void centerToSelection() {
        if (this.ctsButton == null || this.cttiButton == null || !this.model.isReady()) {
            return;
        }
        if (this.mode == INDI_MODE) {
            boolean enabled = !this.selectionEventSerie.isEmpty();
            Model.EventSerie eventSerie = enabled ? this.selectionEventSerie.get(this.selectionEventSerie.size() - 1) : null;
            String text = eventSerie == null ? "" : eventSerie.toString();
            this.ctsButton.setEnabled(enabled);
            this.ctsButton.setTip(enabled, text);
            this.cttiButton.setEnabled(enabled);
            this.cttiButton.setTip(enabled, text);
            if (enabled) {
                this.makeVisible(eventSerie);
            }
        } else {
            boolean enabled = !this.selectionEvent.isEmpty();
            Model.Event event = enabled ? this.selectionEvent.get(this.selectionEvent.size() - 1) : null;
            String text = event == null ? "" : event.toString();
            this.ctsButton.setEnabled(enabled);
            this.ctsButton.setTip(enabled, text);
            this.cttiButton.setEnabled(false);
            this.cttiButton.setTip(false, "");
            if (enabled) {
                this.makeVisible(event);
            }
        }
    }

    public void setTooltipText() {
        double cmPY = Math.floor(this.cmPerYear * 100.0) / 100.0;
        this.sliderCmPerYear.setToolTipText(cmPY + " " + this.resources.getString("view.peryear.tip") + " (" + this.sliderCmPerYear.getValue() + "%)");
        JScrollBar hsb = this.scrollContent.getHorizontalScrollBar();
        hsb.setUnitIncrement((int)(this.DPC.getX() * this.cmPerYear));
        String minYear = String.valueOf((int)this.pixel2year(hsb.getMinimum()));
        String year = String.valueOf((int)this.pixel2year(hsb.getValue()) + 1);
        String maxYear = String.valueOf((int)this.pixel2year(hsb.getMaximum()));
        hsb.setToolTipText(this.resources.getString("view.scrollyear.tip", new Object[]{minYear, year, maxYear}));
        JScrollBar vsb = this.scrollContent.getVerticalScrollBar();
        vsb.setUnitIncrement(2 * this.defaulFontHeight);
        String value = Integer.toString(vsb.getValue() / this.defaulFontHeight);
        String total = Integer.toString(this.model.getLayersNumber(this.mode));
        vsb.setToolTipText(this.resources.getString("view.scrolllayer.tip", new Object[]{value, total}));
    }

    protected double pixel2year(double x) {
        return this.model.min + x / (this.DPC.getX() * this.cmPerYear);
    }

    protected void scroll2year(double year) {
        this.centeredYear = year;
        int minX = this.scrollContent.getHorizontalScrollBar().getValue() + 10;
        int maxX = minX + this.scrollContent.getViewport().getWidth() - 90;
        int newX = (int)((year - this.model.min) * this.DPC.getX() * this.cmPerYear);
        if (maxX < minX || newX > minX && newX < maxX) {
            return;
        }
        this.scrollContent.revalidate();
        this.scrollContent.getHorizontalScrollBar().setValue(newX -= this.scrollContent.getViewport().getWidth() / 2);
    }

    protected void scroll2layer(int layer) {
        int windowHeight = this.scrollContent.getViewport().getHeight();
        int northBand = 2 * this.defaulFontHeight;
        int southBand = windowHeight - 4 * this.defaulFontHeight;
        int minY = this.scrollContent.getVerticalScrollBar().getValue() + northBand;
        int maxY = minY + southBand;
        int newY = layer * this.defaulFontHeight;
        if (maxY < minY || newY > minY && newY < maxY) {
            return;
        }
        newY = newY <= minY && minY - newY <= northBand ? (newY -= northBand) : (newY >= maxY && newY - maxY <= southBand ? (newY -= southBand) : (newY -= windowHeight / 2));
        if (newY < 0) {
            newY = 0;
        }
        this.scrollContent.revalidate();
        this.scrollContent.getVerticalScrollBar().setValue(newY);
    }

    private void makeVisible(Model.Event event) {
        this.scroll2year(event.from);
        this.scroll2layer(this.model.getLayerFromEvent(event));
    }

    private void makeVisible(Model.EventSerie eventSerie) {
        this.scroll2year(eventSerie.from);
        this.scroll2layer(this.model.getLayerFromEventSerie(eventSerie));
    }

    protected Model.Event getEventAt(Point pos) {
        double year = this.pixel2year(pos.x);
        int layer = pos.y / this.defaulFontHeight;
        return this.model.getEvent(year, layer);
    }

    protected Model.EventSerie getIndiAt(Point pos) {
        double year = this.pixel2year(pos.x);
        int layer = pos.y / this.defaulFontHeight;
        return this.model.getEventSerie(year, layer);
    }

    public Collator getCollator() {
        if (this.content == null) {
            return Collator.getInstance(this.getLocale());
        }
        return this.content.getContext().getGedcom().getCollator();
    }

    public String getFilterName() {
        this.filteredIndis = this.model.getIndisFromLayers();
        return NbBundle.getMessage(TimelineView.class, (String)"TTL_Filter", (Object)this.filteredIndis.size(), (Object)this.resources.getString("title"));
    }

    public boolean veto(Property property) {
        return false;
    }

    public boolean veto(Entity entity) {
        if (this.filteredIndis == null) {
            this.filteredIndis = this.model.getIndisFromLayers();
        }
        return !this.filteredIndis.contains(entity);
    }

    public boolean canApplyTo(Gedcom gedcom) {
        return gedcom != null && gedcom.equals(this.model.getGedcom());
    }

    private class CenterToSelectionAction
    extends AbstractAncestrisAction {
        private CenterToSelectionAction() {
            this.setImage((Icon)new ImageIcon((Object)this, "root"));
            this.setTip(true, "");
        }

        public void setTip(boolean enabled, String text) {
            if (enabled) {
                this.setTip(TimelineView.this.resources.getString("root.tip", new Object[]{text}));
            } else {
                this.setTip(TimelineView.this.resources.getString("root.tip.none"));
            }
        }

        public void actionPerformed(ActionEvent event) {
            TimelineView.this.centerToSelection();
        }
    }

    private class CenterTreeToIndividual
    extends AbstractAncestrisAction {
        private CenterTreeToIndividual() {
            this.setImage((Icon)new ImageIcon((Object)this, "centertree"));
            this.setTip(true, "");
        }

        private void setTip(boolean enabled, String text) {
            if (enabled) {
                this.setTip(TimelineView.this.resources.getString("centertree.tip", new Object[]{text}));
            } else {
                this.setTip(TimelineView.this.resources.getString(TimelineView.this.mode == INDI_MODE ? "centertree.tip.none" : "centertree.tip.noneforthismode"));
            }
        }

        public void actionPerformed(ActionEvent event) {
            TimelineView.this.model.layoutLayers(true);
        }
    }

    private class ToggleModeAction
    extends AbstractAncestrisAction {
        private ImageIcon indiIcon = new ImageIcon((Object)this, "indi");
        private ImageIcon eventIcon = new ImageIcon((Object)this, "event");

        private ToggleModeAction() {
            this.setIcon();
            this.setTip();
        }

        private void setIcon() {
            this.setImage((Icon)(TimelineView.this.mode == INDI_MODE ? this.indiIcon : this.eventIcon));
            TimelineView.this.cttiButton.setEnabled(TimelineView.this.mode == INDI_MODE);
        }

        private void setTip() {
            this.setTip(TimelineView.this.resources.getString(TimelineView.this.mode == INDI_MODE ? "toggle.toEvent.tip" : "toggle.toIndi.tip"));
        }

        public void actionPerformed(ActionEvent event) {
            TimelineView.this.mode = 1 - TimelineView.this.mode;
            this.setIcon();
            this.setTip();
            TimelineView.this.revalidate();
            TimelineView.this.repaint();
            TimelineView.this.scrollContent.setViewportView(TimelineView.this.content);
            TimelineView.this.centerToSelection();
        }
    }

    private class Settings
    extends SettingsAction {
        private Settings() {
        }

        protected TimelineViewSettings getEditor() {
            return new TimelineViewSettings(TimelineView.this);
        }
    }

    private class ModelListener
    implements Model.Listener {
        private ModelListener() {
        }

        @Override
        public void dataChanged() {
            TimelineView.this.repaint();
        }

        @Override
        public void structureChanged() {
            TimelineView.this.ruler.revalidate();
            TimelineView.this.content.revalidate();
            TimelineView.this.repaint();
        }
    }

    private class ChangeCmPerYear
    implements ChangeListener {
        private ChangeCmPerYear() {
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            TimelineView.this.cmPerYear = 0.1 + Math.exp((double)TimelineView.this.sliderCmPerYear.getValue() * 0.1) / Math.exp(10.0) * 19.9;
            TimelineView.this.model.setTimePerEvent(TimelineView.this.cmBefEvent / TimelineView.this.cmPerYear, TimelineView.this.cmAftEvent / TimelineView.this.cmPerYear, TimelineView.this.cmPerYear, true);
        }
    }

    private class Content
    extends JComponent
    implements MouseListener {
        private Content() {
            this.addMouseListener(this);
        }

        private ViewContext getContext() {
            Gedcom gedcom = TimelineView.this.model.getGedcom();
            if (gedcom == null) {
                return null;
            }
            LinkedList<PropertyEvent> props = new LinkedList<PropertyEvent>();
            if (TimelineView.this.mode == INDI_MODE) {
                for (Model.EventSerie eventSerie : TimelineView.this.selectionEventSerie) {
                    props.add(eventSerie.getProperty());
                }
            } else {
                for (Model.Event event : TimelineView.this.selectionEvent) {
                    props.add(event.pe);
                }
            }
            return new ViewContext(gedcom, null, props);
        }

        @Override
        public Dimension getPreferredSize() {
            return new Dimension((int)((((TimelineView)TimelineView.this).model.max - ((TimelineView)TimelineView.this).model.min) * TimelineView.this.DPC.getX() * TimelineView.this.cmPerYear), TimelineView.this.model.getLayersNumber(TimelineView.this.mode) * TimelineView.this.defaulFontHeight);
        }

        @Override
        protected void paintComponent(Graphics g) {
            Boolean rsel = (Boolean)((Graphics2D)g).getRenderingHint(RenderSelectionHintKey.KEY);
            if (rsel == null) {
                rsel = true;
            }
            if (TimelineView.this.mode == INDI_MODE) {
                ((TimelineView)TimelineView.this).contentRenderer.selectionEventSerie = rsel != false ? TimelineView.this.selectionEventSerie : new LinkedList();
            } else {
                ((TimelineView)TimelineView.this).contentRenderer.selectionEvent = rsel != false ? TimelineView.this.selectionEvent : new LinkedList();
            }
            for (String alm : TimelineView.this.getAlmanacColorLabels()) {
                TimelineView.this.colors.put(alm, Color.BLUE);
            }
            TimelineView.this.colors = REGISTRY.get("color", TimelineView.this.colors);
            ((TimelineView)TimelineView.this).contentRenderer.cBackground = TimelineView.this.colors.get("background");
            ((TimelineView)TimelineView.this).contentRenderer.cText = TimelineView.this.colors.get("text");
            ((TimelineView)TimelineView.this).contentRenderer.cDate = TimelineView.this.colors.get("date");
            ((TimelineView)TimelineView.this).contentRenderer.cTag = TimelineView.this.colors.get("tag");
            ((TimelineView)TimelineView.this).contentRenderer.cTimespanM = TimelineView.this.colors.get("timespanM");
            ((TimelineView)TimelineView.this).contentRenderer.cTimespanF = TimelineView.this.colors.get("timespanF");
            ((TimelineView)TimelineView.this).contentRenderer.cTimespanU = TimelineView.this.colors.get("timespanU");
            ((TimelineView)TimelineView.this).contentRenderer.cGrid = TimelineView.this.colors.get("grid");
            ((TimelineView)TimelineView.this).contentRenderer.cSelected = TimelineView.this.colors.get("selected");
            ((TimelineView)TimelineView.this).contentRenderer.cSelectedBg = TimelineView.this.colors.get("selectedBg");
            ((TimelineView)TimelineView.this).contentRenderer.paintDates = TimelineView.this.isPaintDates;
            ((TimelineView)TimelineView.this).contentRenderer.paintGrid = TimelineView.this.isPaintGrid;
            ((TimelineView)TimelineView.this).contentRenderer.paintTags = TimelineView.this.isPaintTags;
            UnitGraphics graphics = new UnitGraphics(g, TimelineView.this.DPC.getX() * TimelineView.this.cmPerYear, (double)TimelineView.this.defaulFontHeight);
            graphics.translate(-((TimelineView)TimelineView.this).model.min, 0.0);
            if (TimelineView.this.model.isReady()) {
                TimelineView.this.contentRenderer.render(graphics, TimelineView.this.model, TimelineView.this.mode);
            }
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (e.getButton() != 1) {
                return;
            }
            if (TimelineView.this.mode == INDI_MODE) {
                Model.EventSerie hit = TimelineView.this.getIndiAt(e.getPoint());
                if (hit != null) {
                    TimelineView.this.selectionEventSerie.clear();
                    TimelineView.this.selectionEventSerie.add(hit);
                    SelectionDispatcher.fireSelection((AWTEvent)e, (Context)this.getContext());
                }
            } else {
                Model.Event hit = TimelineView.this.getEventAt(e.getPoint());
                if (hit != null) {
                    TimelineView.this.selectionEvent.clear();
                    TimelineView.this.selectionEvent.add(hit);
                    SelectionDispatcher.fireSelection((AWTEvent)e, (Context)this.getContext());
                }
            }
            this.repaint();
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
        }

        @Override
        public void mousePressed(MouseEvent e) {
        }
    }

    private class Ruler
    extends JComponent
    implements MouseMotionListener,
    ChangeListener {
        private Ruler() {
        }

        @Override
        public void addNotify() {
            super.addNotify();
            this.addMouseMotionListener(this);
            Almanac.getInstance().addChangeListener(this);
            ToolTipManager.sharedInstance().setDismissDelay(Integer.MAX_VALUE);
        }

        @Override
        public void removeNotify() {
            this.removeMouseMotionListener(this);
            Almanac.getInstance().removeChangeListener(this);
            super.removeNotify();
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            this.repaint();
        }

        @Override
        protected void paintComponent(Graphics g) {
            for (String alm : TimelineView.this.getAlmanacColorLabels()) {
                TimelineView.this.colors.put(alm, Color.BLUE);
            }
            TimelineView.this.colors = REGISTRY.get("color", TimelineView.this.colors);
            ((TimelineView)TimelineView.this).rulerRenderer.cBackground = TimelineView.this.colors.get("background");
            ((TimelineView)TimelineView.this).rulerRenderer.cTick = ((TimelineView)TimelineView.this).rulerRenderer.cText = TimelineView.this.colors.get("text");
            ((TimelineView)TimelineView.this).rulerRenderer.cTimespanM = TimelineView.this.colors.get("timespanM");
            ((TimelineView)TimelineView.this).rulerRenderer.cTimespanF = TimelineView.this.colors.get("timespanF");
            ((TimelineView)TimelineView.this).rulerRenderer.cTimespanU = TimelineView.this.colors.get("timespanU");
            ((TimelineView)TimelineView.this).rulerRenderer.almanacs = TimelineView.this.getAlmanacList();
            ((TimelineView)TimelineView.this).rulerRenderer.acats = TimelineView.this.getAlmanacCategories();
            ((TimelineView)TimelineView.this).rulerRenderer.sigLevel = TimelineView.this.getAlmanacSigLevel();
            UnitGraphics graphics = new UnitGraphics(g, TimelineView.this.DPC.getX() * TimelineView.this.cmPerYear, (double)TimelineView.this.defaulFontHeight);
            graphics.translate(-((TimelineView)TimelineView.this).model.min, 0.0);
            TimelineView.this.rulerRenderer.render(graphics, TimelineView.this.model);
            TimelineView.this.setTooltipText();
        }

        @Override
        public Dimension getPreferredSize() {
            return new Dimension((int)((((TimelineView)TimelineView.this).model.max - ((TimelineView)TimelineView.this).model.min) * TimelineView.this.DPC.getX() * TimelineView.this.cmPerYear), TimelineView.this.defaulFontHeight);
        }

        @Override
        public void mouseDragged(MouseEvent e) {
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            double year = TimelineView.this.pixel2year(e.getPoint().x);
            PointInTime when = Model.toPointInTime(year);
            int days = (int)Math.ceil(5.0 / TimelineView.this.DPC.getX() / TimelineView.this.cmPerYear * 365.0);
            WordBuffer text = new WordBuffer();
            List<String> alms = TimelineView.this.getAlmanacList();
            int cursor = 0;
            try {
                Iterator<Event> almanac = Almanac.getInstance().getEvents(when, days, TimelineView.this.getAlmanacList(), TimelineView.this.getAlmanacCategories(), TimelineView.this.getAlmanacSigLevel());
                if (almanac.hasNext()) {
                    String hex;
                    Color color;
                    text.append("<html><body><div width=\"" + (double)TimelineView.this.getWidth() * 0.4 + "\"><ul>");
                    for (int i = 0; i < 10 && almanac.hasNext(); ++i) {
                        Event event = almanac.next();
                        color = TimelineView.this.colors.get(TimelineView.this.prefix + event.getAlmanac());
                        hex = "#" + Integer.toHexString(color.getRGB()).substring(2);
                        text.append("<li color=\"" + hex + "\">" + event.toString() + "</li><br>");
                    }
                    text.append("</ul></div>");
                    text.append("<div>" + TimelineView.this.resources.getString("almanac.legend"));
                    for (String alm : alms) {
                        color = TimelineView.this.colors.get(TimelineView.this.prefix + alm);
                        hex = "#" + Integer.toHexString(color.getRGB()).substring(2);
                        text.append("<font color=\"" + hex + "\">" + alm + " </font>");
                    }
                    text.append("</div>");
                    text.append("</body></html>");
                    cursor = 2;
                }
            }
            catch (GedcomException gedcomException) {
                // empty catch block
            }
            this.setCursor(Cursor.getPredefinedCursor(cursor));
            this.setToolTipText(text.length() == 0 ? null : text.toString());
        }
    }
}

