/*
 * Decompiled with CFR 0.152.
 */
package genj.util.swing;

import ancestris.core.actions.AbstractAncestrisAction;
import genj.io.InputSource;
import genj.io.input.FileInput;
import genj.renderer.MediaRenderer;
import genj.util.swing.GraphicsHelper;
import genj.util.swing.ImageIcon;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.datatransfer.DataFlavor;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import javax.imageio.ImageReader;
import javax.imageio.event.IIOReadUpdateListener;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.ToolTipManager;
import javax.swing.filechooser.FileSystemView;

public class ThumbnailWidget
extends JComponent {
    private static final int MIN_THUMBNAIL = 32;
    public static final ImageIcon IMG_THUMBNAIL = new ImageIcon(ThumbnailWidget.class, "File.png");
    public static final ImageIcon IMG_ZOOM_FIT = new ImageIcon(ThumbnailWidget.class, "ZoomFit.png");
    public static final ImageIcon IMG_ZOOM_ALL = new ImageIcon(ThumbnailWidget.class, "ZoomAll.png");
    private static final Logger LOG = Logger.getLogger("ancestris.util.swing");
    private static final BlockingQueue<Runnable> EXECUTOR_QUEUE = new LinkedBlockingDeque<Runnable>();
    private static final Executor EXECUTOR = new ThreadPoolExecutor(1, 1, 0L, TimeUnit.SECONDS, EXECUTOR_QUEUE);
    private int thumbSize = 64;
    private final int thumbPadding = 10;
    private final Insets thumbBorder = new Insets(4, 4, 20, 4);
    private final List<Thumbnail> thumbs = new ArrayList<Thumbnail>();
    private final Timer repaint = new Timer(100, e -> this.repaint());
    private Thumbnail selection = null;
    private final AbstractAncestrisAction zoomFit = new Fit();
    private final AbstractAncestrisAction zoomAll = new All();
    private final AbstractAncestrisAction zoomOne = new One();
    private final Point topLeft = new Point(0, 0);

    public ThumbnailWidget() {
        this.setRequestFocusEnabled(true);
        EventHandler handler = new EventHandler();
        this.addMouseWheelListener(handler);
        this.addMouseListener(handler);
        this.addMouseMotionListener(handler);
        new DropTarget(this, handler);
        ToolTipManager.sharedInstance().registerComponent(this);
        this.setBackground(Color.LIGHT_GRAY);
    }

    public AbstractAncestrisAction getFitAction() {
        return this.zoomFit;
    }

    public AbstractAncestrisAction getOneAction() {
        return this.zoomOne;
    }

    public AbstractAncestrisAction getAllAction() {
        return this.zoomAll;
    }

    public void clear() {
        this.setSources(null);
    }

    public InputSource getSelection() {
        return this.selection != null ? this.selection.source : null;
    }

    public void setSource(InputSource source) {
        if (source == null) {
            this.clear();
        } else {
            this.setSources(Collections.singletonList(source));
        }
    }

    public void setSources(List<InputSource> sources) {
        if (this.selection != null) {
            this.unselect(this.selection.source);
        }
        int oldSize = this.thumbs.size();
        this.thumbs.clear();
        if (sources != null) {
            sources.forEach(source -> this.thumbs.add(new Thumbnail((InputSource)source)));
        }
        this.firePropertyChange("content", oldSize, this.thumbs.size());
        this.showAll();
    }

    public void addSource(InputSource source) {
        int oldSize = this.thumbs.size();
        Thumbnail thumb = new Thumbnail(source);
        this.thumbs.add(thumb);
        this.firePropertyChange("content", oldSize, this.thumbs.size());
        Thumbnail old = this.selection;
        this.selection = thumb;
        this.firePropertyChange("selection", old != null ? old.getSource() : null, this.selection.getSource());
        this.showAll();
    }

    public void removeSource(InputSource source) {
        this.unselect(source);
        int oldSize = this.thumbs.size();
        for (Thumbnail thumb : new ArrayList<Thumbnail>(this.thumbs)) {
            if (thumb.source != source) continue;
            this.thumbs.remove(thumb);
        }
        this.firePropertyChange("content", oldSize, this.thumbs.size());
        this.showAll();
    }

    @Override
    public String getToolTipText() {
        return super.getToolTipText();
    }

    @Override
    public String getToolTipText(MouseEvent event) {
        Thumbnail thumb = this.getThumb(event.getPoint());
        return thumb != null ? this.getToolTipText(thumb.source) : null;
    }

    public String getToolTipText(InputSource source) {
        return source.getName();
    }

    private void unselect(InputSource source) {
        if (this.selection == null || this.selection.source != source) {
            return;
        }
        Thumbnail oldSelection = this.selection;
        this.selection = null;
        this.firePropertyChange("selection", oldSelection.getSource(), null);
    }

    @Override
    public void setBounds(int x, int y, int width, int height) {
        super.setBounds(x, y, width, height);
        Dimension d = this.getDimension();
        this.topLeft.x = (width - d.width) / 2;
        this.topLeft.y = (height - d.height) / 2;
    }

    private void scrollTo(int x, int y) {
        Dimension d = this.getDimension();
        this.topLeft.x = d.width < this.getWidth() ? (this.getWidth() - d.width) / 2 : Math.max(-(d.width - this.getWidth()), Math.min(0, x));
        this.topLeft.y = d.height < this.getHeight() ? (this.getHeight() - d.height) / 2 : Math.max(-(d.height - this.getHeight()), Math.min(0, y));
        this.repaint();
    }

    protected void handleDrop(List<File> files) {
    }

    public void showOne() {
        if (this.selection == null || ((Thumbnail)this.selection).size.width == 0 || ((Thumbnail)this.selection).size.height == 0) {
            return;
        }
        Point center = new Point(this.getWidth() / 2, this.getHeight() / 2);
        Rectangle r = this.getRectangle(this.selection);
        double cx = 0.5;
        double cy = 0.5;
        if (r.contains(center)) {
            cx = (double)(center.x - r.x) / r.getWidth();
            cy = (double)(center.y - r.y) / r.getHeight();
        }
        this.thumbSize = Math.max(((Thumbnail)this.selection).size.width, ((Thumbnail)this.selection).size.height);
        this.topLeft.setLocation(0, 0);
        r = this.getRectangle(this.selection);
        this.scrollTo(-((int)((double)r.x + (double)r.width * cx - (double)(this.getWidth() / 2))), -((int)((double)r.y + (double)r.height * cy - (double)(this.getHeight() / 2))));
    }

    public void showSelection() {
        if (this.selection == null) {
            return;
        }
        if (((Thumbnail)this.selection).size.width == 0 || ((Thumbnail)this.selection).size.height == 0) {
            return;
        }
        Dimension size = ThumbnailWidget.fit(this.selection.size, this.getSize());
        this.thumbSize = Math.max(size.width, size.height);
        this.topLeft.setLocation(0, 0);
        Rectangle r = this.getRectangle(this.selection);
        this.scrollTo(-(r.x + this.thumbBorder.left - (Math.max(this.thumbSize, this.getWidth()) - size.width) / 2), -(r.y + this.thumbBorder.top + (Math.max(this.thumbSize, this.getHeight()) - size.height) / 2));
    }

    public void showAll() {
        if (this.getWidth() == 0 || this.getHeight() == 0) {
            SwingUtilities.invokeLater(() -> this.showAllImpl());
            return;
        }
        this.showAllImpl();
    }

    private void showAllImpl() {
        this.thumbSize = this.thumbs.size() == 1 ? Math.min(this.getShowAllThumbSize(), this.getMinThumbSize()) : this.getShowAllThumbSize();
        this.scrollTo(0, 0);
    }

    private int getMinThumbSize() {
        int min = Integer.MAX_VALUE;
        for (Thumbnail thumb : this.thumbs) {
            if (((Thumbnail)thumb).size.width <= 0 || ((Thumbnail)thumb).size.height <= 0) continue;
            min = Math.min(min, Math.max(((Thumbnail)thumb).size.width, ((Thumbnail)thumb).size.height));
        }
        return min;
    }

    private int getShowAllThumbSize() {
        Dimension rc = this.getRowsCols();
        if (rc.width == 0 || rc.height == 0) {
            return 32;
        }
        int sizex = Math.max(32, this.getWidth() / rc.width - this.thumbBorder.left - this.thumbBorder.right - 10);
        int sizey = Math.max(32, this.getHeight() / rc.height - this.thumbBorder.top - this.thumbBorder.bottom - 10);
        return Math.min(sizex, sizey);
    }

    private void select(Thumbnail thumb) {
        Thumbnail old = this.selection;
        if (old == thumb) {
            return;
        }
        this.selection = thumb;
        this.repaint();
        this.firePropertyChange("selection", old != null ? old.getSource() : null, this.selection != null ? this.selection.getSource() : null);
    }

    private Rectangle getRectangle(Thumbnail find) {
        Dimension rc = this.getRowsCols();
        int row = 0;
        int col = 0;
        for (Thumbnail thumb : this.thumbs) {
            if (find == thumb) {
                return new Rectangle(this.topLeft.x + col * (this.thumbBorder.left + this.thumbSize + this.thumbBorder.right + 10) + 5, this.topLeft.y + row * (this.thumbBorder.top + this.thumbSize + this.thumbBorder.bottom + 10) + 5, this.thumbBorder.left + this.thumbSize + this.thumbBorder.right, this.thumbBorder.top + this.thumbSize + this.thumbBorder.bottom);
            }
            ++col;
            if ((col %= rc.width) != 0) continue;
            ++row;
        }
        throw new IllegalArgumentException("unknown thumbnail");
    }

    private Thumbnail getThumb(Point pos) {
        Dimension rc = this.getRowsCols();
        int row = 0;
        int col = 0;
        for (Thumbnail thumb : this.thumbs) {
            Rectangle r = new Rectangle(this.topLeft.x + col * (this.thumbBorder.left + this.thumbSize + this.thumbBorder.right + 10) + 5, this.topLeft.y + row * (this.thumbBorder.top + this.thumbSize + this.thumbBorder.bottom + 10) + 5, this.thumbBorder.left + this.thumbSize + this.thumbBorder.right, this.thumbBorder.top + this.thumbSize + this.thumbBorder.bottom);
            if (r.contains(pos)) {
                return thumb;
            }
            ++col;
            if ((col %= rc.width) != 0) continue;
            ++row;
        }
        return null;
    }

    private Dimension getDimension() {
        Dimension rowsCols = this.getRowsCols();
        return new Dimension(rowsCols.width * (this.thumbSize + this.thumbBorder.left + this.thumbBorder.right + 10), rowsCols.height * (this.thumbSize + this.thumbBorder.top + this.thumbBorder.bottom + 10));
    }

    private Dimension getRowsCols() {
        if (this.thumbs.isEmpty()) {
            return new Dimension();
        }
        int cols = (int)Math.ceil(Math.sqrt(this.thumbs.size()));
        int rows = (int)Math.ceil((float)this.thumbs.size() / (float)cols);
        return new Dimension(cols, rows);
    }

    private Image getFallback(InputSource source) {
        File file;
        ImageIcon result = IMG_THUMBNAIL;
        if (source instanceof FileInput && (file = ((FileInput)source).getFile()).isFile()) {
            try {
                Icon icon = FileSystemView.getFileSystemView().getSystemIcon(file);
                if (icon != null) {
                    result = new ImageIcon(icon);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return result.getImage();
    }

    @Override
    public void paint(Graphics g) {
        Graphics2D g2d = (Graphics2D)g;
        Dimension d = this.getSize();
        g.setColor(this.getBackground());
        g.fillRect(0, 0, d.width, d.height);
        int cols = (int)Math.ceil(Math.sqrt(this.thumbs.size()));
        int rows = (int)Math.ceil((float)this.thumbs.size() / (float)cols);
        int row = 0;
        int col = 0;
        for (Thumbnail thumb : this.thumbs) {
            Validation v;
            Rectangle content;
            Point p = new Point(this.topLeft.x + col * (this.thumbSize + this.thumbBorder.left + this.thumbBorder.right + 10) + 5, this.topLeft.y + row * (this.thumbSize + this.thumbBorder.top + this.thumbBorder.bottom + 10) + 5);
            g.setColor(Color.DARK_GRAY);
            g2d.fill(new Rectangle(p.x + this.thumbBorder.left + this.thumbSize + this.thumbBorder.right, p.y + 2, 2, this.thumbBorder.top + this.thumbSize + this.thumbBorder.bottom));
            g2d.fill(new Rectangle(p.x + 2, p.y + this.thumbBorder.top + this.thumbSize + this.thumbBorder.bottom, this.thumbBorder.left + this.thumbSize + this.thumbBorder.right, 2));
            g.setColor(Color.WHITE);
            g2d.fill(new Rectangle(p.x, p.y, this.thumbBorder.left + this.thumbSize + this.thumbBorder.right, this.thumbBorder.top + this.thumbSize + this.thumbBorder.bottom));
            g.setColor(Color.BLACK);
            GraphicsHelper.render(g2d, thumb.getName(), new Rectangle(p.x + this.thumbBorder.left, p.y + this.thumbBorder.top + this.thumbSize, this.thumbSize, this.thumbBorder.bottom), 0.5, 0.5);
            if (thumb == this.selection) {
                g.setColor(Color.BLUE);
                g2d.draw(new Rectangle(p.x, p.y, this.thumbBorder.left + this.thumbSize + this.thumbBorder.right, this.thumbBorder.top + this.thumbSize + this.thumbBorder.bottom));
            }
            if (!thumb.render(g2d, content = new Rectangle(p.x + this.thumbBorder.left, p.y + this.thumbBorder.top, this.thumbSize, this.thumbSize)) && !EXECUTOR_QUEUE.contains(v = new Validation(thumb))) {
                EXECUTOR.execute(v);
            }
            ++col;
            if ((col %= cols) != 0) continue;
            ++row;
        }
    }

    private static Rectangle center(Rectangle a, Rectangle b) {
        return new Rectangle(b.x + (b.width - a.width) / 2, b.y + (b.height - a.height) / 2, a.width, a.height);
    }

    private static Dimension fit(Dimension a, Dimension b) {
        float scale = Math.min((float)b.width / (float)a.width, (float)b.height / (float)a.height);
        return new Dimension((int)((float)a.width * scale), (int)((float)a.height * scale));
    }

    private class All
    extends AbstractAncestrisAction
    implements PropertyChangeListener {
        public All() {
            this.setImage(IMG_ZOOM_ALL);
            this.setEnabled(false);
            ThumbnailWidget.this.addPropertyChangeListener("content", this);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ThumbnailWidget.this.showAll();
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            this.setEnabled(!ThumbnailWidget.this.thumbs.isEmpty());
        }
    }

    private class One
    extends AbstractAncestrisAction
    implements PropertyChangeListener {
        public One() {
            this.setText("1:1");
            this.setEnabled(false);
            ThumbnailWidget.this.addPropertyChangeListener("selection", this);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ThumbnailWidget.this.showOne();
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            this.setEnabled(ThumbnailWidget.this.selection != null);
        }
    }

    private class Fit
    extends AbstractAncestrisAction
    implements PropertyChangeListener {
        public Fit() {
            this.setImage(IMG_ZOOM_FIT);
            this.setEnabled(false);
            ThumbnailWidget.this.addPropertyChangeListener("selection", this);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ThumbnailWidget.this.showSelection();
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            this.setEnabled(ThumbnailWidget.this.selection != null);
        }
    }

    private class Thumbnail
    implements IIOReadUpdateListener {
        private InputSource source;
        private SoftReference<Image> image;
        private Dimension size = new Dimension();
        private final Dimension imageSize = new Dimension();
        private final Rectangle imageView = new Rectangle();
        private final Rectangle renderDest = new Rectangle();
        private final Rectangle renderSource = new Rectangle();

        public Thumbnail(InputSource source) {
            this.source = source;
            this.image = new SoftReference<Object>(null);
            this.validate();
        }

        String getName() {
            return this.source.getName();
        }

        InputSource getSource() {
            return this.source;
        }

        private synchronized boolean isValid() {
            if (this.image.get() == null) {
                return false;
            }
            return (this.imageSize.width >= this.size.width || this.imageSize.width >= this.renderDest.width) && (this.imageSize.height >= this.size.height || this.imageSize.height >= this.renderDest.height);
        }

        synchronized boolean render(Graphics2D g, Rectangle bounds) {
            this.renderDest.setBounds(bounds);
            if (!g.getClipBounds().intersects(this.renderDest)) {
                return true;
            }
            if (this.size.width <= 0 || this.size.height <= 0) {
                return false;
            }
            this.renderSource.setBounds(0, 0, this.size.width, this.size.width);
            Image img = this.image.get();
            if (img == null || this.imageSize.width == 0 || this.imageSize.height == 0) {
                return false;
            }
            bounds = ThumbnailWidget.center(new Rectangle(ThumbnailWidget.fit(this.size, bounds.getSize())), bounds);
            Shape clip = g.getClip();
            g.clip(bounds);
            this.draw(img, g, bounds.x, bounds.y, bounds.width, bounds.height, 0.0f, 0.0f, this.imageSize.width, this.imageSize.height);
            g.setClip(clip);
            return this.isValid();
        }

        void draw(Image img, Graphics2D g, float sx, float sy, float sw, float sh, float dx, float dy, float dw, float dh) {
            g.drawImage(img, (int)sx, (int)sy, (int)(sx + sw), (int)(sy + sh), (int)dx, (int)dy, (int)(dx + dw), (int)(dy + dh), null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        final void validate() {
            if (this.isValid()) {
                return;
            }
            LOG.finer("Loading " + this.source.getName());
            Thumbnail thumbnail = this;
            synchronized (thumbnail) {
                this.size = MediaRenderer.getSize(this.source);
                if (this.renderSource.width == 0 || this.renderSource.height == 0) {
                    return;
                }
            }
            Optional<BufferedImage> imageRead = MediaRenderer.getScaleImage(this.source, this.renderDest.width, this.renderDest.height);
            if (imageRead.isPresent()) {
                Image img = imageRead.get();
                Thumbnail thumbnail2 = this;
                synchronized (thumbnail2) {
                    this.image = new SoftReference<Image>(img);
                    this.imageSize.setSize(img.getWidth(null), img.getHeight(null));
                }
            }
            Thumbnail thumbnail3 = this;
            synchronized (thumbnail3) {
                Image i = ThumbnailWidget.this.getFallback(this.source);
                this.image = new SoftReference<Image>(i);
                this.size.setSize(i.getWidth(null), i.getHeight(null));
                this.imageSize.setSize(this.size);
                this.imageView.setBounds(0, 0, this.size.width, this.size.height);
            }
            ThumbnailWidget.this.repaint.stop();
            ThumbnailWidget.this.repaint();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public synchronized void imageUpdate(ImageReader source, BufferedImage img, int minX, int minY, int width, int height, int periodX, int periodY, int[] bands) {
            if (this.image.get() == null) {
                Thumbnail thumbnail = this;
                synchronized (thumbnail) {
                    this.image = new SoftReference<BufferedImage>(img);
                    this.imageSize.setSize(img.getWidth(null), img.getHeight(null));
                    ThumbnailWidget.this.repaint.start();
                }
            }
        }

        @Override
        public void passComplete(ImageReader source, BufferedImage theImage) {
        }

        @Override
        public void passStarted(ImageReader source, BufferedImage theImage, int pass, int minPass, int maxPass, int minX, int minY, int periodX, int periodY, int[] bands) {
        }

        @Override
        public void thumbnailPassComplete(ImageReader source, BufferedImage theThumbnail) {
        }

        @Override
        public void thumbnailPassStarted(ImageReader source, BufferedImage theThumbnail, int pass, int minPass, int maxPass, int minX, int minY, int periodX, int periodY, int[] bands) {
        }

        @Override
        public void thumbnailUpdate(ImageReader source, BufferedImage theThumbnail, int minX, int minY, int width, int height, int periodX, int periodY, int[] bands) {
        }
    }

    class Validation
    implements Runnable {
        private Thumbnail thumb;

        Validation(Thumbnail thumb) {
            this.thumb = thumb;
        }

        @Override
        public void run() {
            this.thumb.validate();
        }

        public boolean equals(Object obj) {
            return obj instanceof Validation ? ((Validation)obj).thumb == this.thumb : false;
        }

        public int hashCode() {
            return this.thumb.hashCode();
        }
    }

    private class EventHandler
    extends MouseAdapter
    implements MouseWheelListener,
    DropTargetListener {
        private final Point start = new Point();

        private EventHandler() {
        }

        @Override
        public void mouseWheelMoved(MouseWheelEvent e) {
            if (e.isControlDown()) {
                Point mouse = e.getPoint();
                Dimension dim = ThumbnailWidget.this.getDimension();
                double x = (double)(mouse.x - ((ThumbnailWidget)ThumbnailWidget.this).topLeft.x) / (double)dim.width;
                double y = (double)(mouse.y - ((ThumbnailWidget)ThumbnailWidget.this).topLeft.y) / (double)dim.height;
                ThumbnailWidget.this.thumbSize = Math.max(Math.min(ThumbnailWidget.this.getShowAllThumbSize(), ThumbnailWidget.this.getMinThumbSize()), ThumbnailWidget.this.thumbSize - e.getWheelRotation() * Math.max(32, ThumbnailWidget.this.thumbSize / 2));
                dim = ThumbnailWidget.this.getDimension();
                ThumbnailWidget.this.scrollTo(-((int)(x * (double)dim.width - (double)mouse.x)), -((int)(y * (double)dim.height - (double)mouse.y)));
                return;
            }
            if (e.isShiftDown()) {
                ThumbnailWidget.this.scrollTo(((ThumbnailWidget)ThumbnailWidget.this).topLeft.x - ThumbnailWidget.this.getWidth() * e.getWheelRotation(), ((ThumbnailWidget)ThumbnailWidget.this).topLeft.y);
            } else {
                ThumbnailWidget.this.scrollTo(((ThumbnailWidget)ThumbnailWidget.this).topLeft.x, ((ThumbnailWidget)ThumbnailWidget.this).topLeft.y -= ThumbnailWidget.this.getHeight() * e.getWheelRotation());
            }
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            ThumbnailWidget.this.setCursor(Cursor.getPredefinedCursor(12));
            ThumbnailWidget.this.scrollTo(((ThumbnailWidget)ThumbnailWidget.this).topLeft.x + (e.getPoint().x - this.start.x), ((ThumbnailWidget)ThumbnailWidget.this).topLeft.y += e.getPoint().y - this.start.y);
            this.start.setLocation(e.getPoint());
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            ThumbnailWidget.this.setCursor(null);
        }

        @Override
        public void mousePressed(MouseEvent e) {
            ThumbnailWidget.this.requestFocusInWindow();
            this.start.setLocation(e.getPoint());
            Thumbnail thumb = ThumbnailWidget.this.getThumb(e.getPoint());
            if (thumb != null) {
                if (ThumbnailWidget.this.selection == thumb && e.isControlDown()) {
                    ThumbnailWidget.this.select(null);
                } else {
                    ThumbnailWidget.this.select(thumb);
                }
            }
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (e.getClickCount() != 2) {
                return;
            }
            Thumbnail thumb = ThumbnailWidget.this.getThumb(e.getPoint());
            if (thumb != null && thumb == ThumbnailWidget.this.selection) {
                ThumbnailWidget.this.showSelection();
            }
        }

        @Override
        public void dragEnter(DropTargetDragEvent dtde) {
            if (dtde.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
                dtde.acceptDrag(dtde.getDropAction());
            } else {
                dtde.rejectDrag();
            }
        }

        @Override
        public void drop(DropTargetDropEvent dtde) {
            try {
                dtde.acceptDrop(dtde.getDropAction());
                ThumbnailWidget.this.handleDrop((List)dtde.getTransferable().getTransferData(DataFlavor.javaFileListFlavor));
                dtde.dropComplete(true);
            }
            catch (Throwable t) {
                dtde.dropComplete(false);
            }
        }

        @Override
        public void dragExit(DropTargetEvent dte) {
        }

        @Override
        public void dragOver(DropTargetDragEvent dtde) {
        }

        @Override
        public void dropActionChanged(DropTargetDragEvent dtde) {
        }
    }
}

