/*
 * Decompiled with CFR 0.152.
 */
package genj.util.swing;

import genj.util.ChangeSupport;
import genj.util.swing.ImageIcon;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionListener;

public class ListSelectionWidget<T>
extends JComponent {
    private JList lChoose;
    private List<T> choices = new ArrayList<T>();
    private Set<T> selection = null;
    private ChangeSupport changes = new ChangeSupport(this);

    public ListSelectionWidget() {
        this.lChoose = new JList();
        this.lChoose.setCellRenderer(new Renderer());
        this.lChoose.setSelectionMode(0);
        this.lChoose.addMouseListener(new SelectionListener());
        this.setLayout(new BorderLayout());
        this.add((Component)new JScrollPane(this.lChoose), "Center");
    }

    public void addChangeListener(ChangeListener listener) {
        this.changes.addChangeListener(listener);
    }

    public void removeChangeListener(ChangeListener listener) {
        this.changes.removeChangeListener(listener);
    }

    @Override
    public synchronized void addMouseListener(MouseListener l) {
        this.lChoose.addMouseListener(l);
    }

    @Override
    public synchronized void removeMouseListener(MouseListener l) {
        this.lChoose.removeMouseListener(l);
    }

    public T getChoice(Point point) {
        int i = this.lChoose.locationToIndex(point);
        return i < 0 || i > this.choices.size() - 1 ? null : (T)this.choices.get(i);
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(64, 64);
    }

    private void update() {
        this.lChoose.setListData(this.choices.toArray(new Object[this.choices.size()]));
        this.changes.fireChangeEvent();
    }

    public void addChoice(T choice) {
        this.choices.add(choice);
        this.update();
    }

    public void removeChoice(T choice) {
        this.choices.remove(choice);
        this.update();
    }

    public List<T> getChoices() {
        return Collections.unmodifiableList(this.choices);
    }

    public void setChoices(T[] set) {
        this.choices.clear();
        this.choices.addAll(Arrays.asList(set));
        this.update();
    }

    public void setChoices(Collection<T> c) {
        this.choices = new ArrayList<T>(c);
        this.update();
    }

    public void setCheckedChoices(Set<T> set) {
        this.selection = new HashSet<T>(set);
        for (T t : set) {
            if (this.choices.contains(t)) continue;
            this.choices.add(t);
        }
        this.update();
    }

    public Set<T> getCheckedChoices() {
        if (this.selection == null) {
            this.selection = new HashSet<T>();
        }
        return Collections.unmodifiableSet(this.selection);
    }

    public T getSelectedChoice() {
        return (T)this.lChoose.getSelectedValue();
    }

    public int getSelectedIndex() {
        return this.lChoose.getSelectedIndex();
    }

    public void swapChoices(int i, int j) {
        int selected = this.lChoose.getSelectedIndex();
        T o = this.choices.get(i);
        this.choices.set(i, this.choices.get(j));
        this.choices.set(j, o);
        this.update();
        if (selected == i) {
            this.lChoose.setSelectedIndex(j);
        }
        if (selected == j) {
            this.lChoose.setSelectedIndex(i);
        }
    }

    public void down() {
        int row = this.lChoose.getSelectedIndex();
        if (row == -1 || row == this.choices.size() - 1) {
            return;
        }
        T o = this.choices.get(row);
        this.choices.set(row, this.choices.get(row + 1));
        this.choices.set(row + 1, o);
        this.update();
        this.lChoose.setSelectedIndex(row + 1);
    }

    protected String getText(T choice) {
        return choice.toString();
    }

    protected ImageIcon getIcon(T choice) {
        return null;
    }

    public void addSelectionListener(ListSelectionListener listener) {
        this.lChoose.addListSelectionListener(listener);
    }

    public void removeSelectionListener(ListSelectionListener listener) {
        this.lChoose.removeListSelectionListener(listener);
    }

    private class SelectionListener
    extends MouseAdapter {
        private SelectionListener() {
        }

        @Override
        public void mousePressed(MouseEvent me) {
            if (ListSelectionWidget.this.selection == null) {
                return;
            }
            int pos = ListSelectionWidget.this.lChoose.locationToIndex(me.getPoint());
            if (pos == -1) {
                return;
            }
            Object choice = ListSelectionWidget.this.choices.get(pos);
            if (!ListSelectionWidget.this.selection.remove(choice)) {
                ListSelectionWidget.this.selection.add(choice);
            }
            ListSelectionWidget.this.lChoose.repaint(ListSelectionWidget.this.lChoose.getCellBounds(pos, pos));
            ListSelectionWidget.this.changes.fireChangeEvent();
        }
    }

    private class Renderer
    extends DefaultListCellRenderer {
        private JPanel panel = new JPanel();
        private JCheckBox check = new JCheckBox();

        private Renderer() {
            this.check.setOpaque(false);
            this.panel.setOpaque(true);
            this.panel.setLayout(new BorderLayout());
            this.panel.add((Component)this.check, "West");
            this.panel.add((Component)this, "Center");
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            this.setText(ListSelectionWidget.this.getText(value));
            this.setIcon(ListSelectionWidget.this.getIcon(value));
            if (ListSelectionWidget.this.selection == null) {
                return this;
            }
            this.panel.setBackground(super.getBackground());
            this.check.setSelected(ListSelectionWidget.this.selection.contains(value));
            return this.panel;
        }
    }
}

