/*
 * Decompiled with CFR 0.152.
 */
package genj.renderer;

import ancestris.core.actions.AbstractAncestrisAction;
import ancestris.util.swing.DialogManager;
import genj.gedcom.Entity;
import genj.gedcom.Gedcom;
import genj.renderer.Blueprint;
import genj.renderer.BlueprintEditor;
import genj.renderer.BlueprintManager;
import genj.util.Resources;
import genj.util.swing.ButtonHelper;
import genj.util.swing.ImageIcon;
import genj.util.swing.NestedBlockLayout;
import java.awt.event.ActionEvent;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.openide.util.NbBundle;

public abstract class ChooseBlueprintAction
extends AbstractAncestrisAction {
    private static final Resources RESOURCES = Resources.get(ChooseBlueprintAction.class);
    private static final ImageIcon IMAGE = new ImageIcon(ChooseBlueprintAction.class, "Blueprint.png");
    private static final BlueprintManager MGR = BlueprintManager.getInstance();
    private Entity recipient;
    private Blueprint current;
    private JList blueprints;
    private BlueprintEditor editor;

    protected ChooseBlueprintAction(Entity recipient, Blueprint current) {
        if (recipient == null) {
            throw new IllegalArgumentException("recipient==null");
        }
        this.recipient = recipient;
        this.current = current;
        this.setText(RESOURCES.getString("blueprint.select.for", Gedcom.getName(recipient.getTag(), true)));
        this.setImage(IMAGE.getOverLayed(recipient.getImage(false)));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.editor = new BlueprintEditor(this.recipient);
        this.blueprints = new JList<Object>(BlueprintManager.getInstance().getBlueprints(this.recipient.getTag()).toArray());
        this.blueprints.setSelectionMode(0);
        Add add = new Add();
        final Del del = new Del();
        this.blueprints.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                Blueprint selection;
                String msg;
                String title;
                if (ChooseBlueprintAction.this.editor.isChanged() && DialogManager.YES_OPTION == DialogManager.createYesNo(title = NbBundle.getMessage(this.getClass(), (String)"TITL_BluePrintEditor"), msg = NbBundle.getMessage(this.getClass(), (String)"MSG_ConfirmChange")).setMessageType(2).show()) {
                    ChooseBlueprintAction.this.editor.commit();
                }
                if ((selection = (Blueprint)ChooseBlueprintAction.this.blueprints.getSelectedValue()) == null) {
                    if (ChooseBlueprintAction.this.blueprints.getModel().getSize() > 0) {
                        ChooseBlueprintAction.this.blueprints.setSelectedIndex(e.getFirstIndex());
                    } else {
                        del.setEnabled(false);
                        ChooseBlueprintAction.this.editor.set(null);
                    }
                    return;
                }
                ChooseBlueprintAction.this.editor.set(selection);
                del.setEnabled(!selection.isReadOnly());
            }
        });
        this.blueprints.setSelectedValue(this.current, true);
        JPanel content = new JPanel(new NestedBlockLayout("<col><for gx=\"1\"/><row><col><row><list wy=\"1\" gx=\"1\" gy=\"1\"/></row><row><add/><del/></row></col><col><editor wy=\"1\" wx=\"1\"/></col></row></col>"));
        ButtonHelper bh = new ButtonHelper();
        content.setBorder(BorderFactory.createEmptyBorder(6, 6, 6, 6));
        content.add(new JLabel(RESOURCES.getString("blueprint.select.for", Gedcom.getName(this.recipient.getTag(), true))));
        content.add(new JScrollPane(this.blueprints));
        content.add(bh.create(add));
        content.add(bh.create(del));
        content.add(this.editor);
        if (DialogManager.OK_OPTION == DialogManager.create(RESOURCES.getString("blueprint"), content).setDialogId("genj.renderer.blueprint").setOptionType(2).show()) {
            this.editor.commit();
            this.current = (Blueprint)this.blueprints.getSelectedValue();
            if (this.current != null) {
                this.commit(this.recipient, this.current);
            }
        }
    }

    protected abstract void commit(Entity var1, Blueprint var2);

    private class Del
    extends AbstractAncestrisAction {
        Del() {
            super(RESOURCES.getString("blueprint.del"));
            this.setEnabled(false);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Blueprint selection = (Blueprint)ChooseBlueprintAction.this.blueprints.getSelectedValue();
            if (selection == null || selection.isReadOnly()) {
                return;
            }
            if (DialogManager.create((String)null, RESOURCES.getString("blueprint.del.confirm", selection.getDisplayName())).setMessageType(2).setOptionType(2).show() != DialogManager.OK_OPTION) {
                return;
            }
            try {
                MGR.delBlueprint(selection);
            }
            catch (Exception ex) {
                Logger.getLogger("ancestris.renderer").log(Level.WARNING, "can't delete blueprint " + selection, ex);
                MGR.showError("", "blueprint.error.del", ex);
            }
            ChooseBlueprintAction.this.blueprints.setListData(MGR.getBlueprints(ChooseBlueprintAction.this.recipient.getTag()).toArray());
            if (ChooseBlueprintAction.this.blueprints.getModel().getSize() > 0) {
                ChooseBlueprintAction.this.blueprints.setSelectedIndex(0);
            }
        }
    }

    private class Add
    extends AbstractAncestrisAction {
        Add() {
            super(RESOURCES.getString("blueprint.add"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Blueprint selection = (Blueprint)ChooseBlueprintAction.this.blueprints.getSelectedValue();
            String name = DialogManager.create(null, RESOURCES.getString("blueprint.add.confirm"), "").show();
            name = MGR.name2key(name);
            if (name == null || name.length() == 0) {
                MGR.showError("", "blueprint.error.add", null);
                return;
            }
            String html = selection != null ? selection.getHTML() : "";
            try {
                String key = name;
                Blueprint blueprint = MGR.addBlueprint(new Blueprint(ChooseBlueprintAction.this.recipient.getTag(), key, name, html, false));
                ChooseBlueprintAction.this.blueprints.setListData(MGR.getBlueprints(ChooseBlueprintAction.this.recipient.getTag()).toArray());
                ChooseBlueprintAction.this.blueprints.setSelectedValue(blueprint, true);
            }
            catch (Exception ex) {
                Logger.getLogger("ancestris.renderer").log(Level.WARNING, "can't add blueprint " + name, ex);
                MGR.showError("", "blueprint.error.add", ex);
            }
        }
    }
}

