/*
 * Decompiled with CFR 0.152.
 */
package genj.io;

import genj.io.input.ByteInput;
import genj.io.input.FileInput;
import genj.io.input.URLInput;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Optional;

public abstract class InputSource {
    private final String name;
    private String location;

    protected InputSource(String name) {
        this.name = name;
    }

    public final String getName() {
        return this.name;
    }

    public final String getLocation() {
        return this.location;
    }

    protected final void setLocation(String loc) {
        this.location = loc;
    }

    public abstract InputStream open() throws IOException;

    public abstract String getExtension();

    public static Optional<InputSource> get(File file) {
        if (file == null) {
            return Optional.empty();
        }
        return InputSource.get(file.getName(), file);
    }

    public static Optional<InputSource> get(String name, File file) {
        if (file == null) {
            return Optional.empty();
        }
        return Optional.of(new FileInput(name, file));
    }

    public static Optional<InputSource> get(String name, byte[] bytes) {
        if (bytes == null) {
            return Optional.empty();
        }
        return Optional.of(new ByteInput(name, bytes));
    }

    public static Optional<InputSource> get(URL url) {
        if (url == null) {
            return Optional.empty();
        }
        return InputSource.get(url.getFile(), url);
    }

    public static Optional<InputSource> get(String name, URL url) {
        if (url == null) {
            return Optional.empty();
        }
        return Optional.of(new URLInput(name, url));
    }
}

