/*
 * Decompiled with CFR 0.152.
 */
package genj.gedcom;

import genj.gedcom.Gedcom;
import genj.gedcom.GedcomOptions;
import genj.gedcom.Grammar;
import genj.gedcom.Property;
import genj.gedcom.TagPath;
import genj.io.InputSource;
import genj.io.input.FileInput;
import genj.io.input.URLInput;
import genj.util.swing.ImageIcon;
import java.awt.Desktop;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;

public class PropertyFile
extends Property {
    private static final Logger LOG = Logger.getLogger("ancestris.app");
    public static final ImageIcon DEFAULT_IMAGE = Grammar.V55.getMeta(new TagPath("INDI:OBJE:FILE")).getImage();
    private String file;
    private boolean forceRelative = true;
    private boolean isLocal = true;
    private boolean isRemote = false;
    private Optional<InputSource> input = Optional.empty();

    public PropertyFile(String tag) {
        super(tag);
    }

    public boolean isIsLocal() {
        return this.isLocal;
    }

    public boolean isIsRemote() {
        return this.isRemote;
    }

    @Override
    public boolean addFile(InputSource file) {
        this.setValue(file.getLocation(), true);
        return true;
    }

    @Override
    public String getValue() {
        String relative;
        Gedcom gedcom;
        if (this.file == null) {
            return "";
        }
        if (this.forceRelative && (gedcom = this.getGedcom()) != null && (relative = gedcom.getOrigin().calcRelativeLocation(this.file)) != null) {
            this.file = relative;
        }
        return this.file;
    }

    @Override
    public synchronized void setValue(String value) {
        String old = this.getValue();
        this.file = value.replace('\\', '/');
        this.forceRelative = true;
        Gedcom gedcom = this.getGedcom();
        File fichier = new File(value);
        if (fichier.exists()) {
            this.isLocal = true;
            this.isRemote = false;
        } else {
            try {
                URL remote = new URL(value);
                this.isRemote = true;
                this.isLocal = false;
            }
            catch (MalformedURLException mfue) {
                LOG.log(Level.FINEST, "URL exception.", mfue.getLocalizedMessage());
                this.isRemote = false;
                this.isLocal = true;
            }
        }
        this.forceInput();
        this.propagatePropertyChanged(this, old);
    }

    public synchronized void setValueAsIs(String value) {
        String old = this.getValue();
        this.file = value.replace('\\', '/');
        this.forceRelative = false;
        this.propagatePropertyChanged(this, old);
    }

    public void setValue(String value, boolean updateMeta) {
        Property form;
        this.setValue(value);
        Property media = this.getParent();
        if (!updateMeta || !media.getTag().equals("OBJE")) {
            return;
        }
        Property parent = this;
        if (!this.getMetaProperty().allows("FORM")) {
            if (!media.getMetaProperty().allows("FORM")) {
                return;
            }
            parent = media;
        }
        if ((form = parent.getProperty("FORM", false)) == null) {
            parent.addProperty("FORM", this.getSuffix());
        } else {
            form.setValue(this.getSuffix());
        }
    }

    private File getFile() {
        Gedcom gedcom = this.getGedcom();
        return gedcom != null ? gedcom.getOrigin().getFile(this.file) : null;
    }

    public Optional<InputSource> getInput() {
        if (this.input.isPresent()) {
            return this.input;
        }
        this.forceInput();
        return this.input;
    }

    private void forceInput() {
        File fichier = this.getFile();
        if (fichier != null && fichier.exists()) {
            this.isLocal = true;
            this.isRemote = false;
            this.input = InputSource.get(fichier);
            return;
        }
        if (this.isRemote) {
            try {
                this.input = InputSource.get(new URL(this.file));
                return;
            }
            catch (MalformedURLException mfue) {
                LOG.log(Level.FINEST, "URL exception.", mfue);
            }
        }
        this.input = Optional.empty();
    }

    public static int getMaxValueAsIconSize(boolean kb) {
        return (kb ? 1 : 1024) * GedcomOptions.getInstance().getMaxImageFileSizeKB();
    }

    public String getSuffix() {
        this.getInput();
        if (this.input.isPresent()) {
            return this.input.get().getExtension();
        }
        return PropertyFile.getSuffix(this.file);
    }

    private static String getSuffix(String value) {
        int j;
        int i;
        String result = "";
        if (value != null && (i = value.lastIndexOf(46)) >= 0 && (j = (result = value.substring(i + 1)).indexOf(63)) > 0) {
            result = result.substring(0, j);
        }
        return result;
    }

    @Override
    public void executeDefaultAction() {
        Optional<InputSource> oInput = this.getInput();
        if (!oInput.isPresent()) {
            return;
        }
        InputSource inputSource = oInput.get();
        if (inputSource instanceof FileInput) {
            try {
                Desktop.getDesktop().open(((FileInput)inputSource).getFile());
            }
            catch (IOException ex) {
                LOG.log(Level.FINE, "Unable to open File", ex);
            }
        }
        if (inputSource instanceof URLInput) {
            try {
                Desktop.getDesktop().browse(((URLInput)inputSource).getURL().toURI());
            }
            catch (IOException | URISyntaxException ex) {
                LOG.log(Level.FINE, "Unable to open File", ex);
            }
        }
    }
}

