/*
 * Decompiled with CFR 0.152.
 */
package genj.gedcom;

import genj.gedcom.Entity;
import genj.gedcom.Gedcom;
import genj.gedcom.MultiLineProperty;
import genj.gedcom.Property;
import genj.gedcom.PropertyMultilineValue;
import java.util.List;
import java.util.regex.Pattern;

public class Note
extends Entity
implements MultiLineProperty {
    private PropertyMultilineValue delegate;

    public Note(String tag, String id) {
        super(tag, id);
        this.assertTag("NOTE");
    }

    @Override
    public boolean isValid() {
        return true;
    }

    @Override
    public void moveEntityValue() {
    }

    @Override
    void addNotify(Gedcom ged) {
        super.addNotify(ged);
        if (this.delegate == null) {
            this.delegate = (PropertyMultilineValue)this.addProperty("NOTE", "");
            this.delegate.isTransient = true;
        }
    }

    public PropertyMultilineValue getDelegate() {
        if (this.delegate == null) {
            this.delegate = (PropertyMultilineValue)this.addProperty("NOTE", "");
            this.delegate.isTransient = true;
        }
        return this.delegate;
    }

    @Override
    protected String getToStringPrefix(boolean showIds) {
        return this.getDelegate().getDisplayValue();
    }

    @Override
    public String getDisplayTitle() {
        int cut;
        int len;
        int maxLen = 30;
        String str = this.getDisplayValue().trim();
        if (!str.isEmpty() && maxLen != 0 && (len = str.length()) > maxLen && (cut = str.indexOf(" ", maxLen)) != -1) {
            str = str.substring(0, cut);
        }
        if (str.isEmpty()) {
            str = this.getPropertyName();
        }
        return this.getId() + " - " + str;
    }

    @Override
    public void setValue(String newValue) {
        this.getDelegate().setValue(newValue);
    }

    @Override
    public void delProperty(Property which) {
        if (which != this.getDelegate()) {
            super.delProperty(which);
        }
    }

    @Override
    Property addProperty(Property which, int pos) {
        if (which instanceof PropertyMultilineValue && this.delegate != null) {
            this.delegate.setValue(this.delegate.getValue() + which.getValue());
            return this.delegate;
        }
        return super.addProperty(which, pos);
    }

    @Override
    public String getValue() {
        return this.getDelegate().getValue();
    }

    @Override
    public List<Property> findProperties(Pattern tag, Pattern value) {
        List<Property> result = super.findProperties(tag, value);
        result.remove(this);
        return result;
    }

    @Override
    public MultiLineProperty.Iterator getLineIterator() {
        return this.getDelegate().getLineIterator();
    }

    @Override
    public MultiLineProperty.Collector getLineCollector() {
        return this.getDelegate().getLineCollector();
    }

    @Override
    public boolean isPrivate() {
        return this.getDelegate().isPrivate();
    }

    @Override
    public void setPrivate(boolean set, boolean recursively) {
        this.getDelegate().setPrivate(set, recursively);
    }
}

