/*
 * Decompiled with CFR 0.152.
 */
package ancestris.util;

import genj.gedcom.Entity;
import genj.gedcom.Fam;
import genj.gedcom.Gedcom;
import genj.gedcom.Indi;
import genj.gedcom.Property;
import genj.gedcom.PropertyXRef;
import genj.gedcom.Repository;
import genj.gedcom.Source;
import genj.gedcom.TagPath;
import java.awt.Cursor;
import java.awt.Frame;
import java.awt.Image;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.util.Collection;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Clip;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.text.Document;
import javax.swing.text.EditorKit;
import javax.swing.text.html.HTMLEditorKit;
import org.openide.util.Lookup;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

public class Utilities {
    private static int margin = 10;
    private static String bit = "...";

    public static String getClassName(Object o) {
        return Utilities.getClassName(o.getClass());
    }

    public static String getClassName(Class c) {
        return c.getName().replace('.', '/');
    }

    public static boolean wordsMatch(String text, String pattern) {
        pattern = pattern.replaceAll(" +", ".+");
        return text.matches(".*" + pattern + ".*");
    }

    public static Locale getLocaleFromString(String str) {
        if (str == null || str.length() == 0) {
            return null;
        }
        str.replaceAll(":", "_");
        String[] locale = (str + "__").split("_", 3);
        return new Locale(locale[0], locale[1], locale[2]);
    }

    public static String ctxPropertiesDisplayName() {
        Collection properties = org.openide.util.Utilities.actionsGlobalContext().lookupAll(Property.class);
        String result = "";
        if (properties != null) {
            result = "'" + Property.getPropertyNames(properties, 5) + "' (" + properties.size() + ")";
        }
        return result;
    }

    public static String ctxPropertyDisplayName() {
        Property prop = (Property)org.openide.util.Utilities.actionsGlobalContext().lookup(Property.class);
        String result = "";
        if (prop != null) {
            result = Property.LABEL + " '" + TagPath.get(prop).getName() + '\'';
        }
        return result;
    }

    public static String ctxEntityDisplayName() {
        Entity entity = (Entity)org.openide.util.Utilities.actionsGlobalContext().lookup(Entity.class);
        String result = "";
        if (entity != null) {
            result = Gedcom.getName(entity.getTag(), false) + " '" + entity.getId() + '\'';
        }
        return result;
    }

    public static String ctxGedcomDisplayName() {
        Property prop;
        Gedcom gedcom = (Gedcom)org.openide.util.Utilities.actionsGlobalContext().lookup(Gedcom.class);
        if (gedcom == null && (prop = (Property)org.openide.util.Utilities.actionsGlobalContext().lookup(Property.class)) != null) {
            gedcom = prop.getGedcom();
        }
        String result = "";
        if (gedcom != null) {
            result = "Gedcom '" + gedcom.getName() + '\'';
        }
        return result;
    }

    public static Image getDN() {
        Property prop = (Property)org.openide.util.Utilities.actionsGlobalContext().lookup(Property.class);
        if (prop != null) {
            return prop.getImage(false).getImage();
        }
        return null;
    }

    public static Gedcom getGedcomFromContext(Lookup lookup) {
        Property prop;
        Gedcom gedcom = (Gedcom)lookup.lookup(Gedcom.class);
        if (gedcom == null && (prop = (Property)lookup.lookup(Property.class)) != null) {
            gedcom = prop.getGedcom();
        }
        return gedcom;
    }

    public static String html2text(String html) {
        HTMLEditorKit kit = new HTMLEditorKit();
        Document doc = ((EditorKit)kit).createDefaultDocument();
        doc.putProperty("IgnoreCharsetDirective", Boolean.TRUE);
        try {
            StringReader reader = new StringReader(html);
            ((EditorKit)kit).read(reader, doc, 0);
            return doc.getText(0, doc.getLength());
        }
        catch (Exception e) {
            return "";
        }
    }

    public static String getPhraseBit(String text, String find) {
        int i;
        String q;
        String str = (text = text.replaceAll("(?:\\n|\\r)", " ")).toLowerCase();
        int index = str.indexOf(q = find.toLowerCase());
        if (index == -1) {
            return null;
        }
        int start = Math.max(index - margin, 0);
        int end = Math.min(text.length(), index + q.length() + margin);
        for (i = start; i >= 0; --i) {
            if (str.charAt(i) != ' ') continue;
            start = i + 1;
            break;
        }
        for (i = end; i < text.length(); ++i) {
            if (str.charAt(i) != ' ') continue;
            end = i;
            break;
        }
        return bit + text.substring(start, end) + bit;
    }

    public static boolean setCursorWaiting(JPanel panel) {
        return Utilities.setCursor(Cursor.getPredefinedCursor(3), panel);
    }

    public static boolean setCursorNormal(JPanel panel) {
        return Utilities.setCursor(Cursor.getDefaultCursor(), panel);
    }

    private static boolean setCursor(Cursor cursor, JPanel panel) {
        boolean changed = false;
        for (Frame frame : Frame.getFrames()) {
            if (!(frame instanceof JFrame) || ((JFrame)frame).getCursor() == cursor) continue;
            ((JFrame)frame).setCursor(cursor);
            changed = true;
        }
        for (TopComponent tc : Lookup.getDefault().lookupAll(TopComponent.class)) {
            if (tc.getCursor() == cursor) continue;
            tc.setCursor(cursor);
            changed = true;
        }
        if (panel != null && panel.getCursor() != cursor) {
            panel.setCursor(cursor);
            changed = true;
        }
        return changed;
    }

    public static Set<Entity> getDependingEntitiesRecursively(Entity entity) {
        HashSet<Entity> entities = new HashSet<Entity>();
        HashSet<Entity> seen = new HashSet<Entity>();
        return Utilities.getDependingEntitiesRecursively(entity, entities, seen);
    }

    private static Set<Entity> getDependingEntitiesRecursively(Entity entity, Set<Entity> entities, Set<Entity> seen) {
        if (seen.contains(entity)) {
            return entities;
        }
        seen.add(entity);
        entities.add(entity);
        for (PropertyXRef xref : entity.getProperties(PropertyXRef.class)) {
            Entity target;
            if (!xref.isValid() || (target = xref.getTargetEntity()) instanceof Indi || entity instanceof Repository && target instanceof Source || !(entity instanceof Indi) && target instanceof Fam) continue;
            entities.add(target);
            entities.addAll(Utilities.getDependingEntitiesRecursively(target, entities, seen));
        }
        return entities;
    }

    public static File getResourceAsFile(Class clazz, String resourcePath, String ext) {
        try {
            int bytesRead;
            InputStream in = clazz.getResourceAsStream(resourcePath);
            if (in == null) {
                return null;
            }
            File tempFile = File.createTempFile(String.valueOf(in.hashCode()), ext);
            tempFile.deleteOnExit();
            FileOutputStream out = new FileOutputStream(tempFile);
            byte[] buffer = new byte[1024];
            while ((bytesRead = in.read(buffer)) != -1) {
                out.write(buffer, 0, bytesRead);
            }
            return tempFile;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void playSound(final Class clazz, final String sound) {
        WindowManager.getDefault().invokeWhenUIReady(new Runnable(){

            @Override
            public void run() {
                try {
                    InputStream is = clazz.getResourceAsStream(sound);
                    AudioInputStream audioInputStream = AudioSystem.getAudioInputStream(is);
                    Clip clip = AudioSystem.getClip();
                    clip.open(audioInputStream);
                    clip.start();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        });
    }
}

