/*
 * Decompiled with CFR 0.152.
 */
package ancestris.gedcom;

import genj.gedcom.Entity;
import genj.gedcom.Fam;
import genj.gedcom.Gedcom;
import genj.gedcom.Indi;
import genj.gedcom.Note;
import genj.gedcom.Property;
import genj.gedcom.PropertyDate;
import genj.gedcom.PropertyFile;
import genj.gedcom.PropertyXRef;
import genj.gedcom.TagPath;
import genj.gedcom.time.PointInTime;
import genj.io.Filter;
import genj.util.Resources;
import genj.util.swing.ChoiceWidget;
import genj.util.swing.DateWidget;
import genj.util.swing.TextFieldWidget;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;

public class SaveOptionsWidget
extends JTabbedPane {
    private final JCheckBox[] checkEntities = new JCheckBox[Gedcom.ENTITIES.length];
    private JRadioButton checkEntityInclude;
    private JRadioButton checkEntityExclude;
    private TextFieldWidget textEntityTag;
    private JCheckBox[] checkFilters;
    private JTextField textTags;
    private JTextField textValues;
    private TextFieldWidget textPassword;
    private JComboBox comboEncodings;
    private JCheckBox checkFilterEmpties;
    private JCheckBox checkFilterLiving;
    private JCheckBox checkMediaDirectory;
    private final Resources resources = Resources.get(this);
    private DateWidget dateEventsAfter;
    private DateWidget dateBirthsAfter;
    private boolean isGedcom = false;
    private Filter[] filters;

    public SaveOptionsWidget(Gedcom gedcom) {
        this(gedcom, (Filter[])null);
    }

    public SaveOptionsWidget(Gedcom gedcom, Collection<? extends Filter> filters) {
        this(gedcom, filters.toArray(new Filter[0]));
    }

    public SaveOptionsWidget(Filter[] filters) {
        this(null, filters);
    }

    public SaveOptionsWidget(Gedcom gedcom, Filter[] filters) {
        Box types = new Box(1);
        for (int t = 0; t < Gedcom.ENTITIES.length; ++t) {
            this.checkEntities[t] = new JCheckBox(Gedcom.getName(Gedcom.ENTITIES[t], true), true);
            types.add(this.checkEntities[t]);
        }
        types.add(new JLabel(" "));
        types.add(new JLabel(" "));
        ButtonGroup group = new ButtonGroup();
        this.checkEntityInclude = new JRadioButton(this.resources.getString("save.options.entities.include"));
        this.checkEntityInclude.setSelected(true);
        this.checkEntityExclude = new JRadioButton(this.resources.getString("save.options.entities.exclude"));
        group.add(this.checkEntityInclude);
        group.add(this.checkEntityExclude);
        types.add(this.checkEntityInclude);
        types.add(this.checkEntityExclude);
        types.add(new JLabel(this.resources.getString("save.options.entities.tag")));
        this.textEntityTag = new TextFieldWidget("");
        this.textEntityTag.setEditable(true);
        types.add(this.textEntityTag);
        Box props = new Box(1);
        props.add(new JLabel(this.resources.getString("save.options.exclude.tags")));
        this.textTags = new TextFieldWidget(this.resources.getString("save.options.exclude.tags.eg"), 10).setTemplate(true);
        props.add(this.textTags);
        props.add(new JLabel(this.resources.getString("save.options.exclude.values")));
        this.textValues = new TextFieldWidget(this.resources.getString("save.options.exclude.values.eg"), 10).setTemplate(true);
        props.add(this.textValues);
        props.add(new JLabel(this.resources.getString("save.options.exclude.events")));
        this.dateEventsAfter = new DateWidget();
        props.add(this.dateEventsAfter);
        props.add(new JLabel(this.resources.getString("save.options.exclude.indis")));
        this.dateBirthsAfter = new DateWidget();
        props.add(this.dateBirthsAfter);
        this.checkFilterLiving = new JCheckBox(this.resources.getString("save.options.exclude.living"));
        props.add(this.checkFilterLiving);
        this.checkFilterEmpties = new JCheckBox(this.resources.getString("save.options.exclude.empties"));
        props.add(this.checkFilterEmpties);
        Box others = new Box(1);
        this.filters = filters;
        if (filters != null) {
            this.checkFilters = new JCheckBox[filters.length];
            for (int i = 0; i < this.checkFilters.length; ++i) {
                this.checkFilters[i] = new JCheckBox(filters[i].getFilterName(), false);
                others.add(this.checkFilters[i]);
            }
        }
        int nbFiles = 0;
        Box directories = new Box(1);
        if (gedcom != null) {
            List<? extends Property> files = gedcom.getPropertiesByClass(PropertyFile.class);
            nbFiles = files.size();
            directories.add(new JLabel(" "));
            this.checkMediaDirectory = new JCheckBox(this.resources.getString("save.options.files.check"));
            directories.add(this.checkMediaDirectory);
            directories.add(new JLabel(" "));
            directories.add(new JLabel(this.resources.getString("save.options.files.label")));
            directories.add(new JLabel(" "));
        }
        Box options = new Box(1);
        if (gedcom != null) {
            this.isGedcom = true;
            options.add(new JLabel(" "));
            options.add(new JLabel(this.resources.getString("save.options.encoding")));
            this.comboEncodings = new ChoiceWidget(Gedcom.ENCODINGS, "UTF-8");
            this.comboEncodings.setEditable(false);
            this.comboEncodings.setSelectedItem(gedcom.getEncoding());
            options.add(this.comboEncodings);
            options.add(new JLabel(" "));
            options.add(new JLabel(this.resources.getString("save.options.password")));
            this.textPassword = new TextFieldWidget(gedcom.hasPassword() ? gedcom.getPassword() : "", 10);
            this.textPassword.setEditable(gedcom.getPassword() != "unknown");
            options.add(this.textPassword);
        }
        this.add(this.resources.getString("save.options.filter.entities"), types);
        this.add(this.resources.getString("save.options.filter.views"), new JScrollPane(others));
        this.add(this.resources.getString("save.options.filter.properties"), props);
        if (gedcom != null && nbFiles > 0) {
            this.add(this.resources.getString("save.options.files"), directories);
        }
        if (gedcom != null) {
            this.add(this.resources.getString("save.options"), options);
        }
    }

    public boolean isIsGedcom() {
        return this.isGedcom;
    }

    public boolean areMediaToBeCopied() {
        return this.checkMediaDirectory.isSelected();
    }

    public String getPassword() {
        return this.textPassword.getText();
    }

    public String getEncoding() {
        return this.comboEncodings.getSelectedItem().toString();
    }

    public Collection<Filter> getFilters() {
        PointInTime birthsAfter;
        PointInTime eventsAfter;
        FilterProperties fp;
        ArrayList<Filter> result = new ArrayList<Filter>(10);
        FilterByType fbt = FilterByType.get(this.checkEntities, this.checkEntityInclude.isSelected(), this.textEntityTag.getText().trim());
        if (fbt != null) {
            result.add(fbt);
        }
        if ((fp = FilterProperties.get(this.textTags.getText(), this.textValues.getText())) != null) {
            result.add(fp);
        }
        if ((eventsAfter = this.dateEventsAfter.getValue()) != null && eventsAfter.isValid()) {
            result.add(new FilterEventsAfter(eventsAfter));
        }
        if ((birthsAfter = this.dateBirthsAfter.getValue()) != null && birthsAfter.isValid()) {
            result.add(new FilterIndividualsBornAfter(birthsAfter));
        }
        if (this.checkFilterLiving.isSelected()) {
            result.add(new FilterLivingIndividuals());
        }
        if (this.checkFilterEmpties.isSelected()) {
            result.add(new FilterEmpties());
        }
        if (this.filters != null) {
            for (int f = 0; f < this.filters.length; ++f) {
                if (!this.checkFilters[f].isSelected()) continue;
                result.add(this.filters[f]);
            }
        }
        return result;
    }

    private static class FilterByType
    implements Filter {
        private Set<String> types = new HashSet<String>();
        private String tag = new String();
        private boolean includes = true;
        private Set<Indi> indis = new HashSet<Indi>();

        private FilterByType() {
        }

        protected static FilterByType get(JCheckBox[] checks, boolean includes, String tag) {
            FilterByType result = new FilterByType();
            for (int t = 0; t < checks.length; ++t) {
                if (!checks[t].isSelected()) continue;
                result.types.add(Gedcom.ENTITIES[t]);
            }
            result.includes = includes;
            result.tag = tag;
            return result.types.size() < Gedcom.ENTITIES.length || !tag.isEmpty() ? result : null;
        }

        @Override
        public boolean veto(Entity ent) {
            if (!this.types.contains(ent.getTag())) {
                return true;
            }
            if (!this.tag.isEmpty()) {
                if (ent instanceof Indi) {
                    return !this.keepIndi(ent);
                }
                if (ent instanceof Fam) {
                    Fam fam = (Fam)ent;
                    boolean father = this.keepIndi(fam.getHusband());
                    boolean mother = this.keepIndi(fam.getWife());
                    boolean child = false;
                    Indi[] children = fam.getChildren();
                    for (int i = 0; !child && i < children.length; ++i) {
                        if (!this.keepIndi(children[i])) continue;
                        child = true;
                    }
                    return !(father && mother || father && child || mother && child);
                }
                if (ent.getGedcom().getSubmitter() == ent) {
                    return !this.includes;
                }
                ArrayList<Entity> allreadyVisited = new ArrayList<Entity>();
                allreadyVisited.add(ent);
                if (this.includes != this.checkRecursiveRef(ent, allreadyVisited)) {
                    return !this.includes;
                }
                return true;
            }
            return false;
        }

        private boolean checkRecursiveRef(Entity root, List<Entity> allreadyVisited) {
            Entity[] refs = PropertyXRef.getReferences(root);
            ArrayList<Entity> ents = new ArrayList<Entity>(refs.length);
            for (Entity ref : refs) {
                if (ref instanceof Indi) {
                    if (!this.keepIndi(ref)) continue;
                    return !this.includes;
                }
                if (allreadyVisited.contains(ref)) continue;
                ents.add(ref);
                allreadyVisited.add(ref);
            }
            for (Entity ref : ents) {
                if (this.includes == this.checkRecursiveRef(ref, allreadyVisited)) continue;
                return !this.includes;
            }
            return this.includes;
        }

        @Override
        public String getFilterName() {
            return this.toString();
        }

        @Override
        public boolean veto(Property property) {
            return false;
        }

        @Override
        public boolean canApplyTo(Gedcom gedcom) {
            return true;
        }

        private boolean keepIndi(Entity ent) {
            if (ent == null) {
                return false;
            }
            boolean hasTag = !ent.getAllProperties(this.tag).isEmpty();
            return hasTag && this.includes || !hasTag && !this.includes;
        }
    }

    private static class FilterProperties
    implements Filter {
        private final Set tags;
        private final Set paths;
        private final String[] values;

        private FilterProperties(Set tags, Set paths, List<String> values) {
            this.tags = tags;
            this.paths = paths;
            this.values = values.toArray(new String[0]);
        }

        protected static FilterProperties get(String sTags, String sValues) {
            HashSet<String> tags = new HashSet<String>();
            HashSet<TagPath> paths = new HashSet<TagPath>();
            StringTokenizer tokens = new StringTokenizer(sTags, ",");
            while (tokens.hasMoreTokens()) {
                String s = tokens.nextToken().trim();
                if (s.indexOf(58) > 0) {
                    try {
                        paths.add(new TagPath(s));
                    }
                    catch (IllegalArgumentException illegalArgumentException) {}
                    continue;
                }
                tags.add(s);
            }
            ArrayList<String> values = new ArrayList<String>();
            tokens = new StringTokenizer(sValues, ",");
            while (tokens.hasMoreTokens()) {
                values.add(tokens.nextToken().trim());
            }
            return tags.isEmpty() && paths.isEmpty() && values.isEmpty() ? null : new FilterProperties(tags, paths, values);
        }

        @Override
        public boolean veto(Property property) {
            if (this.tags.contains(property.getTag())) {
                return true;
            }
            if (this.paths.contains(property.getPath())) {
                return true;
            }
            return !this.accept(property.getValue());
        }

        @Override
        public boolean veto(Entity entity) {
            if (entity instanceof Note) {
                return !this.accept(entity.getValue());
            }
            return false;
        }

        private boolean accept(String value) {
            if (value == null) {
                return true;
            }
            for (String value1 : this.values) {
                if (!value.contains(value1)) continue;
                return false;
            }
            return true;
        }

        @Override
        public String getFilterName() {
            return this.toString();
        }

        @Override
        public boolean canApplyTo(Gedcom gedcom) {
            return true;
        }
    }

    private static class FilterEventsAfter
    implements Filter {
        private final PointInTime after;

        private FilterEventsAfter(PointInTime after) {
            this.after = after;
        }

        @Override
        public boolean veto(Property property) {
            PropertyDate when = property.getWhen();
            return when != null && when.getStart().compareTo(this.after) > 0;
        }

        @Override
        public String getFilterName() {
            return this.toString();
        }

        @Override
        public boolean veto(Entity entity) {
            return false;
        }

        @Override
        public boolean canApplyTo(Gedcom gedcom) {
            return true;
        }
    }

    private static class FilterLivingIndividuals
    implements Filter {
        private FilterLivingIndividuals() {
        }

        @Override
        public boolean veto(Entity indi) {
            if (indi instanceof Indi) {
                return !((Indi)indi).isDeceased();
            }
            return false;
        }

        @Override
        public String getFilterName() {
            return this.toString();
        }

        @Override
        public boolean veto(Property property) {
            return false;
        }

        @Override
        public boolean canApplyTo(Gedcom gedcom) {
            return true;
        }
    }

    private static class FilterIndividualsBornAfter
    implements Filter {
        private final PointInTime after;

        private FilterIndividualsBornAfter(PointInTime after) {
            this.after = after;
        }

        @Override
        public boolean veto(Entity entity) {
            Indi indi;
            PropertyDate birth;
            if (entity instanceof Indi && (birth = (indi = (Indi)entity).getBirthDate()) != null) {
                return birth.getStart().compareTo(this.after) >= 0;
            }
            return false;
        }

        @Override
        public String getFilterName() {
            return this.toString();
        }

        @Override
        public boolean veto(Property property) {
            return false;
        }

        @Override
        public boolean canApplyTo(Gedcom gedcom) {
            return true;
        }
    }

    private static class FilterEmpties
    implements Filter {
        private FilterEmpties() {
        }

        @Override
        public boolean veto(Property property) {
            for (int i = 0; i < property.getNoOfProperties(); ++i) {
                if (this.veto(property.getProperty(i))) continue;
                return false;
            }
            return property.getValue().trim().length() == 0;
        }

        @Override
        public String getFilterName() {
            return this.toString();
        }

        @Override
        public boolean veto(Entity entity) {
            return false;
        }

        @Override
        public boolean canApplyTo(Gedcom gedcom) {
            return true;
        }
    }
}

