/*
 * Decompiled with CFR 0.152.
 */
package ancestris.gedcom;

import ancestris.api.imports.Import;
import ancestris.core.CoreOptions;
import ancestris.core.beans.ConfirmChangeWidget;
import ancestris.core.pluginservice.AncestrisPlugin;
import ancestris.core.pluginservice.PluginInterface;
import ancestris.gedcom.Bundle;
import ancestris.gedcom.GedcomDataObject;
import ancestris.gedcom.GedcomMgr;
import ancestris.gedcom.SaveOptionsWidget;
import ancestris.util.TimingUtility;
import ancestris.util.swing.DialogManager;
import ancestris.util.swing.FileChooserBuilder;
import ancestris.view.AncestrisViewInterface;
import ancestris.view.SelectionDispatcher;
import genj.gedcom.Context;
import genj.gedcom.Gedcom;
import genj.gedcom.GedcomException;
import genj.gedcom.GedcomOptions;
import genj.gedcom.Indi;
import genj.gedcom.Submitter;
import genj.io.Filter;
import genj.io.GedcomFileReader;
import genj.io.GedcomFormatException;
import genj.util.EnvironmentChecker;
import genj.util.Origin;
import genj.util.Registry;
import genj.util.Resources;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyVetoException;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.Timer;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

public abstract class GedcomDirectory {
    static final Logger LOG = Logger.getLogger("ancestris.app");
    static final Resources RES = Resources.get(GedcomDirectory.class);
    static final Registry REGISTRY = Registry.get(GedcomDirectory.class);
    protected List<GedcomRegistryListener> listeners = new ArrayList<GedcomRegistryListener>();
    private static GedcomDirectory defaultInstance;

    public abstract List<Context> getContexts();

    public abstract boolean isGedcomRegistered(Gedcom var1);

    public abstract Context getContext(FileObject var1);

    public abstract GedcomDataObject getDataObject(Context var1) throws ContextNotFoundException;

    protected abstract boolean registerGedcomImpl(GedcomDataObject var1);

    protected abstract boolean unregisterGedcomImpl(Context var1);

    public abstract void setAutosaveDelay();

    public Context newGedcom() {
        return this.newGedcom(null, null, null, true);
    }

    public Context newGedcom(Gedcom gedcomProvided, String title, String defaultFilename, boolean setDefaults) {
        File file = null;
        boolean fileOK = false;
        while (!fileOK) {
            file = new FileChooserBuilder(GedcomDirectory.class).setFilesOnly(true).setDefaultBadgeProvider().setTitle(title).setApproveText(Bundle.create_action()).setDefaultExtension(FileChooserBuilder.getGedcomFilter().getExtensions()[0]).setFileFilter(FileChooserBuilder.getGedcomFilter()).setAcceptAllFileFilterUsed(true).setFileHiding(true).setDefaultWorkingDirectory(new File(EnvironmentChecker.getProperty(new String[]{"ancestris.gedcom.dir", "user.home"}, ".", "choose gedcom file"))).setSelectedFile(new File(defaultFilename + ".ged")).showSaveDialog(false);
            if (file == null) {
                LOG.log(Level.SEVERE, "problem defining the gedcom file in given directory");
                return null;
            }
            if (!file.getName().endsWith(".ged")) {
                file = new File(file.getAbsolutePath() + File.separator + defaultFilename + ".ged");
            }
            if (file.exists()) {
                if (DialogManager.YES_OPTION != DialogManager.createYesNo(title == null ? Bundle.create_title() : title, Bundle.file_exists(file.getName())).setMessageType(2).show()) continue;
                fileOK = true;
                continue;
            }
            fileOK = true;
        }
        Gedcom gedcom = gedcomProvided;
        try {
            if (gedcomProvided == null) {
                gedcom = new Gedcom(Origin.create(file.toURI().toURL()));
            } else {
                gedcom.setOrigin(Origin.create(file.toURI().toURL()));
            }
        }
        catch (MalformedURLException e) {
            LOG.log(Level.SEVERE, "unexpected exception creating new gedcom", e);
            return null;
        }
        Context context = GedcomMgr.getDefault().setGedcom(gedcom);
        try {
            Indi firstIndi;
            if (setDefaults) {
                this.setDefault(gedcom);
            }
            if ((firstIndi = (Indi)context.getGedcom().getFirstEntity("INDI")) == null) {
                firstIndi = (Indi)context.getGedcom().createEntity("INDI");
                firstIndi.addDefaultProperties();
            }
            GedcomMgr.getDefault().saveGedcom(new Context(firstIndi));
            GedcomMgr.getDefault().gedcomClose(context);
            return this.openGedcom(FileUtil.toFileObject((File)file));
        }
        catch (Exception e) {
            Exceptions.printStackTrace((Throwable)e);
            return context;
        }
    }

    private void setDefault(Gedcom gedcom) {
        try {
            Registry submPref = Registry.get(GedcomOptions.class);
            Submitter submitter = (Submitter)gedcom.createEntity("SUBM");
            submitter.setName(submPref.get("submName", ""));
            submitter.setCity(submPref.get("submCity", ""));
            submitter.setPhone(submPref.get("submPhone", ""));
            submitter.setEmail(submPref.get("submEmail", ""));
            submitter.setCountry(submPref.get("submCountry", ""));
            submitter.setWeb(submPref.get("submWeb", ""));
            gedcom.createEntity("HEAD", "");
            gedcom.setPlaceFormat(GedcomOptions.getInstance().getPlaceFormat());
            gedcom.setShowJuridictions(GedcomOptions.getInstance().getShowJuridictions());
            gedcom.setPlaceSortOrder(GedcomOptions.getInstance().getPlaceSortOrder());
            gedcom.setPlaceDisplayFormat(GedcomOptions.getInstance().getPlaceDisplayFormat());
        }
        catch (GedcomException e) {
            Exceptions.printStackTrace((Throwable)e);
        }
    }

    public Context openGedcom() {
        File file = this.chooseFile(RES.getString("cc.open.title"), RES.getString("cc.open.action"), null, false);
        if (file == null) {
            return null;
        }
        REGISTRY.put("last.dir", file.getParentFile().getAbsolutePath());
        return this.openGedcom(FileUtil.toFileObject((File)file));
    }

    @Deprecated
    public Context openGedcom(File input) {
        if (input == null) {
            return null;
        }
        return this.openGedcom(FileUtil.toFileObject((File)input));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Context openGedcom(FileObject foInput) {
        if (foInput == null) {
            LOG.severe("File to open no longer seems to exists");
            return null;
        }
        if (foInput.getName().length() > 75) {
            String error = RES.getString("cc.save.file_too_long") + "\n(" + foInput.getName() + ").";
            LOG.severe(error);
            DialogManager.createError(RES.getString("cc.open.title"), error).show();
            return null;
        }
        String software = "";
        boolean stop = false;
        GedcomFileReader input = null;
        try {
            input = GedcomFileReader.create(new File(foInput.getPath()));
            try {
                while (input.getNextLine(true) != null && !stop) {
                    if (input.getLevel() == 0 && input.getTag().equals("HEAD")) continue;
                    if (input.getLevel() == 1 && input.getTag().equals("SOUR")) {
                        software = input.getValue();
                        if (software.isEmpty()) continue;
                        stop = true;
                    }
                    if (input.getLevel() == 2 && input.getTag().equals("NAME")) {
                        software = input.getValue();
                        stop = true;
                    }
                    if (input.getLevel() != 0 || input.getTag().equals("HEAD")) continue;
                    stop = true;
                }
            }
            finally {
                if (input != null) {
                    input.close();
                }
            }
        }
        catch (GedcomFormatException e) {
            String errLine = input != null ? " - " + input.getLine() : "";
            String errMsg = e.getMessage() + "\n" + NbBundle.getMessage(Import.class, (String)"error.line", (Object)(e.getLine() + errLine));
            JOptionPane.showMessageDialog(null, errMsg);
            LOG.log(Level.SEVERE, errMsg, e);
            return null;
        }
        catch (Exception e) {
            LOG.log(Level.SEVERE, "Error during opening.", e);
            String errLine = input != null ? " - " + input.getLine() : "";
            JOptionPane.showMessageDialog(null, NbBundle.getMessage(Import.class, (String)"error.line", (Object)(e.getMessage() + " : " + errLine)));
            return null;
        }
        if (software.equalsIgnoreCase("ANCESTRIS")) {
            return this.openAncestrisGedcom(foInput);
        }
        Import identifiedImport = null;
        Import defaultImport = null;
        Collection c = Lookup.getDefault().lookupAll(Import.class);
        for (Import o : c) {
            if (o.isGeneric()) {
                defaultImport = o;
            }
            if (o.toString().toLowerCase().contains(software.toLowerCase())) {
                identifiedImport = o;
                break;
            }
            if (!software.toLowerCase().contains(o.toString().toLowerCase())) continue;
            identifiedImport = o;
            break;
        }
        if (identifiedImport == null || software.isEmpty()) {
            identifiedImport = defaultImport;
        }
        if (identifiedImport == null) {
            LOG.info("Opening a non Ancestris file from '" + software + "' and cannot find any import module to be used. Using normal Ancestris file open.");
            return this.openAncestrisGedcom(foInput);
        }
        String dirname = foInput.getParent().getPath() + System.getProperty("file.separator");
        String tmpFileName = foInput.getName() + "_ancestris.ged";
        LOG.info("Opening a non Ancestris file from " + software + ". Asking confirmation to user to use the corresponding import module or not.");
        String message = RES.getString("cc.importGedcom?", foInput.getNameExt(), software, tmpFileName, dirname);
        JButton convertButton = new JButton(RES.getString("cc.button.convert"));
        JButton asisButton = new JButton(RES.getString("cc.button.asis"));
        JButton cancelButton = new JButton(RES.getString("cc.button.cancel"));
        Object[] options = new Object[]{convertButton, asisButton, cancelButton};
        Object rc = DialogManager.create(RES.getString("cc.open.title"), message).setMessageType(2).setOptions(options).show();
        if (rc == cancelButton || rc == DialogManager.CANCEL_OPTION || rc == DialogManager.CLOSED_OPTION) {
            return null;
        }
        if (rc == asisButton) {
            LOG.info("Conversion of file from " + software + " not confirmed by user. Opening file as is.");
            return this.openAncestrisGedcom(foInput);
        }
        LOG.info("Conversion of file from " + software + " confirmed by user.");
        identifiedImport.launch(new File(foInput.getPath()), new File(dirname + tmpFileName));
        return null;
    }

    public Context openAncestrisGedcom(FileObject input) {
        Context context = this.getContext(input);
        if (context != null) {
            return context;
        }
        try {
            DataObject dao = DataObject.find((FileObject)input);
            GedcomDataObject gdao = (GedcomDataObject)dao.getLookup().lookup(GedcomDataObject.class);
            if (gdao == null) {
                return null;
            }
            if (gdao.isCancelled()) {
                gdao.setCancelled(false);
                return null;
            }
            if (gdao.getContext() == null && !gdao.load()) {
                return null;
            }
            this.registerGedcom(gdao);
            context = gdao.getContext();
            if (!GedcomMgr.getDefault().isQuiet()) {
                GedcomDirectory.openDefaultViews(context);
                SelectionDispatcher.fireSelection(context);
            }
            return gdao.getContext();
        }
        catch (Exception e) {
            LOG.info(e.toString());
            return context;
        }
    }

    public boolean saveGedcom(Context context) {
        if (context == null || context.getGedcom() == null) {
            return false;
        }
        if (!(context == null || context.getGedcom().getOrigin() != null && context.getGedcom().getOrigin().getFile().exists())) {
            return this.saveAsGedcom(context, null);
        }
        return GedcomMgr.getDefault().saveGedcom(context);
    }

    public boolean saveAsGedcom(Context context, File outputFile) {
        Origin o;
        if (context == null || context.getGedcom() == null) {
            return false;
        }
        GedcomMgr.getDefault().commitRequested(context);
        ArrayList<Filter> theFilters = new ArrayList<Filter>(5);
        for (Filter f : AncestrisPlugin.lookupAll(Filter.class)) {
            if (!f.canApplyTo(context.getGedcom())) continue;
            theFilters.add(f);
        }
        for (Filter f : Lookup.getDefault().lookupAll(Filter.class)) {
            if (!f.canApplyTo(context.getGedcom())) continue;
            theFilters.add(f);
        }
        SaveOptionsWidget options = new SaveOptionsWidget(context.getGedcom(), theFilters.toArray(new Filter[0]));
        if (outputFile == null) {
            File file = new FileChooserBuilder(GedcomDirectory.class).setDirectoriesOnly(false).setDefaultBadgeProvider().setAccessory(options).setTitle(RES.getString("cc.save.title", context.getGedcom().toString())).setApproveText(RES.getString("cc.save.action")).setDefaultExtension(FileChooserBuilder.getGedcomFilter().getExtensions()[0]).setFileFilter(FileChooserBuilder.getGedcomFilter()).setAcceptAllFileFilterUsed(false).setDefaultWorkingDirectory(new File(EnvironmentChecker.getProperty(new String[]{"ancestris.gedcom.dir", "user.home"}, ".", "choose gedcom file"))).setSelectedFile(context.getGedcom().getOrigin().getFile()).showSaveDialog(false);
            if (file == null) {
                return false;
            }
            if (!file.getName().endsWith(".ged")) {
                file = new File(file.getAbsolutePath() + ".ged");
            }
            if (file.exists()) {
                if (DialogManager.YES_OPTION != DialogManager.createYesNo(RES.getString("cc.save.title", context.getGedcom().toString()), Bundle.file_exists(file.getName())).setMessageType(2).show()) {
                    return false;
                }
            } else {
                try {
                    file.createNewFile();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            outputFile = file;
        }
        if ((o = GedcomMgr.getDefault().saveGedcomAs(context, options, FileUtil.toFileObject((File)outputFile))) == null) {
            return false;
        }
        if (context != null) {
            this.closeGedcom(context);
            this.openAncestrisGedcom(FileUtil.toFileObject((File)o.getFile()));
        }
        return true;
    }

    public boolean closeGedcom(Context context) {
        if (context == null || context.getGedcom() == null) {
            return true;
        }
        try {
            this.getDataObject(context);
            GedcomMgr.getDefault().commitRequested(context);
            if (context.getGedcom().hasChanged() || !context.getGedcom().getOrigin().getFile().exists()) {
                Object rc = DialogManager.create(null, RES.getString("cc.savechanges?", context.getGedcom().getName())).setMessageType(2).setOptionType(1).show();
                if (rc == DialogManager.CANCEL_OPTION || rc == DialogManager.CLOSED_OPTION) {
                    return false;
                }
                if (rc == DialogManager.YES_OPTION && !this.saveGedcom(context)) {
                    return false;
                }
            }
            this.unregisterGedcom(context);
            GedcomMgr.getDefault().gedcomClose(context);
        }
        catch (ContextNotFoundException contextNotFoundException) {
            // empty catch block
        }
        return true;
    }

    public void registerGedcom(GedcomDataObject gedcomObject) {
        if (gedcomObject == null) {
            return;
        }
        if (!this.registerGedcomImpl(gedcomObject)) {
            return;
        }
        ArrayList<GedcomRegistryListener> ls = new ArrayList<GedcomRegistryListener>(this.listeners);
        for (GedcomRegistryListener listener : ls) {
            listener.gedcomRegistered(gedcomObject.getContext());
        }
    }

    public void unregisterGedcom(Context context) {
        if (context == null) {
            return;
        }
        if (!this.unregisterGedcomImpl(context)) {
            return;
        }
        ArrayList<GedcomRegistryListener> ls = new ArrayList<GedcomRegistryListener>(this.listeners);
        for (GedcomRegistryListener listener : ls) {
            listener.gedcomUnregistered(context);
        }
    }

    @Deprecated
    public Context getSelectedContext(boolean firstIfNoneSelected) {
        Context c = (Context)Utilities.actionsGlobalContext().lookup(Context.class);
        return c;
    }

    @Deprecated
    public Context getLastContext() {
        throw new UnsupportedOperationException("GedcomDirectory does not provide last context anymore. use private cache or lookup");
    }

    public File chooseFile(String title, String action, JComponent accessory, boolean create) {
        return this.chooseFile(title, action, accessory, null, create);
    }

    public File chooseFile(String title, String action, JComponent accessory, String defaultFilename, boolean create) {
        FileChooserBuilder fbc = new FileChooserBuilder(GedcomDirectory.class).setDirectoriesOnly(false).setDefaultBadgeProvider().setAccessory(accessory).setTitle(title).setApproveText(action).setDefaultExtension(FileChooserBuilder.getGedcomFilter().getExtensions()[0]).setFileFilter(FileChooserBuilder.getGedcomFilter()).setAcceptAllFileFilterUsed(false).setDefaultWorkingDirectory(new File(EnvironmentChecker.getProperty(new String[]{"ancestris.gedcom.dir", "user.home"}, ".", "choose gedcom file")));
        if (defaultFilename != null) {
            fbc = fbc.setSelectedFile(new File(defaultFilename));
        }
        File file = create ? fbc.showSaveDialog(false) : fbc.showOpenDialog();
        return file;
    }

    public static void openDefaultViews(Context context) {
        Registry reg;
        ArrayList openedViews = new ArrayList();
        Registry gedcomSettings = context.getGedcom().getRegistry();
        String[] ovs = gedcomSettings.get("openViews", (String[])null);
        openedViews.addAll(AncestrisPlugin.lookupForName(AncestrisViewInterface.class, (String[])ovs));
        if (openedViews.isEmpty()) {
            Registry prefs = Registry.get(AncestrisViewInterface.class);
            openedViews.addAll(AncestrisPlugin.lookupForName(AncestrisViewInterface.class, (String[])prefs.get("openViews", (String[])null)));
        }
        if (openedViews.isEmpty()) {
            for (PluginInterface sInterface : Lookup.getDefault().lookupAll(PluginInterface.class)) {
                openedViews.addAll(sInterface.getDefaultOpenedViews());
            }
        }
        TopComponent tc = null;
        HashMap<String, TopComponent> name2tc = new HashMap<String, TopComponent>();
        for (Class clazz : openedViews) {
            LOG.log(Level.FINE, "{0}: {1} opened", new Object[]{TimingUtility.getInstance().getTime(), clazz.getCanonicalName()});
            try {
                tc = (TopComponent)clazz.newInstance();
                if (tc instanceof AncestrisViewInterface) {
                    tc = ((AncestrisViewInterface)tc).create(context);
                }
                tc.open();
                name2tc.put(clazz.getCanonicalName(), tc);
            }
            catch (Exception ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            if (tc == null) continue;
            tc.requestActive();
        }
        for (String name : gedcomSettings.get("focusViews", new String[0])) {
            TopComponent tcToFocus = (TopComponent)name2tc.get(name);
            if (tcToFocus == null) continue;
            tcToFocus.requestActive();
        }
        HashSet<String> modes = new HashSet<String>();
        String absolutePath = EnvironmentChecker.getProperty("user.home.ancestris", "", "");
        if (!absolutePath.isEmpty()) {
            absolutePath = absolutePath + "/../config/Preferences/ancestris/modules/";
            File dir = new File(absolutePath);
            for (File file : FileUtils.listFiles((File)dir, (String[])new String[]{"properties"}, (boolean)true)) {
                if (!file.getAbsolutePath().contains("ancestris-modules")) continue;
                reg = Registry.get(GedcomDirectory.getNodeFromFile(file));
                for (String key : reg.getProperties()) {
                    if (!key.endsWith(".dockMode")) continue;
                    modes.add(reg.get(key, ""));
                }
            }
        }
        if (!(absolutePath = EnvironmentChecker.getProperty("user.home.ancestris", "", "")).isEmpty()) {
            absolutePath = absolutePath + "/../config/Preferences/gedcoms";
            File dir = new File(absolutePath);
            for (File file : FileUtils.listFiles((File)dir, (String[])new String[]{"properties"}, (boolean)true)) {
                reg = Registry.get(GedcomDirectory.getNodeFromFile(file));
                for (String key : reg.getProperties()) {
                    if (!key.endsWith(".dockMode")) continue;
                    modes.add(reg.get(key, ""));
                }
            }
        }
        if (!(absolutePath = EnvironmentChecker.getProperty("user.home.ancestris", "", "")).isEmpty()) {
            absolutePath = absolutePath + "/../config/Windows2Local/Modes/";
            File dir = new File(absolutePath);
            for (File file : dir.listFiles()) {
                String name = FilenameUtils.removeExtension((String)file.getName());
                if (!name.startsWith("anonymousMode") || modes.contains(name)) continue;
                try {
                    if (file.isDirectory()) {
                        FileUtils.deleteDirectory((File)file);
                        continue;
                    }
                    file.delete();
                }
                catch (IOException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
            for (File file : dir.listFiles()) {
                if (!file.isDirectory()) continue;
                GedcomDirectory.keepOneFileOfEachComponent(file);
            }
        }
        if (!(absolutePath = EnvironmentChecker.getProperty("user.home.ancestris", "", "")).isEmpty()) {
            absolutePath = absolutePath + "/../config/Windows2Local/Components/";
            File dir = new File(absolutePath);
            GedcomDirectory.keepOneFileOfEachComponent(dir);
        }
    }

    private static String getNodeFromFile(File file) {
        String filename = file.getAbsolutePath();
        int i = filename.indexOf("Preferences");
        int j = filename.indexOf(".properties");
        String ret = filename.substring(i + 12, j);
        return ret;
    }

    private static String getComponentFromFile(File file) {
        String filename = file.getName();
        String[] split = filename.split("(\\.|\\_)");
        String ret = split[0];
        return ret;
    }

    private static void keepOneFileOfEachComponent(File file) {
        HashSet<String> components = new HashSet<String>();
        for (File componentFile : file.listFiles()) {
            String name = GedcomDirectory.getComponentFromFile(componentFile);
            if (components.contains(name)) {
                componentFile.delete();
                continue;
            }
            components.add(name);
        }
    }

    public void addListener(GedcomRegistryListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(GedcomRegistryListener listener) {
        this.listeners.remove(listener);
    }

    public static GedcomDirectory getDefault() {
        GedcomDirectory gdInstance = (GedcomDirectory)Lookup.getDefault().lookup(GedcomDirectory.class);
        return gdInstance != null ? gdInstance : GedcomDirectory.getDefaultInstance();
    }

    private static synchronized GedcomDirectory getDefaultInstance() {
        if (defaultInstance == null) {
            defaultInstance = new DefaultGedcomDirectoryImpl();
        }
        return defaultInstance;
    }

    private static class DefaultGedcomDirectoryImpl
    extends GedcomDirectory {
        private Map<Gedcom, GedcomDataObject> gedcomsOpened = new HashMap<Gedcom, GedcomDataObject>(5);
        private Map<Gedcom, Timer> gedcomsTimers = new HashMap<Gedcom, Timer>(5);

        private DefaultGedcomDirectoryImpl() {
        }

        @Override
        protected boolean registerGedcomImpl(GedcomDataObject gedcomObject) {
            Gedcom gedcom = gedcomObject.getContext().getGedcom();
            if (!this.gedcomsOpened.containsKey(gedcom)) {
                this.gedcomsOpened.put(gedcom, gedcomObject);
                this.ActivateTopComponent();
                this.setAutoSave(gedcomObject.getContext());
            }
            return true;
        }

        @Override
        protected boolean unregisterGedcomImpl(Context context) {
            GedcomDataObject gdao = this.gedcomsOpened.get(context.getGedcom());
            if (gdao != null) {
                try {
                    gdao.setValid(false);
                }
                catch (PropertyVetoException ex) {
                    return false;
                }
            }
            this.gedcomsOpened.remove(context.getGedcom());
            this.removeAutoSave(context);
            return true;
        }

        @Override
        public Context getContext(FileObject file) {
            if (file == null) {
                return null;
            }
            for (Gedcom g : this.gedcomsOpened.keySet()) {
                if (!file.equals(this.gedcomsOpened.get(g).getPrimaryFile())) continue;
                return this.gedcomsOpened.get(g).getContext();
            }
            return null;
        }

        @Override
        public List<Context> getContexts() {
            ArrayList<Context> result = new ArrayList<Context>();
            for (Gedcom g : this.gedcomsOpened.keySet()) {
                result.add(this.gedcomsOpened.get(g).getContext());
            }
            return result;
        }

        @Override
        public boolean isGedcomRegistered(Gedcom gedcom) {
            for (Gedcom g : this.gedcomsOpened.keySet()) {
                if (g != gedcom) continue;
                return true;
            }
            return false;
        }

        @Override
        public GedcomDataObject getDataObject(Context context) throws ContextNotFoundException {
            if (context == null || context.getGedcom() == null) {
                throw new ContextNotFoundException("No GedcomDAO for context " + context);
            }
            GedcomDataObject dao = this.gedcomsOpened.get(context.getGedcom());
            if (dao == null) {
                throw new ContextNotFoundException("No GedcomDAO for context " + context);
            }
            return dao;
        }

        public void ActivateTopComponent() {
            WindowManager.getDefault().invokeWhenUIReady(new Runnable(){

                @Override
                public void run() {
                    TopComponent tc = WindowManager.getDefault().findTopComponent("CygnusTopComponent");
                    if (tc == null) {
                        tc = WindowManager.getDefault().findTopComponent("AriesTopComponent");
                    }
                    if (tc == null) {
                        tc = WindowManager.getDefault().findTopComponent("GedcomTopComponent");
                    }
                    if (tc != null) {
                        tc.requestActive();
                    }
                }
            });
        }

        @Override
        public void setAutosaveDelay() {
            for (Context context : this.getContexts()) {
                this.setAutoSave(context);
            }
        }

        private void setAutoSave(Context context) {
            int min = CoreOptions.getInstance().getMinAutosave();
            Timer timer = this.gedcomsTimers.get(context.getGedcom());
            if (timer == null && min != 0) {
                timer = this.getNewTimer(min, context);
                this.gedcomsTimers.put(context.getGedcom(), timer);
                timer.start();
            } else if (timer != null && min != 0) {
                timer.setDelay(min * 1000 * 60);
                timer.start();
            } else if (timer != null && min == 0) {
                timer.stop();
            }
        }

        private void removeAutoSave(Context context) {
            Timer timer = this.gedcomsTimers.get(context.getGedcom());
            if (timer != null) {
                timer.stop();
            }
        }

        private Timer getNewTimer(int min, final Context context) {
            Timer timer = new Timer(min * 1000 * 60, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    for (ConfirmChangeWidget.ConfirmChangeCallBack widget : AncestrisPlugin.lookupAll(ConfirmChangeWidget.ConfirmChangeCallBack.class)) {
                        widget.commit(false);
                    }
                    if (context.getGedcom().hasChanged()) {
                        GedcomDirectory.getDefault().saveGedcom(context);
                    }
                }
            });
            timer.setRepeats(true);
            return timer;
        }
    }

    public static interface GedcomRegistryListener {
        public void gedcomRegistered(Context var1);

        public void gedcomUnregistered(Context var1);
    }

    public static class ContextNotFoundException
    extends Exception {
        public ContextNotFoundException(String message) {
            super(message);
        }
    }
}

