/*
 * Decompiled with CFR 0.152.
 */
package genj.report;

import genj.util.AncestrisUtils;
import genj.util.Resources;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ReportResources
extends Resources {
    private static final Logger LOG = Logger.getLogger("ancestris.util");
    private static Map<String, ReportResources> instances = new HashMap<String, ReportResources>();
    private volatile Map<String, String> key2string = null;
    private List<String> keys = null;
    private Locale locale = Locale.getDefault();
    private static final String userLanguage = Locale.getDefault().getLanguage();
    private WeakHashMap<String, MessageFormat> msgFormats = new WeakHashMap();

    public ReportResources() {
    }

    public ReportResources(InputStream in, Locale locale) {
        this();
        if (locale == null) {
            locale = Locale.getDefault();
        }
        this.locale = locale;
        if (in != null) {
            try {
                this.key2string = new HashMap<String, String>();
                this.keys = new ArrayList<String>(1000);
                this.load(in);
            }
            catch (IOException e) {
                Logger.getLogger("ancestris.util").log(Level.FINE, "can't read resources", e);
                this.key2string = null;
                this.keys = null;
            }
        }
    }

    private void load(InputStream in) throws IOException {
        ReportResources.load(in, this.keys, this.key2string, false);
    }

    public void load(InputStream in, boolean literate) throws IOException {
        ReportResources.load(in, this.keys, this.key2string, literate);
    }

    private static String trim(String s) {
        char c;
        int start;
        int len = s.length();
        for (start = 0; start < len && ('*' == (c = s.charAt(start)) || Character.isWhitespace(c)); ++start) {
        }
        return start == 0 ? s : s.substring(start);
    }

    private static void load(InputStream in, List<String> keys, Map<String, String> key2string, boolean literate) throws IOException {
        if (in == null) {
            throw new IOException("can't load resources from null");
        }
        try {
            String line;
            BufferedReader lines = new BufferedReader(new InputStreamReader(in, "UTF-8"));
            String last = null;
            int indent = 0;
            boolean comment = false;
            while ((line = lines.readLine()) != null) {
                int i;
                String trimmed;
                if (literate) {
                    if (comment) {
                        int close = line.lastIndexOf("*/");
                        if (close > 0) {
                            comment = false;
                            line = line.substring(close + 2);
                        }
                    } else {
                        int open = line.indexOf("/*");
                        if (open < 0) continue;
                        comment = true;
                        line = line.substring(open + 2).trim();
                    }
                }
                if ((trimmed = ReportResources.trim(line)).length() == 0) {
                    last = null;
                    continue;
                }
                if (last != null) {
                    if (trimmed.charAt(0) == '+') {
                        key2string.put(last, key2string.get(last) + "\n" + ReportResources.breakify(trimmed.substring(1)));
                        continue;
                    }
                    if (trimmed.charAt(0) == '&') {
                        key2string.put(last, key2string.get(last) + ReportResources.breakify(trimmed.substring(1)));
                        continue;
                    }
                    if (line.indexOf(trimmed) > indent) {
                        String appendto = key2string.get(last);
                        if (!appendto.endsWith(" ") && !appendto.endsWith("\n")) {
                            appendto = appendto + " ";
                        }
                        key2string.put(last, appendto + ReportResources.breakify(trimmed));
                        continue;
                    }
                }
                if ((i = trimmed.indexOf(61)) <= 0) continue;
                String key = trimmed.substring(0, i).trim();
                if (!literate && !Character.isJavaIdentifierStart(line.charAt(0))) continue;
                String val = ReportResources.trim(trimmed.substring(i + 1));
                keys.add(key);
                key = key.toLowerCase();
                key2string.put(key, ReportResources.breakify(val));
                last = key;
                indent = line.indexOf(trimmed);
            }
        }
        catch (UnsupportedEncodingException e) {
            throw new IOException(e.getMessage());
        }
    }

    private static String breakify(String string) {
        return AncestrisUtils.unescape((String)string);
    }

    public boolean contains(String key) {
        return this.getString(key, false) != null;
    }

    public String getString(String key, boolean notNull) {
        String lang;
        if (this.key2string == null) {
            return super.getString(key, notNull);
        }
        String result = null;
        String string = lang = this.locale != null ? this.locale.getLanguage() : userLanguage;
        if (lang != null) {
            String locKey = key + '.' + lang;
            result = this.key2string.get(locKey.toLowerCase());
        }
        if (result == null) {
            result = this.key2string.get(key.toLowerCase());
        }
        if (result == null && notNull) {
            result = key;
        }
        return result;
    }

    public String getString(String key) {
        return this.getString(key, true);
    }

    public String getString(String key, Object ... substitutes) {
        if (this.key2string == null) {
            return super.getString(key, substitutes);
        }
        MessageFormat format = this.msgFormats.get(key);
        if (format == null) {
            String string = this.getString(key, false);
            if (string == null) {
                return key;
            }
            format = ReportResources.getMessageFormat(string);
            this.msgFormats.put(key, format);
        }
        return format.format(substitutes);
    }

    private static MessageFormat getMessageFormat(String pattern) {
        if (pattern.indexOf(39) >= 0) {
            StringBuffer buffer = new StringBuffer(pattern.length() + 8);
            int j = pattern.length();
            for (int i = 0; i < j; ++i) {
                char c = pattern.charAt(i);
                buffer.append(c);
                if (c != '\'') continue;
                buffer.append('\'');
            }
            pattern = buffer.toString();
        }
        return new MessageFormat(pattern);
    }
}

