/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.editors.standard.tools;

import ancestris.modules.editors.standard.tools.EventWrapper;
import java.util.List;
import javax.swing.table.AbstractTableModel;
import org.openide.util.NbBundle;

public class EventTableModel
extends AbstractTableModel {
    private static int NBCOLUMNS = 3;
    private String[] columnNames = new String[]{NbBundle.getMessage(this.getClass(), (String)"COL_event"), NbBundle.getMessage(this.getClass(), (String)"COL_year"), NbBundle.getMessage(this.getClass(), (String)"COL_age")};
    private Object[][] data;

    public EventTableModel(List<EventWrapper> eventSet) {
        if (eventSet == null || eventSet.isEmpty()) {
            this.data = new Object[1][NBCOLUMNS];
            return;
        }
        this.data = new Object[eventSet.size()][NBCOLUMNS];
        int i = 0;
        for (EventWrapper event : eventSet) {
            this.data[i][0] = event.eventLabel;
            this.data[i][1] = event.eventYear;
            this.data[i][2] = event.eventAge;
            ++i;
        }
    }

    @Override
    public int getColumnCount() {
        return this.columnNames.length;
    }

    @Override
    public int getRowCount() {
        return this.data != null ? this.data.length : 0;
    }

    @Override
    public String getColumnName(int col) {
        return this.columnNames[col];
    }

    @Override
    public Object getValueAt(int row, int col) {
        return this.data != null ? this.data[row][col] : null;
    }

    public Class getColumnClass(int c) {
        return this.getValueAt(0, c) != null ? this.getValueAt(0, c).getClass() : String.class;
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        return false;
    }

    @Override
    public void setValueAt(Object value, int row, int col) {
        if (this.data == null) {
            return;
        }
        this.data[row][col] = value;
        this.fireTableCellUpdated(row, col);
    }

    public void clear() {
        this.data = null;
    }
}

