/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.editors.standard.tools;

import genj.gedcom.Indi;
import genj.gedcom.Property;
import genj.gedcom.PropertyDate;
import genj.gedcom.PropertyPlace;
import genj.util.WordBuffer;
import javax.swing.JLabel;
import org.openide.util.NbBundle;

public class EventLabel
extends JLabel {
    private String tag = "";
    private String tableLabel = "";
    private String shortLabel = "";
    private String longLabel = "";

    public EventLabel(Property property) {
        this.tag = property.getTag();
        if (property instanceof Indi) {
            this.shortLabel = NbBundle.getMessage(this.getClass(), (String)"IndiEventNameShort");
            this.longLabel = NbBundle.getMessage(this.getClass(), (String)"IndiEventNameLong");
            this.tableLabel = this.shortLabel;
        } else {
            Property place;
            String str = property.getPropertyName();
            if (str.contains(" ")) {
                str = str.substring(0, str.indexOf(" "));
            }
            this.shortLabel = str;
            if (this.tag.equals("EVEN")) {
                String type = property.getPropertyValue("TYPE");
                str = type.isEmpty() ? str : type;
            }
            this.tableLabel = str;
            WordBuffer buffer = new WordBuffer(" - ");
            buffer.append(this.shortLabel);
            Property date = property.getProperty("DATE");
            if (date != null) {
                PropertyDate pDate = (PropertyDate)date;
                buffer.append(pDate.getDisplayValue());
            }
            if ((place = property.getProperty("PLAC")) != null) {
                PropertyPlace pPlace = (PropertyPlace)place;
                buffer.append(pPlace.getCity());
            }
            this.longLabel = buffer.toString();
        }
        this.setText(this.shortLabel);
    }

    public String getTag() {
        return this.tag;
    }

    public String getTableLabel() {
        return this.tableLabel;
    }

    public String getShortLabel() {
        return this.shortLabel;
    }

    public String getLongLabel() {
        return this.longLabel;
    }
}

